/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers;

import java.lang.reflect.Field;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.PushLimitHandler;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.handlers.PushLimitOperateException;
import net.fabricmc.loader.api.FabricLoader;

public abstract class BasicStaticFieldRulePushLimitHandler
implements PushLimitHandler {
    private final String className;
    private final String fieldName;
    private final boolean modLoaded;
    private Field ruleField;

    public BasicStaticFieldRulePushLimitHandler(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
        this.modLoaded = FabricLoader.getInstance().isModLoaded(this.getModId());
        this.ruleField = null;
    }

    private Field getRuleField() throws ClassNotFoundException, NoSuchFieldException {
        if (this.ruleField != null) {
            return this.ruleField;
        }
        Class<?> clazz = Class.forName(this.className);
        Field field = clazz.getField(this.fieldName);
        field.setAccessible(true);
        this.ruleField = field;
        return field;
    }

    @Override
    public void setPushLimit(int pushLimit) throws PushLimitOperateException {
        if (!this.modLoaded) {
            throw new PushLimitOperateException();
        }
        try {
            this.getRuleField().setInt(null, pushLimit);
        }
        catch (Exception e) {
            throw new PushLimitOperateException(e);
        }
    }

    @Override
    public int getPushLimit() throws PushLimitOperateException {
        if (!this.modLoaded) {
            throw new PushLimitOperateException();
        }
        try {
            return this.getRuleField().getInt(null);
        }
        catch (Exception e) {
            throw new PushLimitOperateException(e);
        }
    }
}

