/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import org.jetbrains.annotations.NotNull;

public interface JsonSaveAble {
    default public JsonObject dumpToJson() {
        JsonObject jsonObject = new JsonObject();
        this.dumpToJson(jsonObject);
        return jsonObject;
    }

    public void dumpToJson(JsonObject var1);

    public void loadFromJson(JsonObject var1);

    default public void loadFromJsonSafe(JsonObject jsonObject) {
        try {
            this.loadFromJson(jsonObject);
        }
        catch (Exception e) {
            TweakerMoreMod.LOGGER.warn("Failed to load data of {} from json object {}: {}", new Object[]{this.getClass().getSimpleName(), jsonObject, e});
        }
    }

    default public <T extends Enum<T>> T getEnumSafe(JsonObject jsonObject, String key, @NotNull T fallbackValue) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            String jsonName = jsonElement.getAsString();
            try {
                return (T)Enum.valueOf(fallbackValue.getClass(), jsonName);
            }
            catch (Exception e) {
                TweakerMoreMod.LOGGER.warn("Failed to load data of {} from json object {}: {}", new Object[]{this.getClass().getSimpleName(), jsonObject, e});
            }
        }
        return fallbackValue;
    }
}

