/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.event.TickHandler;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import java.util.List;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.InfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.beacon.BeaconEffectRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.InfoViewCachedRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.commandBlock.CommandBlockContentRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.comparator.ComparatorLevelRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.growthSpeed.GrowthSpeedRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.hopper.HopperCooldownRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.redstoneDust.RedstoneDustUpdateOrderRenderer;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.RespawnBlockExplosionViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.structureBlock.StructureBlockContentRenderer;
import me.fallenbreath.tweakermore.util.render.TweakerMoreIRenderer;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContextImpl;
import net.minecraft.class_310;

public class InfoViewRenderer
implements TweakerMoreIRenderer,
IClientTickHandler {
    private static final InfoViewRenderer INSTANCE = new InfoViewRenderer();
    private static final List<InfoViewer> CONTENT_PREVIEWERS = Lists.newArrayList((Object[])new InfoViewer[]{new BeaconEffectRenderer(), new CommandBlockContentRenderer(), new ComparatorLevelRenderer(), new HopperCooldownRenderer(), new GrowthSpeedRenderer(), new RedstoneDustUpdateOrderRenderer(), new RespawnBlockExplosionViewer(), new StructureBlockContentRenderer()});
    private final InfoViewCachedRenderer cachedRenderer = new InfoViewCachedRenderer();

    private InfoViewRenderer() {
        TickHandler.getInstance().registerClientTickHandler((IClientTickHandler)this);
    }

    public static InfoViewRenderer getInstance() {
        return INSTANCE;
    }

    @Override
    public void onRenderWorldLast(WorldRenderContextImpl context) {
        if (!TweakerMoreConfigs.INFO_VIEW.getBooleanValue()) {
            return;
        }
        List<InfoViewer> viewers = CONTENT_PREVIEWERS.stream().filter(InfoViewer::isRenderEnabled).collect(Collectors.toList());
        if (viewers.isEmpty()) {
            return;
        }
        viewers.forEach(InfoViewer::onInfoViewStart);
        this.cachedRenderer.render(context, viewers);
        viewers.forEach(InfoViewer::onInfoViewEnd);
    }

    public void onClientTick(class_310 client) {
        this.cachedRenderer.onClientTick();
        CONTENT_PREVIEWERS.forEach(InfoViewer::onClientTick);
    }
}

