/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint;

import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint.ShulkerBoxItemContentHintCommon;
import me.fallenbreath.tweakermore.util.render.ColorHolder;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import me.fallenbreath.tweakermore.util.render.context.RenderGlobals;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_918;

public class ShulkerBoxItemContentHintRenderer {
    private static final int SLOT_WIDTH = 16;
    static final ThreadLocal<Boolean> isRendering = ThreadLocal.withInitial(() -> false);

    public static void render(class_4587 matrices, class_918 itemRenderer, class_1799 itemStack, int x, int y) {
        boolean mixedBox;
        ShulkerBoxItemContentHintCommon.Info info = ShulkerBoxItemContentHintCommon.prepareInformation(itemStack);
        if (!info.enabled) {
            return;
        }
        class_4587 textMatrixStack = matrices;
        textMatrixStack.method_22903();
        RenderContext renderContext = RenderContext.of(textMatrixStack);
        RenderUtils.Scaler scaler = RenderUtils.createScaler(x, y + 16, info.scale);
        scaler.apply(renderContext);
        if (info.allItemSame || info.allItemSameIgnoreNbt) {
            ShulkerBoxItemContentHintRenderer.renderMiniItem(renderContext, itemRenderer, info, x, y);
        }
        if (!info.allItemSame) {
            ShulkerBoxItemContentHintRenderer.renderText(textMatrixStack, 160.0, info, x, y);
        }
        scaler.restore();
        boolean bl = mixedBox = !info.allItemSameIgnoreNbt && !info.allItemSame;
        if ((!mixedBox || TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_SHOW_BAR_ON_MIXED.getBooleanValue()) && 0.0 < info.fillRatio && info.fillRatio < 1.0) {
            ShulkerBoxItemContentHintRenderer.renderBar(renderContext, itemRenderer, info.fillRatio, x, y);
        }
        textMatrixStack.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderMiniItem(RenderContext renderContext, class_918 itemRenderer, ShulkerBoxItemContentHintCommon.Info info, int x, int y) {
        isRendering.set(true);
        try {
            renderContext.getMatrixStack().pushMatrix();
            renderContext.getMatrixStack().translate(0.0, 0.0, 10.0);
            itemRenderer.method_4010(renderContext.getMatrixStack().asMcRaw(), info.stack, x, y);
        }
        finally {
            isRendering.set(false);
            renderContext.getMatrixStack().popMatrix();
        }
    }

    private static void renderText(class_4587 textMatrixStack, double zOffset, ShulkerBoxItemContentHintCommon.Info info, int x, int y) {
        String text = info.allItemSameIgnoreNbt ? "*" : "...";
        boolean putTextOnRight = info.allItemSameIgnoreNbt && info.scale <= 0.75;
        float width = RenderUtils.getRenderWidth(text);
        float height = RenderUtils.TEXT_HEIGHT;
        float textX = putTextOnRight ? (float)(x + 16) + 0.5f : (float)x + (16.0f - width) * 0.5f;
        float textY = putTextOnRight ? (float)y + (16.0f - height) * 0.5f : (float)(y + 16) - height - 3.0f;
        double textScale = (double)(16.0f / height) * 0.7 * (putTextOnRight ? 0.9 : 1.0);
        int textColor = 0xDDDDDD;
        RenderUtils.Scaler textScaler = RenderUtils.createScaler((double)textX + (double)width * 0.5, (double)textY + (double)height * 0.5, textScale);
        textScaler.apply(RenderContext.of(textMatrixStack));
        class_327 textRenderer = class_310.method_1551().field_1772;
        textMatrixStack.method_22904(0.0, 0.0, zOffset);
        class_4597.class_4598 immediate = RenderUtils.getVertexConsumer();
        textRenderer.method_27521(text, textX, textY, textColor, true, textMatrixStack.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, 0, 0xF000F0);
        immediate.method_22993();
        textScaler.restore();
    }

    private static void renderBar(RenderContext renderContext, class_918 itemRenderer, double fillRatio, int x, int y) {
        int HEIGHT = 8;
        boolean WIDTH = true;
        x = x + 16 - 1;
        y = y + 16 - 8;
        RenderGlobals.disableDepthTest();
        int h = (int)Math.round(fillRatio * 8.0);
        int color = class_3532.method_15369((float)((float)(fillRatio / 3.0)), (float)1.0f, (float)1.0f);
        if (h == 0) {
            h = 1;
            ColorHolder holder = ColorHolder.of(color);
            holder.red /= 2;
            holder.green /= 2;
            holder.blue /= 2;
            color = holder.pack();
        }
        GuiQuadDrawer drawer = (x_, y_, width_, height_, color_) -> class_332.method_25294((class_4587)renderContext.getMatrixStack().asMcRaw(), (int)x_, (int)y_, (int)(x_ + width_), (int)(y_ + height_), (int)(color_ | 0xFF000000));
        drawer.draw(x, y, 1, 8, 263172);
        drawer.draw(x, y + 8 - h, 1, h, color);
        RenderGlobals.enableDepthTest();
    }

    @FunctionalInterface
    private static interface GuiQuadDrawer {
        public void draw(int var1, int var2, int var3, int var4, int var5);
    }
}

