/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.mod_tweaks.serverDataSyncer.litematica;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.AreaSelectionUtil;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.ServerDataSyncer;
import me.fallenbreath.tweakermore.impl.mod_tweaks.serverDataSyncer.TargetPair;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require={@Condition(value="litematica")})
@Mixin(value={SchematicUtils.class})
public abstract class SchematicUtilsMixin {
    @Unique
    @Nullable
    private static String currentSyncingArenaName = null;
    @Unique
    private static final ThreadLocal<Boolean> dontInjectClone = ThreadLocal.withInitial(() -> false);

    @ModifyExpressionValue(method={"saveSchematic"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/selection/SelectionManager;getCurrentSelection()Lfi/dy/masa/litematica/selection/AreaSelection;", remap=false)}, remap=false)
    private static AreaSelection serverDataSyncer4SchematicSave(AreaSelection area) {
        if (TweakerMoreConfigs.SERVER_DATA_SYNCER.getBooleanValue()) {
            class_310 mc = class_310.method_1551();
            if (area != null && !mc.method_1496() && ServerDataSyncer.hasEnoughPermission()) {
                class_310.method_1551().method_18858(() -> SchematicUtilsMixin.syncEverything(area));
            }
        }
        return area;
    }

    @Inject(method={"cloneSelectionArea"}, at={@At(value="INVOKE_ASSIGN", target="Lfi/dy/masa/litematica/selection/SelectionManager;getCurrentSelection()Lfi/dy/masa/litematica/selection/AreaSelection;", shift=At.Shift.AFTER, remap=false)}, cancellable=true, remap=false)
    private static void serverDataSyncer4SelectionClone(class_310 mc, CallbackInfo ci, @Local AreaSelection area) {
        if (dontInjectClone.get().booleanValue()) {
            return;
        }
        ci.cancel();
        String name = currentSyncingArenaName;
        if (name != null) {
            SchematicUtilsMixin.showMessage$TKM(Message.MessageType.INFO, "clone_syncing", currentSyncingArenaName);
            return;
        }
        class_310.method_1551().method_18858(() -> {
            try {
                currentSyncingArenaName = area.getName();
                SchematicUtilsMixin.syncEverything(area);
                dontInjectClone.set(true);
                SchematicUtils.cloneSelectionArea((class_310)mc);
            }
            finally {
                currentSyncingArenaName = null;
                dontInjectClone.remove();
            }
        });
    }

    @Unique
    private static void syncEverything(AreaSelection area) {
        SchematicUtilsMixin.showMessage$TKM(Message.MessageType.INFO, "start", area.getName());
        TargetPair pair = AreaSelectionUtil.extractBlockEntitiesAndEntities(area, true);
        int beTotal = pair.getBlockEntityAmount();
        int eTotal = pair.getEntityAmount();
        AtomicLong lastUpdateTime = new AtomicLong(class_156.method_658());
        CompletableFuture<Void> future = ServerDataSyncer.getInstance().syncEverything(pair, (be, e) -> {
            long currentTime = class_156.method_658();
            if (currentTime - lastUpdateTime.get() > 500L) {
                lastUpdateTime.set(currentTime);
                String percent = String.format("%.1f%%", 100.0 * (double)(be + e) / (double)(beTotal + eTotal));
                SchematicUtilsMixin.showMessage$TKM(Message.MessageType.INFO, "progress", be, beTotal, e, eTotal, percent);
            }
        });
        future.thenRun(() -> SchematicUtilsMixin.showMessage$TKM(Message.MessageType.SUCCESS, "synced", beTotal, eTotal));
    }

    @Unique
    private static void showMessage$TKM(Message.MessageType type, String textName, Object ... args) {
        InfoUtils.showGuiOrInGameMessage((Message.MessageType)type, (int)3000, (String)("tweakermore.impl.serverDataSyncer.schematic_sync." + textName), (Object[])args);
    }
}

