/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import com.google.common.collect.Lists;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.List;
import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.listentries.SchematicBlockPlacementRestrictionHintType;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.ProPlaceUtils;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.BlockInteractionRestrictor;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.LooseCaseChecker;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.RestrictionUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class PlacementRestrictor {
    private static final List<class_2769<?>> FACING_PROPERTIES = Lists.newArrayList((Object[])new class_2769[]{class_2741.field_12525, class_2741.field_12481, class_2741.field_12545, class_2741.field_12532, class_2741.field_12518, class_2741.field_12496, class_2741.field_12529});

    private static void info(boolean condition, String key, Object ... args) {
        if (condition) {
            InfoUtils.printActionbarMessage((String)("tweakermore.impl.schematicBlockPlacementRestriction.info." + key), (Object[])args);
        }
    }

    public static boolean canDoBlockPlacement(class_310 mc, class_3965 hitResult, class_1750 context) {
        int MARGIN = TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_MARGIN.getIntegerValue();
        SchematicBlockPlacementRestrictionHintType hintType = (SchematicBlockPlacementRestrictionHintType)TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_HINT.getOptionListValue();
        class_2338 pos = context.method_8037();
        if (!WorldUtils.isPositionWithinRangeOfSchematicRegions((class_2338)pos, (int)MARGIN)) {
            return true;
        }
        LayerRange layerRange = DataManager.getRenderLayerRange();
        if (!RestrictionUtils.isWithinLayerRange(layerRange, pos, MARGIN)) {
            return true;
        }
        WorldSchematic schematicWorld = SchematicWorldHandler.getSchematicWorld();
        class_1937 realWorld = context.method_8045();
        class_1657 player = context.method_8036();
        if (schematicWorld != null && player != null && mc.field_1761 != null) {
            Optional<class_2680> stateToPlaceOptional;
            class_2338 interactPos = hitResult.method_17777();
            class_2680 interactWorldState = realWorld.method_8320(interactPos);
            class_2680 interactSchematicState = schematicWorld.method_8320(interactPos);
            BlockInteractionRestrictor.Result result = BlockInteractionRestrictor.checkInteract(player, interactWorldState, interactSchematicState);
            switch (result.getType()) {
                case GOOD_INTERACTION: {
                    return true;
                }
                case BAD_INTERACTION: {
                    PlacementRestrictor.info(hintType.showNotAllowed, "interaction_not_allowed", result.getMessage());
                    return false;
                }
            }
            class_2680 schematicState = schematicWorld.method_8320(pos);
            class_2248 schematicBlock = schematicState.method_26204();
            class_1799 schematicStack = ProPlaceUtils.getItemForState(schematicState, (class_1937)schematicWorld, pos);
            class_1799 stackToUse = RestrictionUtils.getPlayerUsingStack(player);
            if (RestrictionUtils.isItemInRestrictorWhitelist(stackToUse)) {
                return true;
            }
            if (!layerRange.isPositionWithinRange(pos)) {
                PlacementRestrictor.info(hintType.showNotPossible, "outside_the_layer", new Object[0]);
                return false;
            }
            if (!LooseCaseChecker.isLooseCheckSpecialCase(schematicState, schematicStack, stackToUse)) {
                if (schematicStack.method_7960()) {
                    PlacementRestrictor.info(hintType.showNotPossible, schematicState.method_26215() ? "is_air" : "no_block", schematicBlock.method_9518());
                    return false;
                }
                if (stackToUse.method_7909() != schematicStack.method_7909()) {
                    PlacementRestrictor.info(hintType.showWrongItem, "wrong_item", schematicStack.method_7964());
                    return false;
                }
            }
            if ((stateToPlaceOptional = RestrictionUtils.getStateToPlace(context, stackToUse)).isPresent()) {
                class_2771 targetSlabType;
                class_2680 stateToPlace = stateToPlaceOptional.get();
                class_2248 blockToPlace = stateToPlace.method_26204();
                if (!PlacementRestrictor.isBlockToPlaceCorrect(schematicState, stateToPlace)) {
                    PlacementRestrictor.info(hintType.showNotAllowed, "wrong_block_type", class_2378.field_11146.method_10221((Object)schematicBlock));
                    return false;
                }
                if (TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_CHECK_SLAB.getBooleanValue() && blockToPlace instanceof class_2482 && schematicBlock instanceof class_2482 && (targetSlabType = (class_2771)schematicState.method_11654((class_2769)class_2482.field_11501)) != class_2771.field_12682 && stateToPlace.method_11654((class_2769)class_2482.field_11501) != targetSlabType) {
                    PlacementRestrictor.info(hintType.showNotAllowed, "wrong_slab", targetSlabType);
                    return false;
                }
                if (TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_CHECK_FACING.getBooleanValue()) {
                    for (class_2769<?> property : FACING_PROPERTIES) {
                        if (!stateToPlace.method_28498(property) || !schematicState.method_28498(property) || stateToPlace.method_11654(property) == schematicState.method_11654(property)) continue;
                        PlacementRestrictor.info(hintType.showNotAllowed, "wrong_facing", schematicState.method_11654(property));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isBlockToPlaceCorrect(class_2680 schematicState, class_2680 stateToPlace) {
        class_2248 schematicBlock = schematicState.method_26204();
        class_2248 blockToPlace = stateToPlace.method_26204();
        if (LooseCaseChecker.isLooseCheckSpecialCase(schematicState, blockToPlace)) {
            return true;
        }
        if (schematicBlock instanceof class_2362 && blockToPlace == class_2246.field_10495) {
            return true;
        }
        if (schematicBlock instanceof class_2275 && blockToPlace == class_2246.field_10593) {
            return true;
        }
        return blockToPlace == schematicBlock;
    }
}

