/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.tunnelyrefab.ui.screens.MyWorldsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.ImageLoader;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.DownloadProtection;
import org.texboobcat.tunnelyrefab.worlds.ui.WorldBadge;

public class WorldBrowserScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private EditBox searchBox;
    private List<WorldInfo> worlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 85;
    private int maxScrollOffset = 0;
    private int currentPage = 0;
    private final int WORLDS_PER_PAGE = 20;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public WorldBrowserScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Community Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 150, 35, 250, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(100);
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search worlds..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd0d"), button -> this.performSearch()).m_252987_(centerX + 105, 35, 45, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25c0 Previous"), button -> this.previousPage()).m_252987_(centerX - 155, this.f_96544_ - 55, 75, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Next \u25b6"), button -> this.nextPage()).m_252987_(centerX + 80, this.f_96544_ - 55, 75, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Upload World"), button -> this.f_96541_.m_91152_((Screen)new WorldUploadScreen(this))).m_252987_(centerX - 155, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"My Worlds"), button -> this.f_96541_.m_91152_((Screen)new MyWorldsScreen(this))).m_252987_(centerX - 50, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 55, this.f_96544_ - 30, 100, 20).m_253136_());
        this.loadWorlds();
    }

    private void loadWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> loadedWorlds = this.worldManager.listPublicWorlds(20, this.currentPage * 20);
                this.f_96541_.execute(() -> {
                    this.worlds = loadedWorlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "No worlds found" : "Loaded " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void performSearch() {
        String query = this.searchBox.m_94155_().trim();
        if (query.isEmpty()) {
            this.loadWorlds();
            return;
        }
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Searching...";
        new Thread(() -> {
            try {
                List<WorldInfo> searchResults = this.worldManager.searchWorlds(query);
                this.f_96541_.execute(() -> {
                    this.worlds = searchResults;
                    this.scrollOffset = 0;
                    this.currentPage = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "\u00a7cNo worlds found for: " + query : "Found " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cSearch failed: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void downloadWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        DownloadProtection.DownloadCheckResult check = DownloadProtection.checkDownloadSafety(world);
        if (check.isBlocked()) {
            this.f_96541_.m_91152_((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFF5555, null));
            return;
        }
        if (check.isWarning()) {
            this.f_96541_.m_91152_((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFFAA00, () -> this.proceedWithDownload(world)));
            return;
        }
        this.proceedWithDownload(world);
    }

    private void proceedWithDownload(WorldInfo world) {
        this.loading = true;
        this.statusMessage = "Downloading " + world.getName() + "...";
        new Thread(() -> {
            try {
                WorldManager.DownloadResult result = this.worldManager.downloadWorld(world.getId(), Paths.get("saves", new String[0]), (percentage, currentFile) -> this.f_96541_.execute(() -> {
                    this.statusMessage = "Downloading... " + percentage + "%";
                }));
                this.f_96541_.execute(() -> {
                    this.loading = false;
                    this.statusMessage = result.isSuccess() ? "\u00a7a\u2713 " + result.getMessage() : "\u00a7c\u2717 " + result.getMessage();
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cDownload failed: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void viewWorldDetails(WorldInfo world) {
        this.f_96541_.m_91152_((Screen)new WorldDetailsScreen(this, world));
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.loadWorlds();
        }
    }

    private void nextPage() {
        if (this.worlds.size() >= 20) {
            ++this.currentPage;
            this.loadWorlds();
        }
    }

    private void updateMaxScroll() {
        int visibleHeight = this.f_96544_ - 130;
        int contentHeight = this.worlds.size() * 85;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "\ud83c\udf0d Community Worlds", this.f_96543_ / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 60, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (!this.worlds.isEmpty()) {
            String pageInfo = "Page " + (this.currentPage + 1);
            graphics.m_280137_(this.f_96547_, pageInfo, this.f_96543_ / 2, this.f_96544_ - 45, 0xAAAAAA);
        }
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 75;
        int endY = this.f_96544_ - 60;
        int centerX = this.f_96543_ / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.m_280588_(0, startY, this.f_96543_, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.worlds.size(); ++i) {
            WorldInfo world = this.worlds.get(i);
            int entryY = yOffset + i * 85;
            if (entryY + 85 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.m_280618_();
    }

    private void renderWorldEntry(GuiGraphics graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 85 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.m_280509_(x, y, x + width, y + 85 - 5, bgColor);
        graphics.m_280509_(x, y, x + width, y + 1, -12566464);
        graphics.m_280509_(x, y + 85 - 5, x + width, y + 85 - 4, -12566464);
        int thumbnailSize = 64;
        int thumbnailX = x + 5;
        int thumbnailY = y + 5;
        if (world.hasScreenshot()) {
            ResourceLocation screenshot = ImageLoader.loadImage(world.getScreenshotUrl());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280163_(screenshot, thumbnailX, thumbnailY, 0.0f, 0.0f, thumbnailSize, thumbnailSize, thumbnailSize, thumbnailSize);
        } else {
            graphics.m_280509_(thumbnailX, thumbnailY, thumbnailX + thumbnailSize, thumbnailY + thumbnailSize, -12566464);
            graphics.m_280137_(this.f_96547_, "No", thumbnailX + thumbnailSize / 2, thumbnailY + 20, 0x888888);
            graphics.m_280137_(this.f_96547_, "Image", thumbnailX + thumbnailSize / 2, thumbnailY + 32, 0x888888);
        }
        int textX = thumbnailX + thumbnailSize + 10;
        Object nameText = world.getName();
        if (world.isVerified()) {
            nameText = "\u2713 " + (String)nameText;
        }
        if (world.isFeatured()) {
            nameText = "\u2b50 " + (String)nameText;
        }
        graphics.m_280488_(this.f_96547_, (String)nameText, textX, y + 5, 0xFFFFFF);
        String authorLine = "\u00a77by " + world.getAuthorUsername() + " | " + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.m_280488_(this.f_96547_, authorLine, textX, y + 18, 0xAAAAAA);
        String detailsLine = "\u00a77" + world.getWorldType() + " | " + world.getMinecraftVersion() + " | \ud83d\udcbe " + world.getFormattedFileSize();
        graphics.m_280488_(this.f_96547_, detailsLine, textX, y + 31, 0xAAAAAA);
        Object desc = world.getDescription();
        if (((String)desc).length() > 45) {
            desc = ((String)desc).substring(0, 42) + "...";
        }
        graphics.m_280488_(this.f_96547_, "\u00a77" + (String)desc, textX, y + 44, 0x888888);
        WorldBadge.BadgeInfo securityBadge = WorldBadge.getSecurityBadge(world);
        if (securityBadge != null) {
            int badgeX = x + width - 75;
            int badgeY = y + 5;
            int badgeWidth = 70;
            int badgeHeight = 16;
            graphics.m_280509_(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, securityBadge.backgroundColor);
            graphics.m_280137_(this.f_96547_, securityBadge.text, badgeX + badgeWidth / 2, badgeY + 4, securityBadge.textColor);
        }
        int buttonY = y + 58;
        int buttonWidth = 80;
        int buttonHeight = 18;
        int buttonSpacing = 85;
        boolean viewDetailsHovered = this.isMouseOverButton(mouseX, mouseY, x + 5, buttonY, buttonWidth, buttonHeight);
        if (viewDetailsHovered) {
            graphics.m_280509_(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "details";
        } else {
            graphics.m_280509_(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.m_280137_(this.f_96547_, "View Details", x + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        if (!this.loading) {
            boolean downloadHovered = this.isMouseOverButton(mouseX, mouseY, x + buttonSpacing, buttonY, buttonWidth, buttonHeight);
            if (downloadHovered) {
                graphics.m_280509_(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147418368);
                this.hoveredWorld = world;
                this.hoveredButton = "download";
            } else {
                graphics.m_280509_(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147450880);
            }
            graphics.m_280137_(this.f_96547_, "\u2b07 Download", x + buttonSpacing + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("details")) {
                this.viewWorldDetails(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("download")) {
                this.downloadWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.m_94757_(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_93696_() && keyCode == 257) {
            this.performSearch();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7861_() {
        super.m_7861_();
    }
}

