/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldBrowserScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldUploadScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private EditBox nameBox;
    private EditBox descBox1;
    private EditBox descBox2;
    private EditBox descBox3;
    private EditBox versionBox;
    private EditBox tagBox;
    private List<String> availableWorlds = new ArrayList<String>();
    private int selectedWorldIndex = 0;
    private String worldType = "survival";
    private boolean isPublic = true;
    private boolean pruneChunks = true;
    private List<String> tags = new ArrayList<String>();
    private WorldScannerUtil.ScanResult scanResult = null;
    private boolean scanning = false;
    private boolean uploading = false;
    private String statusMessage = "";
    private int statusColor = 0xAAAAAA;
    private int uploadProgress = 0;

    public WorldUploadScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Upload World"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to upload worlds";
            this.statusColor = 0xFF5555;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Go to Login"), button -> this.f_96541_.m_91152_((Screen)new LoginScreen(this.parent))).m_252987_(this.f_96543_ / 2 - 75, this.f_96544_ / 2, 150, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 30, 100, 20).m_253136_());
            return;
        }
        int centerX = this.f_96543_ / 2;
        int leftX = centerX - 150;
        this.loadAvailableWorlds();
        String worldLabel = this.availableWorlds.isEmpty() ? "No worlds found" : (this.selectedWorldIndex < this.availableWorlds.size() ? this.availableWorlds.get(this.selectedWorldIndex) : "Select world");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)worldLabel), button -> this.cycleWorld()).m_252987_(leftX, 35, 300, 20).m_253136_());
        this.nameBox = new EditBox(this.f_96547_, leftX, 75, 300, 20, (Component)Component.m_237113_((String)"Name"));
        this.nameBox.m_94199_(100);
        this.nameBox.m_257771_((Component)Component.m_237113_((String)"World display name"));
        this.m_142416_((GuiEventListener)this.nameBox);
        this.descBox1 = new EditBox(this.f_96547_, leftX, 115, 300, 20, (Component)Component.m_237113_((String)"Description 1"));
        this.descBox1.m_94199_(166);
        this.descBox1.m_257771_((Component)Component.m_237113_((String)"Description line 1"));
        this.m_142416_((GuiEventListener)this.descBox1);
        this.descBox2 = new EditBox(this.f_96547_, leftX, 140, 300, 20, (Component)Component.m_237113_((String)"Description 2"));
        this.descBox2.m_94199_(166);
        this.descBox2.m_257771_((Component)Component.m_237113_((String)"Description line 2"));
        this.m_142416_((GuiEventListener)this.descBox2);
        this.descBox3 = new EditBox(this.f_96547_, leftX, 165, 300, 20, (Component)Component.m_237113_((String)"Description 3"));
        this.descBox3.m_94199_(166);
        this.descBox3.m_257771_((Component)Component.m_237113_((String)"Description line 3"));
        this.m_142416_((GuiEventListener)this.descBox3);
        this.versionBox = new EditBox(this.f_96547_, leftX, 205, 145, 20, (Component)Component.m_237113_((String)"Version"));
        this.versionBox.m_94199_(20);
        this.versionBox.m_94144_("1.20.1");
        this.m_142416_((GuiEventListener)this.versionBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)this.worldType), button -> this.cycleWorldType()).m_252987_(leftX + 155, 205, 145, 20).m_253136_());
        this.tagBox = new EditBox(this.f_96547_, leftX, 245, 250, 20, (Component)Component.m_237113_((String)"Tag"));
        this.tagBox.m_94199_(30);
        this.tagBox.m_257771_((Component)Component.m_237113_((String)"Add tag..."));
        this.m_142416_((GuiEventListener)this.tagBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> this.addTag()).m_252987_(leftX + 255, 245, 45, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.isPublic ? "Public" : "Private")), button -> this.toggleVisibility()).m_252987_(leftX, 285, 95, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.pruneChunks ? "Prune: ON" : "Prune: OFF")), button -> this.togglePruneChunks()).m_252987_(leftX + 100, 285, 95, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Scan World"), button -> this.scanWorld()).m_252987_(leftX + 200, 285, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Upload"), button -> this.uploadWorld()).m_252987_(centerX - 50, this.f_96544_ - 30, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 55, this.f_96544_ - 30, 100, 20).m_253136_());
        if (!this.availableWorlds.isEmpty()) {
            this.nameBox.m_94144_(this.availableWorlds.get(0));
            this.scanWorld();
        }
    }

    private void loadAvailableWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0])) {
                this.availableWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load worlds: " + e.getMessage());
        }
    }

    private void cycleWorld() {
        if (this.availableWorlds.isEmpty()) {
            return;
        }
        this.selectedWorldIndex = (this.selectedWorldIndex + 1) % this.availableWorlds.size();
        String worldName = this.availableWorlds.get(this.selectedWorldIndex);
        this.nameBox.m_94144_(worldName);
        this.scanWorld();
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void cycleWorldType() {
        String[] types = new String[]{"survival", "creative", "adventure", "spectator"};
        int currentIndex = Arrays.asList(types).indexOf(this.worldType);
        this.worldType = types[(currentIndex + 1) % types.length];
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void toggleVisibility() {
        this.isPublic = !this.isPublic;
    }

    private void togglePruneChunks() {
        this.pruneChunks = !this.pruneChunks;
    }

    private void addTag() {
        String tag = this.tagBox.m_94155_().trim().toLowerCase();
        if (!tag.isEmpty() && !this.tags.contains(tag) && this.tags.size() < 5) {
            this.tags.add(tag);
            this.tagBox.m_94144_("");
        }
    }

    private void removeTag(String tag) {
        this.tags.remove(tag);
    }

    private void scanWorld() {
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanning) {
            return;
        }
        this.scanning = true;
        this.statusMessage = "Scanning world for security issues...";
        this.statusColor = 0xFFFF55;
        String worldFolder = this.availableWorlds.get(this.selectedWorldIndex);
        new Thread(() -> {
            try {
                Path worldPath = Paths.get("saves", new String[0]).resolve(worldFolder);
                WorldScannerUtil.ScanResult result = WorldScannerUtil.scanWorld(worldPath);
                this.f_96541_.execute(() -> {
                    this.scanResult = result;
                    this.scanning = false;
                    if (result.isSafe()) {
                        this.statusMessage = "\u00a7a\u2713 Scan complete: Safe (" + result.getFileCount() + " files, " + result.getFormattedSize() + ")";
                        this.statusColor = 0x55FF55;
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Security issues found: " + result.getBlockedFiles().size() + " blocked files";
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.scanning = false;
                    this.statusMessage = "\u00a7cScan failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    private void uploadWorld() {
        if (this.uploading) {
            return;
        }
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanResult == null) {
            this.statusMessage = "\u00a7cPlease scan the world first";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!this.scanResult.isSafe()) {
            this.statusMessage = "\u00a7cWorld has security issues, cannot upload";
            this.statusColor = 0xFF5555;
            return;
        }
        String worldName = this.nameBox.m_94155_().trim();
        if (worldName.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a world name";
            this.statusColor = 0xFF5555;
            return;
        }
        this.uploading = true;
        this.statusMessage = "Preparing upload...";
        this.uploadProgress = 0;
        WorldUploadRequest request = new WorldUploadRequest();
        request.setWorldName(worldName);
        request.setWorldFolderName(this.availableWorlds.get(this.selectedWorldIndex));
        request.setDescription(this.descBox1.m_94155_() + "\n" + this.descBox2.m_94155_() + "\n" + this.descBox3.m_94155_());
        request.setMinecraftVersion(this.versionBox.m_94155_());
        request.setWorldType(this.worldType);
        request.setTags(new ArrayList<String>(this.tags));
        request.setPublic(this.isPublic);
        request.setPruneUninhabitedChunks(this.pruneChunks);
        request.setProgressCallback((percentage, currentFile) -> this.f_96541_.execute(() -> {
            this.uploadProgress = percentage;
            this.statusMessage = "Uploading... " + percentage + "%";
        }));
        new Thread(() -> {
            try {
                WorldManager.UploadResult result = this.worldManager.uploadWorld(request);
                this.f_96541_.execute(() -> {
                    this.uploading = false;
                    if (result.isSuccess()) {
                        this.statusMessage = "\u00a7a\u2713 " + result.getMessage();
                        this.statusColor = 0x55FF55;
                        new Thread(() -> {
                            try {
                                Thread.sleep(2000L);
                                this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)new WorldBrowserScreen(this.parent)));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 " + result.getMessage();
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.uploading = false;
                    this.statusMessage = "\u00a7cUpload failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "\ud83d\udce4 Upload World", this.f_96543_ / 2, 15, 0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int leftX = centerX - 150;
        graphics.m_280488_(this.f_96547_, "Select World:", leftX, 25, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Display Name:", leftX, 65, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Description:", leftX, 105, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "MC Version:", leftX, 195, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Tags:", leftX, 235, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Visibility:", leftX, 275, 0xFFFFFF);
        int tagY = 270;
        int tagX = leftX;
        for (String tag : this.tags) {
            graphics.m_280509_(tagX, tagY, tagX + 60, tagY + 15, -2143272896);
            graphics.m_280488_(this.f_96547_, tag, tagX + 3, tagY + 3, 0xFFFFFF);
            if (mouseX >= tagX + 52 && mouseX <= tagX + 58 && mouseY >= tagY + 2 && mouseY <= tagY + 13) {
                graphics.m_280509_(tagX + 52, tagY + 2, tagX + 58, tagY + 13, -2130771968);
                if (this.f_96541_.f_91067_.m_91560_()) {
                    this.removeTag(tag);
                }
            }
            graphics.m_280488_(this.f_96547_, "x", tagX + 53, tagY + 3, 0xFFFFFF);
            tagX += 65;
        }
        if (this.scanResult != null) {
            int boxY = 315;
            graphics.m_280509_(leftX, boxY, leftX + 300, boxY + 45, -2145378272);
            graphics.m_280509_(leftX, boxY, leftX + 300, boxY + 1, -12566464);
            if (this.scanResult.isSafe()) {
                graphics.m_280488_(this.f_96547_, "\u00a7aSize: " + this.scanResult.getFormattedSize() + " (uncompressed)", leftX + 5, boxY + 5, 0x55FF55);
                graphics.m_280488_(this.f_96547_, "\u00a7aFiles: " + this.scanResult.getFileCount(), leftX + 5, boxY + 18, 0x55FF55);
                graphics.m_280488_(this.f_96547_, "\u00a7aStatus: \u2713 Safe to upload", leftX + 5, boxY + 31, 0x55FF55);
            } else {
                graphics.m_280488_(this.f_96547_, "\u00a7cBlocked files: " + this.scanResult.getBlockedFiles().size(), leftX + 5, boxY + 5, 0xFF5555);
                graphics.m_280488_(this.f_96547_, "\u00a7cCannot upload - security issues", leftX + 5, boxY + 18, 0xFF5555);
                if (!this.scanResult.getBlockedFiles().isEmpty()) {
                    Object firstBlocked = this.scanResult.getBlockedFiles().get(0);
                    if (((String)firstBlocked).length() > 40) {
                        firstBlocked = ((String)firstBlocked).substring(0, 37) + "...";
                    }
                    graphics.m_280488_(this.f_96547_, "\u00a7c" + (String)firstBlocked, leftX + 5, boxY + 31, 0xFF5555);
                }
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 45, this.statusColor);
        }
        if (this.uploading && this.uploadProgress > 0) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = this.f_96544_ - 60;
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.m_280509_(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2141847723);
            graphics.m_280509_(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.m_280509_(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

