/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.CompressionProgressCallback;

public class WorldUploadRequest {
    private String worldName;
    private String worldFolderName;
    private String description;
    private String minecraftVersion;
    private String worldType = "survival";
    private List<String> tags = new ArrayList<String>();
    private boolean isPublic = true;
    private boolean pruneUninhabitedChunks;
    private CompressionProgressCallback progressCallback;

    public WorldUploadRequest() {
    }

    public WorldUploadRequest(String worldName, String worldFolderName) {
        this();
        this.worldName = worldName;
        this.worldFolderName = worldFolderName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public String getWorldFolderName() {
        return this.worldFolderName;
    }

    public void setWorldFolderName(String worldFolderName) {
        this.worldFolderName = worldFolderName;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion != null ? this.minecraftVersion : "Unknown";
    }

    public void setMinecraftVersion(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public String getWorldType() {
        return this.worldType != null ? this.worldType : "survival";
    }

    public void setWorldType(String worldType) {
        this.worldType = worldType;
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : new ArrayList<String>();
    }

    public void setTags(List<String> tags) {
        this.tags = tags != null ? tags : new ArrayList();
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isPruneUninhabitedChunks() {
        return this.pruneUninhabitedChunks;
    }

    public void setPruneUninhabitedChunks(boolean pruneUninhabitedChunks) {
        this.pruneUninhabitedChunks = pruneUninhabitedChunks;
    }

    public CompressionProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    public void setProgressCallback(CompressionProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    public String validate() {
        if (this.worldName == null || this.worldName.trim().isEmpty()) {
            return "World name is required";
        }
        if (this.worldFolderName == null || this.worldFolderName.trim().isEmpty()) {
            return "World folder name is required";
        }
        if (this.worldName.length() > 100) {
            return "World name is too long (max 100 characters)";
        }
        if (this.description != null && this.description.length() > 5000) {
            return "Description is too long (max 5000 characters)";
        }
        return null;
    }
}

