/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.ScanResultDetails;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;

public class ScanStatusRenderer {
    public static String getStatusText(WorldInfo world, boolean detailed) {
        if (world == null) {
            return "Unknown";
        }
        if (detailed && (world.isQuarantined() || "infected".equals(world.getScanStatus()))) {
            return world.getFormattedScanStatusWithThreat();
        }
        return world.getFormattedScanStatus();
    }

    public static List<String> getStatusTooltip(WorldInfo world) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (world == null) {
            tooltip.add("Unknown scan status");
            return tooltip;
        }
        tooltip.add("Scan Status: " + world.getFormattedScanStatus());
        if (world.getScanCompletedAt() != null) {
            tooltip.add("Last scanned: " + world.getScanCompletedAt());
        }
        if (world.isQuarantined()) {
            tooltip.add("");
            tooltip.add("\u26a0\ufe0f This world is quarantined");
            tooltip.add("It failed security scanning");
            ScanResultDetails details = world.getScanResultDetails();
            if (details != null) {
                tooltip.add("Threat: " + details.getFormattedThreatLevel());
                tooltip.add("");
                tooltip.add("Click 'View Report' for details");
            }
        } else if (world.isScanning()) {
            tooltip.add("");
            tooltip.add("Please wait while scanning...");
        } else if (world.isScanPending()) {
            tooltip.add("");
            tooltip.add("Waiting to be scanned");
        } else if ("clean".equals(world.getScanStatus())) {
            tooltip.add("");
            tooltip.add("\u2713 No threats detected");
        }
        return tooltip;
    }

    public static boolean shouldShowActionButtons(WorldInfo world) {
        if (world == null) {
            return false;
        }
        return world.isQuarantined() || "failed".equals(world.getScanStatus()) || world.isScanPending();
    }

    public static boolean shouldShowReportButton(WorldInfo world) {
        return world != null && world.isQuarantined();
    }

    public static boolean shouldShowRescanButton(WorldInfo world) {
        return world != null && ("failed".equals(world.getScanStatus()) || world.isScanPending());
    }

    public static String getWarningIcon(WorldInfo world) {
        if (world == null) {
            return "";
        }
        if (world.isQuarantined()) {
            return "\u26a0";
        }
        if (world.isHighThreat()) {
            return "\u26a0";
        }
        if ("failed".equals(world.getScanStatus())) {
            return "\u274c";
        }
        if ("clean".equals(world.getScanStatus())) {
            return "\u2713";
        }
        return "";
    }

    public static List<String> getWorldSummary(WorldInfo world) {
        ArrayList<String> summary = new ArrayList<String>();
        if (world == null) {
            return summary;
        }
        summary.add(world.getName());
        summary.add("Status: " + ScanStatusRenderer.getStatusText(world, true));
        summary.add("Downloads: " + world.getFormattedDownloadCount());
        if (world.getRatingCount() > 0) {
            summary.add("Rating: " + world.getFormattedRating());
        }
        return summary;
    }

    public static String getDownloadBlockReason(WorldInfo world) {
        if (world == null) {
            return "World not found";
        }
        if (world.isQuarantined()) {
            return "\u26a0\ufe0f This world is quarantined and cannot be downloaded.\nIt failed security scanning.";
        }
        return null;
    }

    public static String getDownloadWarning(WorldInfo world) {
        if (world == null) {
            return null;
        }
        if (world.isScanning()) {
            return "\u23f3 This world is currently being scanned.\nPlease try again in a few moments.";
        }
        if (world.isScanPending()) {
            return "\u23f1\ufe0f This world hasn't been scanned yet.\nIt may contain unsafe content.\n\nDownload anyway?";
        }
        return null;
    }
}

