/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.messaging;

import java.security.KeyPair;
import javax.crypto.BadPaddingException;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.MessageEncryption;

public class EncryptionKeyManager {
    public static boolean ensureKeysExist() {
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.hasEncryptionKeys()) {
            System.out.println("[Tunnely E2EE] Keys already exist");
            return true;
        }
        System.out.println("[Tunnely E2EE] Generating new encryption keys...");
        try {
            KeyPair keyPair = MessageEncryption.generateKeyPair();
            String publicKeyStr = MessageEncryption.publicKeyToString(keyPair.getPublic());
            String privateKeyStr = MessageEncryption.privateKeyToString(keyPair.getPrivate());
            config.setPublicKey(publicKeyStr);
            config.setEncryptedPrivateKey(privateKeyStr);
            System.out.println("[Tunnely E2EE] \u2713 Keys generated and stored locally");
            SupabaseClient client = new SupabaseClient();
            boolean uploaded = client.uploadPublicKey(publicKeyStr);
            if (uploaded) {
                System.out.println("[Tunnely E2EE] \u2713 Public key uploaded to database");
                return true;
            }
            System.err.println("[Tunnely E2EE] \u2717 Failed to upload public key");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] \u2717 Failed to generate keys: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static String getPrivateKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String privateKey = config.getEncryptedPrivateKey();
        if (privateKey.isEmpty()) {
            return null;
        }
        return privateKey;
    }

    public static String getPublicKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String publicKey = config.getPublicKey();
        return publicKey.isEmpty() ? null : publicKey;
    }

    public static String fetchRecipientPublicKey(String recipientId) {
        SupabaseClient client = new SupabaseClient();
        return client.fetchPublicKey(recipientId);
    }

    public static String encryptMessage(String message, String recipientId) {
        try {
            String recipientPublicKey = EncryptionKeyManager.fetchRecipientPublicKey(recipientId);
            if (recipientPublicKey == null) {
                System.err.println("[Tunnely E2EE] Recipient has no public key, sending unencrypted");
                return null;
            }
            return MessageEncryption.encryptWithKey(message, recipientPublicKey);
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Failed to encrypt message: " + e.getMessage());
            return null;
        }
    }

    public static String decryptMessage(String encryptedMessage) {
        try {
            if (!MessageEncryption.isEncrypted(encryptedMessage)) {
                return encryptedMessage;
            }
            String privateKey = EncryptionKeyManager.getPrivateKey();
            if (privateKey == null || privateKey.isEmpty()) {
                System.err.println("[Tunnely E2EE] Cannot decrypt: no private key available");
                return "[\ud83d\udd12 Encrypted - No keys]";
            }
            String decrypted = MessageEncryption.decryptWithKey(encryptedMessage, privateKey);
            return decrypted;
        }
        catch (BadPaddingException e) {
            System.err.println("[Tunnely E2EE] Decryption failed: Message encrypted with different key");
            return "[\ud83d\udd12 Encrypted - Wrong key]";
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Decryption error: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return "[\ud83d\udd12 Encrypted - Error]";
        }
    }

    public static boolean verifyAndRepairPublicKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String userId = config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely E2EE] Cannot verify public key: not authenticated");
            return false;
        }
        try {
            SupabaseClient client = new SupabaseClient();
            String dbPublicKey = client.fetchPublicKey(userId);
            if (dbPublicKey != null && !dbPublicKey.isEmpty()) {
                System.out.println("[Tunnely E2EE] \u2713 Public key verified in database");
                return true;
            }
            System.out.println("[Tunnely E2EE] \u26a0 Public key missing from database");
            if (config.hasEncryptionKeys()) {
                String localPublicKey = config.getPublicKey();
                System.out.println("[Tunnely E2EE] Re-uploading existing local public key...");
                boolean uploaded = client.uploadPublicKey(localPublicKey);
                if (uploaded) {
                    System.out.println("[Tunnely E2EE] \u2713 Public key re-uploaded to database");
                    return true;
                }
                System.err.println("[Tunnely E2EE] \u2717 Failed to re-upload public key");
                return false;
            }
            System.out.println("[Tunnely E2EE] Generating new encryption keys...");
            return EncryptionKeyManager.ensureKeysExist();
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Error verifying public key: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

