/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.presence;

import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class PresenceManager {
    private static PresenceManager instance;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "Tunnely-Presence");
        thread.setDaemon(true);
        return thread;
    });
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final TunnelConfig config = TunnelConfig.getInstance();
    private static final int HEARTBEAT_INTERVAL_SECONDS = 60;

    private PresenceManager() {
    }

    public static synchronized PresenceManager getInstance() {
        if (instance == null) {
            instance = new PresenceManager();
        }
        return instance;
    }

    public void start() {
        if (this.running.get()) {
            System.out.println("[Tunnely Presence] Already running");
            return;
        }
        if (!this.config.isAuthenticated()) {
            System.out.println("[Tunnely Presence] Not authenticated, not starting presence updates");
            return;
        }
        this.running.set(true);
        System.out.println("[Tunnely Presence] Starting presence heartbeats (every 60 seconds)");
        this.sendHeartbeat();
        this.scheduler.scheduleAtFixedRate(this::sendHeartbeat, 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (!this.running.get()) {
            return;
        }
        this.running.set(false);
        System.out.println("[Tunnely Presence] Stopping presence heartbeats");
    }

    private void sendHeartbeat() {
        if (!this.running.get()) {
            return;
        }
        try {
            SupabaseClient client = new SupabaseClient();
            boolean success = client.updatePresence();
            if (success) {
                System.out.println("[Tunnely Presence] \u2713 Heartbeat sent");
            } else {
                System.err.println("[Tunnely Presence] \u2717 Failed to send heartbeat");
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Presence] Error sending heartbeat: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void shutdown() {
        this.stop();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
        }
        System.out.println("[Tunnely Presence] Shutdown complete");
    }

    public static OnlineStatus getOnlineStatus(String lastSeenIso) {
        if (lastSeenIso == null || lastSeenIso.isEmpty()) {
            return OnlineStatus.OFFLINE;
        }
        try {
            long lastSeenMillis = PresenceManager.parseIsoTimestamp(lastSeenIso);
            long currentMillis = System.currentTimeMillis();
            long diffMinutes = (currentMillis - lastSeenMillis) / 60000L;
            if (diffMinutes < 2L) {
                return OnlineStatus.ONLINE;
            }
            if (diffMinutes < 5L) {
                return OnlineStatus.AWAY;
            }
            return OnlineStatus.OFFLINE;
        }
        catch (Exception e) {
            System.err.println("[Tunnely Presence] Error parsing timestamp: " + e.getMessage());
            return OnlineStatus.OFFLINE;
        }
    }

    private static long parseIsoTimestamp(String isoTimestamp) throws Exception {
        String cleaned = isoTimestamp.replace("Z", "+00:00");
        Instant instant = Instant.parse(cleaned);
        return instant.toEpochMilli();
    }

    public static enum OnlineStatus {
        ONLINE("\u00a7a\u25cf", "Online", 0x55FF55),
        AWAY("\u00a7e\u25cf", "Away", 0xFFFF55),
        OFFLINE("\u00a77\u25cf", "Offline", 0x555555);

        public final String indicator;
        public final String label;
        public final int color;

        private OnlineStatus(String indicator, String label, int color) {
            this.indicator = indicator;
            this.label = label;
            this.color = color;
        }
    }
}

