/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.RelayValidator;
import org.texboobcat.tunnelyrefab.tunnel.HeartbeatManager;
import org.texboobcat.tunnelyrefab.tunnel.HostProxyServer;
import org.texboobcat.tunnelyrefab.tunnel.ModDetector;
import org.texboobcat.tunnelyrefab.tunnel.PortForwardError;
import org.texboobcat.tunnelyrefab.tunnel.TunnelClient;
import org.texboobcat.tunnelyrefab.tunnel.UdpProxyServer;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;

public class TunnelManager {
    private static TunnelManager instance;
    private final TunnelConfig config;
    private final SupabaseClient supabaseClient;
    private TunnelClient tunnelClient;
    private HeartbeatManager heartbeatManager;
    private HostProxyServer hostProxyServer;
    private final Map<Integer, UdpProxyServer> udpProxyServers = new HashMap<Integer, UdpProxyServer>();
    private MinecraftServer server;
    private String currentSessionId;
    private String publicEndpoint;
    private Runnable disconnectListener = null;
    private List<PortForwardingConfig> activePortForwards = new ArrayList<PortForwardingConfig>();
    private String selectedRelayId;
    private String selectedRelayRegion;
    private String selectedRelayUrl;
    private List<RelayCandidate> sortedRelays = new ArrayList<RelayCandidate>();

    private TunnelManager() {
        this.config = TunnelConfig.getInstance();
        this.supabaseClient = new SupabaseClient();
    }

    public static TunnelManager getInstance() {
        if (instance == null) {
            instance = new TunnelManager();
        }
        return instance;
    }

    public boolean initializeTunnel(MinecraftServer server, String visibility, String serverName) {
        return this.initializeTunnel(server, visibility, serverName, new ArrayList<PortForwardingConfig>());
    }

    public boolean initializeTunnel(MinecraftServer server, String visibility, String serverName, List<PortForwardingConfig> portForwards) {
        List<String> validationErrors;
        List<PortForwardingConfig> list = this.activePortForwards = portForwards != null ? new ArrayList<PortForwardingConfig>(portForwards) : new ArrayList();
        if (!this.config.isEnableTunneling()) {
            System.out.println("[Tunnely] Tunneling is disabled in config");
            return false;
        }
        this.server = server;
        if (!this.config.isAuthenticated()) {
            System.out.println("[Tunnely] Not authenticated. Please use /tunnel login <email> <password>");
            return false;
        }
        if (!this.supabaseClient.isTokenValid()) {
            System.out.println("[Tunnely] Authentication token expired. Please login again.");
            return false;
        }
        boolean isDedicatedServer = !server.m_129792_();
        int serverPort = server.m_7010_();
        if (isDedicatedServer) {
            System.out.println("[Tunnely] Detected dedicated server mode");
            if (serverPort <= 0) {
                System.err.println("[Tunnely] Failed to get server port. Make sure server.properties has a valid server-port configured.");
                return false;
            }
            System.out.println("[Tunnely] Using dedicated server port: " + serverPort);
        } else {
            System.out.println("[Tunnely] Detected single-player/LAN mode");
            if (serverPort == -1) {
                System.out.println("[Tunnely] Server not opened to LAN, opening now...");
                try {
                    String configuredGamemode = this.config.getDefaultGamemode();
                    GameType gameType = switch (configuredGamemode.toLowerCase()) {
                        case "creative" -> GameType.CREATIVE;
                        case "adventure" -> GameType.ADVENTURE;
                        case "spectator" -> GameType.SPECTATOR;
                        default -> GameType.SURVIVAL;
                    };
                    boolean allowCommands = server.m_129910_().m_5468_();
                    System.out.println("[Tunnely] Opening to LAN with gamemode: " + configuredGamemode);
                    boolean success = server.m_7386_(gameType, allowCommands, 25565);
                    if (success) {
                        serverPort = server.m_7010_();
                        if (serverPort <= 0) {
                            System.err.println("[Tunnely] Failed to get port after opening to LAN");
                            return false;
                        }
                    } else {
                        System.err.println("[Tunnely] Failed to open to LAN (publishServer returned false)");
                        return false;
                    }
                    System.out.println("[Tunnely] Opened to LAN on port: " + serverPort);
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Failed to open to LAN: " + e.getMessage());
                    e.printStackTrace();
                    return false;
                }
            } else {
                System.out.println("[Tunnely] Using existing LAN port: " + serverPort);
            }
        }
        String gameMode = "survival";
        Object minecraftUuid = this.config.getMinecraftUuid();
        if (minecraftUuid == null || ((String)minecraftUuid).isEmpty()) {
            if (isDedicatedServer) {
                minecraftUuid = "dedicated-server-" + System.getProperty("user.name", "unknown");
                System.out.println("[Tunnely] Using dedicated server identifier: " + (String)minecraftUuid);
            } else if (server.m_236731_() != null) {
                minecraftUuid = server.m_236731_().getId().toString();
                this.config.setMinecraftUuid((String)minecraftUuid);
            } else {
                System.err.println("[Tunnely] Unable to determine Minecraft UUID");
                return false;
            }
            this.config.setMinecraftUuid((String)minecraftUuid);
        }
        String validVisibility = visibility;
        if (!(visibility.equals("public") || visibility.equals("friends_only") || visibility.equals("invite_only"))) {
            System.out.println("[Tunnely] Invalid visibility '" + visibility + "', defaulting to 'invite_only'");
            validVisibility = "invite_only";
        }
        System.out.println("[Tunnely] Detecting compatibility information...");
        CompatibilityDetector.CompatibilityInfo compatibility = CompatibilityDetector.detect();
        System.out.println("[Tunnely] Detected: " + compatibility.toString());
        this.selectBestRelay();
        String relayUrlForRegistration = this.selectedRelayUrl != null ? this.selectedRelayUrl : this.config.getRelayServerUrl();
        RelayValidator.RelaySecurityStatus securityStatus = RelayValidator.validateRelayConfig();
        if (!securityStatus.isTrusted()) {
            System.out.println("[Tunnely Security] WARNING: Connecting to untrusted relay: " + relayUrlForRegistration);
            System.out.println("[Tunnely Security] " + securityStatus.message);
        }
        String relayIdForRegistration = this.selectedRelayId != null ? this.selectedRelayId : "default";
        String relayRegionForRegistration = this.selectedRelayRegion != null ? this.selectedRelayRegion : "NA";
        int maxPlayers = server.m_7418_();
        System.out.println("[Tunnely] Server capacity: " + maxPlayers + " max players");
        System.out.println("[Tunnely] Registering server session with visibility: " + validVisibility);
        SupabaseClient.ServerRegistrationResult result = this.supabaseClient.registerServer((String)minecraftUuid, serverPort, gameMode, validVisibility, serverName, compatibility.minecraftVersion, compatibility.modLoader, compatibility.modpackId, compatibility.modpackVersion, relayIdForRegistration, relayRegionForRegistration, relayUrlForRegistration, maxPlayers, this.activePortForwards);
        if (!result.success) {
            System.err.println("[Tunnely] Failed to register server: " + result.error);
            return false;
        }
        this.currentSessionId = result.sessionId;
        System.out.println("[Tunnely] Server session registered: " + this.currentSessionId);
        if (!this.activePortForwards.isEmpty() && !(validationErrors = ModDetector.validatePortForwards(this.activePortForwards)).isEmpty()) {
            System.err.println("[Tunnely] Port forwarding validation failed:");
            for (String error : validationErrors) {
                System.err.println("  - " + error);
            }
            System.err.println("[Tunnely] Disabling conflicting port forwards...");
            for (PortForwardingConfig config : this.activePortForwards) {
                for (String error : validationErrors) {
                    if (!error.contains(config.getServiceName())) continue;
                    config.setEnabled(false);
                    System.err.println("  Disabled: " + config.getServiceName());
                }
            }
        }
        if (this.establishTunnel()) {
            block45: {
                ArrayList<PortForwardingConfig> enabledForwards = new ArrayList<PortForwardingConfig>();
                for (PortForwardingConfig config : this.activePortForwards) {
                    if (!config.isEnabled()) continue;
                    enabledForwards.add(config);
                }
                if (!enabledForwards.isEmpty()) {
                    System.out.println("[Tunnely] Requesting port forwarding for " + enabledForwards.size() + " service(s)...");
                    this.tunnelClient.requestPortForwarding(enabledForwards);
                    try {
                        String error;
                        boolean portForwardSuccess = this.tunnelClient.awaitPortForwarding(5L, TimeUnit.SECONDS);
                        if (portForwardSuccess && this.tunnelClient.isPortForwardingComplete()) {
                            this.initializeAdditionalProxies();
                            System.out.println("[Tunnely] \u2713 Port forwarding established for " + enabledForwards.size() + " service(s)");
                            break block45;
                        }
                        error = this.tunnelClient.getPortForwardingError();
                        PortForwardError portError = PortForwardError.TIMEOUT;
                        if (error != null && !error.isEmpty()) {
                            System.err.println("[Tunnely] Port forwarding failed: " + error);
                        } else {
                            System.err.println("[Tunnely] Port forwarding failed: " + portError.getFullMessage());
                        }
                        System.err.println("[Tunnely] Voice chat and other services may not work. Continuing with main Minecraft port only.");
                    }
                    catch (InterruptedException e) {
                        System.err.println("[Tunnely] Port forwarding request interrupted");
                        System.err.println("[Tunnely] Continuing with main Minecraft port only");
                    }
                } else {
                    System.out.println("[Tunnely] No additional port forwarding requested");
                }
            }
            this.heartbeatManager = new HeartbeatManager(this.currentSessionId, server);
            this.heartbeatManager.start();
            return true;
        }
        return false;
    }

    private void selectBestRelay() {
        try {
            ArrayList<TunnelConfig.RelayEndpoint> relaysToTest;
            ArrayList<TunnelConfig.RelayEndpoint> dbRelays = new ArrayList<TunnelConfig.RelayEndpoint>();
            ArrayList<TunnelConfig.RelayEndpoint> configRelays = new ArrayList<TunnelConfig.RelayEndpoint>();
            boolean dbAvailable = false;
            System.out.println("[Tunnely] Fetching relays from database...");
            try {
                SupabaseClient.RelayListResult dbResult = this.supabaseClient.getAvailableRelays();
                if (dbResult.success && dbResult.data != null) {
                    JsonArray relaysArray = JsonParser.parseString((String)dbResult.data).getAsJsonArray();
                    System.out.println("[Tunnely] Found " + relaysArray.size() + " relay(s) in database");
                    for (JsonElement elem : relaysArray) {
                        String url;
                        JsonObject relay = elem.getAsJsonObject();
                        String id = relay.has("id") ? relay.get("id").getAsString() : null;
                        String region = relay.has("region") ? relay.get("region").getAsString() : "Unknown";
                        String string = url = relay.has("url") ? relay.get("url").getAsString() : null;
                        if (id == null || url == null) continue;
                        dbRelays.add(new TunnelConfig.RelayEndpoint(id, region, url));
                    }
                    if (!dbRelays.isEmpty()) {
                        dbAvailable = true;
                    }
                } else {
                    System.out.println("[Tunnely] Could not fetch relays from database: " + dbResult.error);
                }
            }
            catch (Exception e) {
                System.out.println("[Tunnely] Error fetching relays from database: " + e.getMessage());
            }
            List<TunnelConfig.RelayEndpoint> configRelayList = this.config.getRelays();
            if (configRelayList != null && !configRelayList.isEmpty()) {
                configRelays.addAll(configRelayList);
            }
            if (dbAvailable) {
                System.out.println("[Tunnely] Using " + dbRelays.size() + " relay(s) from database");
                relaysToTest = dbRelays;
            } else if (!configRelays.isEmpty()) {
                System.out.println("[Tunnely] Database unavailable, falling back to " + configRelays.size() + " config relay(s)");
                relaysToTest = configRelays;
            } else {
                System.out.println("[Tunnely] No relays configured, using single relay: " + this.config.getRelayServerUrl());
                this.selectedRelayId = "default";
                this.selectedRelayRegion = "NA";
                this.selectedRelayUrl = this.config.getRelayServerUrl();
                this.sortedRelays.clear();
                this.sortedRelays.add(new RelayCandidate(this.selectedRelayId, this.selectedRelayRegion, this.selectedRelayUrl, 0L));
                return;
            }
            OkHttpClient http = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).readTimeout(2L, TimeUnit.SECONDS).build();
            ArrayList<RelayCandidate> candidates = new ArrayList<RelayCandidate>();
            for (TunnelConfig.RelayEndpoint r : relaysToTest) {
                Object healthUrl;
                if (r == null || r.url == null || r.url.isEmpty()) continue;
                Object object = r.url.startsWith("wss://") ? r.url.replaceFirst("wss://", "https://") : (healthUrl = r.url.startsWith("ws://") ? r.url.replaceFirst("ws://", "http://") : r.url);
                if (!((String)healthUrl).endsWith("/health")) {
                    healthUrl = (String)healthUrl + "/health";
                }
                try {
                    long start = System.nanoTime();
                    Request req = new Request.Builder().url((String)healthUrl).get().build();
                    Response resp = http.newCall(req).execute();
                    try {
                        if (resp.isSuccessful()) {
                            long elapsedMs = (System.nanoTime() - start) / 1000000L;
                            System.out.println("[Tunnely] Relay " + r.id + " (" + r.region + ") latency: " + elapsedMs + "ms");
                            candidates.add(new RelayCandidate(r.id != null ? r.id : "unknown", r.region != null ? r.region : "unknown", r.url, elapsedMs));
                            continue;
                        }
                        System.out.println("[Tunnely] Relay " + r.id + " (" + r.region + ") health check failed: HTTP " + resp.code());
                    }
                    finally {
                        if (resp == null) continue;
                        resp.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("[Tunnely] Relay " + r.id + " (" + r.region + ") health check error: " + e.getMessage());
                }
            }
            candidates.sort((a, b) -> Long.compare(a.latencyMs, b.latencyMs));
            this.sortedRelays = candidates;
            if (!this.sortedRelays.isEmpty()) {
                RelayCandidate best = this.sortedRelays.get(0);
                this.selectedRelayId = best.id;
                this.selectedRelayRegion = best.region;
                this.selectedRelayUrl = best.url;
                System.out.println("[Tunnely] Selected relay => ID:" + this.selectedRelayId + ", Region:" + this.selectedRelayRegion + ", URL:" + this.selectedRelayUrl);
                System.out.println("[Tunnely] Failover available: " + (this.sortedRelays.size() - 1) + " backup relay(s)");
            } else {
                System.out.println("[Tunnely] No relay responded to health check; using default relayServerUrl");
                this.selectedRelayId = "default";
                this.selectedRelayRegion = "NA";
                this.selectedRelayUrl = this.config.getRelayServerUrl();
                this.sortedRelays.clear();
                this.sortedRelays.add(new RelayCandidate(this.selectedRelayId, this.selectedRelayRegion, this.selectedRelayUrl, 0L));
            }
        }
        catch (Exception e) {
            System.out.println("[Tunnely] Relay selection failed: " + e.getMessage());
            this.selectedRelayId = "default";
            this.selectedRelayRegion = "NA";
            this.selectedRelayUrl = this.config.getRelayServerUrl();
            this.sortedRelays.clear();
            this.sortedRelays.add(new RelayCandidate(this.selectedRelayId, this.selectedRelayRegion, this.selectedRelayUrl, 0L));
        }
    }

    private boolean establishTunnel() {
        for (int attempt = 0; attempt < this.sortedRelays.size(); ++attempt) {
            RelayCandidate relay = this.sortedRelays.get(attempt);
            if (attempt > 0) {
                System.out.println("[Tunnely] Primary relay failed, trying failover relay " + attempt + ": " + relay.id + " (" + relay.region + ")");
                this.selectedRelayId = relay.id;
                this.selectedRelayRegion = relay.region;
                this.selectedRelayUrl = relay.url;
            }
            try {
                URI relayUri = new URI(relay.url);
                this.tunnelClient = new TunnelClient(relayUri, this.config.getUserJwtToken(), this::handleIncomingPacket, this.currentSessionId);
                System.out.println("[Tunnely] Connecting to relay server: " + String.valueOf(relayUri));
                this.tunnelClient.connect();
                boolean connected = this.tunnelClient.awaitConnection(10L, TimeUnit.SECONDS);
                if (!connected) {
                    System.err.println("[Tunnely] Failed to connect to relay server (timeout)");
                    if (attempt < this.sortedRelays.size() - 1) {
                        System.out.println("[Tunnely] Retrying with next relay...");
                        continue;
                    }
                    return false;
                }
                System.out.println("[Tunnely] Connection established, completing handshake...");
                this.tunnelClient.setDisconnectListener(() -> {
                    System.out.println("[Tunnely] Relay connection lost!");
                    if (this.disconnectListener != null) {
                        this.disconnectListener.run();
                    }
                });
                boolean handshakeComplete = this.tunnelClient.awaitHandshake(5L, TimeUnit.SECONDS);
                if (!handshakeComplete) {
                    System.err.println("[Tunnely] Failed to complete secure handshake (timeout)");
                    this.tunnelClient.close();
                    if (attempt < this.sortedRelays.size() - 1) {
                        System.out.println("[Tunnely] Retrying with next relay...");
                        continue;
                    }
                    return false;
                }
                System.out.println("[Tunnely] Secure handshake completed successfully");
                Thread.sleep(1000L);
                this.publicEndpoint = this.tunnelClient.getPublicEndpoint();
                if (this.publicEndpoint != null) {
                    this.hostProxyServer = new HostProxyServer(this.server.m_7010_(), this.tunnelClient);
                    this.tunnelClient.setHostProxyServer(this.hostProxyServer);
                    System.out.println("[Tunnely] TCP proxy initialized for Minecraft server (port " + this.server.m_7010_() + ")");
                    boolean endpointUpdated = this.supabaseClient.updateServerEndpoint(this.currentSessionId, this.publicEndpoint);
                    if (!endpointUpdated) {
                        System.err.println("[Tunnely] Warning: Failed to update public endpoint in database");
                    }
                    System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    System.out.println("[Tunnely] Tunnel established successfully!");
                    System.out.println("[Tunnely] Public address: " + this.publicEndpoint);
                    System.out.println("[Tunnely] Share this address with your friends");
                    System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    if (this.server != null) {
                        this.broadcastToServer("\u00a7a[Tunnely] Tunnel established!");
                        this.broadcastToServer("\u00a7e[Tunnely] Public address: \u00a7b" + this.publicEndpoint);
                    }
                    return true;
                }
                System.err.println("[Tunnely] Failed to get public endpoint from relay");
                if (attempt < this.sortedRelays.size() - 1) {
                    System.out.println("[Tunnely] Retrying with next relay...");
                    continue;
                }
                return false;
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error establishing tunnel with relay " + relay.id + ": " + e.getMessage());
                if (this.config.isDebugMode()) {
                    e.printStackTrace();
                }
                if (attempt < this.sortedRelays.size() - 1) {
                    System.out.println("[Tunnely] Retrying with next relay...");
                    continue;
                }
                return false;
            }
        }
        System.err.println("[Tunnely] All relays failed");
        return false;
    }

    private void initializeAdditionalProxies() {
        int successCount = 0;
        int failCount = 0;
        for (PortForwardingConfig portConfig : this.activePortForwards) {
            if (!portConfig.isEnabled() || portConfig.getProtocol() != PortForwardingConfig.Protocol.UDP) continue;
            try {
                UdpProxyServer udpProxy = new UdpProxyServer(portConfig.getPort(), this.tunnelClient, portConfig.getServiceName());
                this.tunnelClient.registerUdpHandler(portConfig.getPort(), udpProxy::handleRelayPacket);
                udpProxy.start();
                this.udpProxyServers.put(portConfig.getPort(), udpProxy);
                System.out.println("[Tunnely]   \u2713 " + portConfig.getServiceName() + " (" + portConfig.getShortDisplayString() + ")");
                ++successCount;
            }
            catch (Exception e) {
                PortForwardError error = PortForwardError.fromException(e);
                System.err.println("[Tunnely]   \u2717 " + portConfig.getServiceName() + ": " + error.getMessage());
                System.err.println("[Tunnely]     Solution: " + error.getSolution());
                ++failCount;
            }
        }
        if (successCount > 0) {
            System.out.println("[Tunnely] Successfully started " + successCount + " UDP proxy server(s)");
        }
        if (failCount > 0) {
            System.err.println("[Tunnely] Failed to start " + failCount + " UDP proxy server(s). Voice chat may not work.");
        }
    }

    private void handleIncomingPacket(byte[] data) {
        if (this.server == null || this.hostProxyServer == null) {
            return;
        }
        this.hostProxyServer.handleRelayPacket(data);
        if (this.config.isDebugMode()) {
            System.out.println("[Tunnely] Forwarded packet to Minecraft server: " + data.length + " bytes");
        }
    }

    public void shutdownTunnel() {
        System.out.println("[Tunnely] Shutting down tunnel...");
        if (this.heartbeatManager != null) {
            this.heartbeatManager.stop();
            this.heartbeatManager.shutdown();
            this.heartbeatManager = null;
        }
        for (Map.Entry<Integer, UdpProxyServer> entry : this.udpProxyServers.entrySet()) {
            UdpProxyServer udpProxy = entry.getValue();
            if (udpProxy == null) continue;
            udpProxy.shutdown();
            if (this.tunnelClient == null) continue;
            this.tunnelClient.unregisterUdpHandler(entry.getKey());
        }
        this.udpProxyServers.clear();
        if (this.hostProxyServer != null) {
            this.hostProxyServer.shutdown();
            this.hostProxyServer = null;
        }
        if (this.tunnelClient != null) {
            this.tunnelClient.close();
            this.tunnelClient = null;
        }
        if (this.currentSessionId != null) {
            this.supabaseClient.unregisterServer(this.currentSessionId);
            this.currentSessionId = null;
        }
        this.publicEndpoint = null;
        this.server = null;
        this.activePortForwards.clear();
        System.out.println("[Tunnely] Tunnel shutdown complete");
    }

    public boolean updateServerVisibility(String visibility) {
        if (this.currentSessionId == null) {
            System.err.println("[Tunnely] No active session to update visibility");
            return false;
        }
        return this.supabaseClient.updateServerVisibility(this.currentSessionId, visibility);
    }

    public TunnelStatus getStatus() {
        boolean authenticated = this.config.isAuthenticated();
        boolean connected = this.tunnelClient != null && this.tunnelClient.isConnected();
        ArrayList<String> forwardedPorts = new ArrayList<String>();
        forwardedPorts.add("Minecraft (" + String.valueOf(this.server != null ? Integer.valueOf(this.server.m_7010_()) : "unknown") + "/TCP)");
        for (PortForwardingConfig portConfig : this.activePortForwards) {
            if (!portConfig.isEnabled()) continue;
            forwardedPorts.add(portConfig.getDisplayString());
        }
        return new TunnelStatus(authenticated, connected, this.publicEndpoint, this.currentSessionId, forwardedPorts);
    }

    public SupabaseClient.AuthResult login(String email, String password) {
        return this.supabaseClient.signIn(email, password);
    }

    public SupabaseClient.AuthResult register(String email, String password, String minecraftUuid) {
        return this.supabaseClient.signUp(email, password, minecraftUuid);
    }

    private void broadcastToServer(String message) {
        if (this.server != null) {
            this.server.execute(() -> this.server.m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)message))));
        }
    }

    public String getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public boolean isHosting() {
        return this.tunnelClient != null && this.tunnelClient.isConnected() && this.currentSessionId != null;
    }

    public void setDisconnectListener(Runnable listener) {
        this.disconnectListener = listener;
    }

    private static class RelayCandidate {
        final String id;
        final String region;
        final String url;
        final long latencyMs;

        RelayCandidate(String id, String region, String url, long latencyMs) {
            this.id = id;
            this.region = region;
            this.url = url;
            this.latencyMs = latencyMs;
        }
    }

    public static class TunnelStatus {
        public final boolean authenticated;
        public final boolean connected;
        public final String publicEndpoint;
        public final String sessionId;
        public final List<String> forwardedPorts;

        public TunnelStatus(boolean authenticated, boolean connected, String publicEndpoint, String sessionId) {
            this(authenticated, connected, publicEndpoint, sessionId, new ArrayList<String>());
        }

        public TunnelStatus(boolean authenticated, boolean connected, String publicEndpoint, String sessionId, List<String> forwardedPorts) {
            this.authenticated = authenticated;
            this.connected = connected;
            this.publicEndpoint = publicEndpoint;
            this.sessionId = sessionId;
            this.forwardedPorts = forwardedPorts;
        }
    }
}

