/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class InvitesScreen
extends class_437 {
    private final class_437 parent;
    private InviteListWidget inviteList;
    private String statusMessage = "\u00a7eLoading invites...";
    private int statusColor = 0xFFFF00;

    public InvitesScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Invites"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.inviteList = new InviteListWidget(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 60, 45);
        this.method_25429((class_364)this.inviteList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04 Refresh"), button -> this.loadInvites()).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 50, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 55, this.field_22790 - 50, 100, 20).method_46431());
        this.loadInvites();
    }

    private void loadInvites() {
        System.out.println("[Tunnely UI] ===== LOADING INVITES =====");
        this.statusMessage = "\u00a7eLoading invites...";
        this.statusColor = 0xFFFF00;
        this.inviteList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.InviteListResult result = client.getPendingInvites();
                this.field_22787.execute(() -> {
                    block6: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing invite data...");
                                JsonArray invites = JsonParser.parseString(result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + invites.size() + " invite(s)");
                                if (invites.size() == 0) {
                                    this.statusMessage = "\u00a77No pending invites";
                                    this.statusColor = 0xAAAAAA;
                                    break block6;
                                }
                                for (JsonElement element : invites) {
                                    JsonObject invite = element.getAsJsonObject();
                                    String inviteId = invite.get("id").getAsString();
                                    String inviterName = invite.has("inviter_name") ? invite.get("inviter_name").getAsString() : "Unknown";
                                    String serverName = invite.has("server_name") ? invite.get("server_name").getAsString() : "Server";
                                    System.out.println("[Tunnely UI] Invite: " + inviterName + " -> " + serverName);
                                    this.inviteList.addInvite(inviteId, inviterName, serverName);
                                }
                                this.statusMessage = "\u00a7a" + invites.size() + " pending invite(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse invites";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing invites: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load invites: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading invites: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadInvites").start();
    }

    private void acceptInvite(String inviteId) {
        System.out.println("[Tunnely UI] ===== ACCEPTING INVITE =====");
        System.out.println("[Tunnely UI] Invite ID: " + inviteId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.acceptInvite(inviteId);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite accepted!";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite accepted successfully");
                        this.loadInvites();
                    } else {
                        this.statusMessage = "\u00a7cFailed to accept invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to accept invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception accepting invite: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-AcceptInvite").start();
    }

    private void declineInvite(String inviteId) {
        System.out.println("[Tunnely UI] ===== DECLINING INVITE =====");
        System.out.println("[Tunnely UI] Invite ID: " + inviteId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.declineInvite(inviteId);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite declined";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite declined successfully");
                        this.loadInvites();
                    } else {
                        this.statusMessage = "\u00a7cFailed to decline invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to decline invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception declining invite: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-DeclineInvite").start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        this.inviteList.method_25394(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_25300(this.field_22793, "\u00a76\u00a7lInvites", this.field_22789 / 2, 20, 0xFFFFFF);
        graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, 35, this.statusColor);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class InviteListWidget
    extends class_4280<InviteEntry> {
        public InviteListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.method_25339();
        }

        public void addInvite(String id, String inviterName, String serverName) {
            this.method_25321((class_350.class_351)new InviteEntry(id, inviterName, serverName));
        }

        class InviteEntry
        extends class_4280.class_4281<InviteEntry> {
            private final String id;
            private final String inviterName;
            private final String serverName;
            private final class_4185 acceptButton;
            private final class_4185 declineButton;

            public InviteEntry(String id, String inviterName, String serverName) {
                this.id = id;
                this.inviterName = inviterName;
                this.serverName = serverName;
                this.acceptButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2713"), button -> InvitesScreen.this.acceptInvite(id)).method_46434(0, 0, 30, 20).method_46431();
                this.declineButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2717"), button -> InvitesScreen.this.declineInvite(id)).method_46434(0, 0, 30, 20).method_46431();
            }

            public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.method_25303(InvitesScreen.this.field_22793, "\u00a7bFrom: \u00a7f" + this.inviterName, left + 5, top + 5, 0xFFFFFF);
                graphics.method_25303(InvitesScreen.this.field_22793, "\u00a77Server: \u00a7e" + this.serverName, left + 5, top + 18, 0xFFFFFF);
                this.acceptButton.method_46421(left + width - 70);
                this.acceptButton.method_46419(top + 10);
                this.acceptButton.method_25394(graphics, mouseX, mouseY, partialTick);
                this.declineButton.method_46421(left + width - 35);
                this.declineButton.method_46419(top + 10);
                this.declineButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.acceptButton.method_25402(mouseX, mouseY, button) || this.declineButton.method_25402(mouseX, mouseY, button);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)("Invite from " + this.inviterName + " to " + this.serverName));
            }
        }
    }
}

