/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.ScanReportScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUpdateScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanStatusColors;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanStatusRenderer;

public class MyWorldsScreen
extends class_437 {
    private final class_437 parent;
    private final WorldManager worldManager;
    private List<WorldInfo> myWorlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 75;
    private int maxScrollOffset = 0;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public MyWorldsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"My Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to manage your worlds";
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Go to Login"), button -> this.field_22787.method_1507((class_437)new LoginScreen(this.parent))).method_46434(centerX - 75, this.field_22790 / 2, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX - 50, this.field_22790 / 2 + 30, 100, 20).method_46431());
            return;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Upload New World"), button -> this.field_22787.method_1507((class_437)new WorldUploadScreen(this))).method_46434(centerX - 105, this.field_22790 - 30, 110, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 10, this.field_22790 - 30, 100, 20).method_46431());
        this.loadMyWorlds();
    }

    private void loadMyWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading your worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> worlds = this.worldManager.getMyWorlds();
                this.field_22787.execute(() -> {
                    this.myWorlds = worlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.myWorlds.isEmpty() ? "You haven't uploaded any worlds yet" : "Loaded " + this.myWorlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void deleteWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Deleting " + world.getName() + "...";
        new Thread(() -> {
            try {
                boolean success = this.worldManager.deleteWorld(world.getId());
                this.field_22787.execute(() -> {
                    this.loading = false;
                    if (success) {
                        this.statusMessage = "\u00a7a\u2713 World deleted";
                        this.loadMyWorlds();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Failed to delete world";
                    }
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.loading = false;
                    this.statusMessage = "\u00a7cDelete failed: " + e.getMessage();
                });
            }
        }).start();
    }

    private void viewWorld(WorldInfo world) {
        this.field_22787.method_1507((class_437)new WorldDetailsScreen(this, world));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.field_22790 - 100;
        int contentHeight = this.myWorlds.size() * 75;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        graphics.method_25300(this.field_22793, "\ud83d\udcc1 My Uploaded Worlds", this.field_22789 / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, 35, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderWorldList(class_332 graphics, int mouseX, int mouseY) {
        int startY = 55;
        int endY = this.field_22790 - 50;
        int centerX = this.field_22789 / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.myWorlds.size(); ++i) {
            WorldInfo world = this.myWorlds.get(i);
            int entryY = yOffset + i * 75;
            if (entryY + 75 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.method_44380();
    }

    private void renderWorldEntry(class_332 graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 75 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.method_25294(x, y, x + width, y + 75 - 5, bgColor);
        graphics.method_25294(x, y, x + width, y + 1, -12566464);
        graphics.method_25294(x, y + 75 - 5, x + width, y + 75 - 4, -12566464);
        graphics.method_25303(this.field_22793, world.getName(), x + 5, y + 5, 0xFFFFFF);
        String visibilityText = world.isPublic() ? "\u00a7aPublic" : "\u00a77Private";
        graphics.method_25303(this.field_22793, visibilityText, x + 5, y + 18, 0xAAAAAA);
        String statsLine = "\u00a77" + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.method_25303(this.field_22793, statsLine, x + 80, y + 18, 0xAAAAAA);
        String scanStatus = ScanStatusRenderer.getStatusText(world, true);
        String warningIcon = ScanStatusRenderer.getWarningIcon(world);
        int statusColor = ScanStatusColors.getStatusColor(world);
        if (!warningIcon.isEmpty()) {
            graphics.method_25303(this.field_22793, warningIcon + " " + scanStatus, x + 5, y + 31, statusColor);
        } else {
            graphics.method_25303(this.field_22793, scanStatus, x + 5, y + 31, statusColor);
        }
        graphics.method_25303(this.field_22793, "\u00a77Uploaded: " + world.getFormattedCreatedAt(), x + 5, y + 44, 0x888888);
        int buttonY = y + 58;
        int buttonWidth = 60;
        int buttonHeight = 18;
        int buttonSpacing = 65;
        int buttonIndex = 0;
        int viewX = x + 5 + buttonIndex * buttonSpacing;
        boolean viewHovered = this.isMouseOverButton(mouseX, mouseY, viewX, buttonY, buttonWidth, buttonHeight);
        if (viewHovered) {
            graphics.method_25294(viewX, buttonY, viewX + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "view";
        } else {
            graphics.method_25294(viewX, buttonY, viewX + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.method_25300(this.field_22793, "View", viewX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        ++buttonIndex;
        if (!this.loading && ScanStatusRenderer.shouldShowRescanButton(world)) {
            int rescanX = x + 5 + buttonIndex * buttonSpacing;
            boolean rescanHovered = this.isMouseOverButton(mouseX, mouseY, rescanX, buttonY, buttonWidth, buttonHeight);
            if (rescanHovered) {
                graphics.method_25294(rescanX, buttonY, rescanX + buttonWidth, buttonY + buttonHeight, -2130728448);
                this.hoveredWorld = world;
                this.hoveredButton = "rescan";
            } else {
                graphics.method_25294(rescanX, buttonY, rescanX + buttonWidth, buttonY + buttonHeight, -2138548992);
            }
            graphics.method_25300(this.field_22793, "Re-scan", rescanX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading && ScanStatusRenderer.shouldShowReportButton(world)) {
            int reportX = x + 5 + buttonIndex * buttonSpacing;
            boolean reportHovered = this.isMouseOverButton(mouseX, mouseY, reportX, buttonY, buttonWidth, buttonHeight);
            if (reportHovered) {
                graphics.method_25294(reportX, buttonY, reportX + buttonWidth, buttonY + buttonHeight, -2130750123);
                this.hoveredWorld = world;
                this.hoveredButton = "report";
            } else {
                graphics.method_25294(reportX, buttonY, reportX + buttonWidth, buttonY + buttonHeight, -2138557645);
            }
            graphics.method_25300(this.field_22793, "Report", reportX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading) {
            int updateX = x + 5 + buttonIndex * buttonSpacing;
            boolean updateHovered = this.isMouseOverButton(mouseX, mouseY, updateX, buttonY, buttonWidth, buttonHeight);
            if (updateHovered) {
                graphics.method_25294(updateX, buttonY, updateX + buttonWidth, buttonY + buttonHeight, -2147439873);
                this.hoveredWorld = world;
                this.hoveredButton = "update";
            } else {
                graphics.method_25294(updateX, buttonY, updateX + buttonWidth, buttonY + buttonHeight, -2147461752);
            }
            graphics.method_25300(this.field_22793, "Update", updateX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading) {
            int deleteX = x + 5 + buttonIndex * buttonSpacing;
            boolean deleteHovered = this.isMouseOverButton(mouseX, mouseY, deleteX, buttonY, buttonWidth, buttonHeight);
            if (deleteHovered) {
                graphics.method_25294(deleteX, buttonY, deleteX + buttonWidth, buttonY + buttonHeight, -2130771968);
                this.hoveredWorld = world;
                this.hoveredButton = "delete";
            } else {
                graphics.method_25294(deleteX, buttonY, deleteX + buttonWidth, buttonY + buttonHeight, -2139095040);
            }
            graphics.method_25300(this.field_22793, "Delete", deleteX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    private void updateWorld(WorldInfo world) {
        this.field_22787.method_1507((class_437)new WorldUpdateScreen(this, world));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("view")) {
                this.viewWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("rescan")) {
                this.rescanWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("report")) {
                this.viewScanReport(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("update")) {
                this.updateWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("delete")) {
                this.deleteWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void rescanWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Triggering scan for " + world.getName() + "...";
        new Thread(() -> {
            try {
                boolean success = this.worldManager.manualTriggerScan(world.getId());
                this.field_22787.execute(() -> {
                    this.loading = false;
                    this.statusMessage = success ? "\u00a7a\u2713 Scan triggered - refresh in a moment" : "\u00a7c\u2717 Failed to trigger scan";
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.loading = false;
                    this.statusMessage = "\u00a7cScan trigger failed: " + e.getMessage();
                });
            }
        }).start();
    }

    private void viewScanReport(WorldInfo world) {
        this.field_22787.method_1507((class_437)new ScanReportScreen(this, world));
    }

    public void method_16014(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.method_16014(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

