/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.ScanResultDetails;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;

public class WorldInfo {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="author_id")
    private String authorId;
    @SerializedName(value="author_username")
    private String authorUsername;
    @SerializedName(value="file_url")
    private String fileUrl;
    @SerializedName(value="file_size")
    private long fileSize;
    @SerializedName(value="uncompressed_size")
    private Long uncompressedSize;
    @SerializedName(value="minecraft_version")
    private String minecraftVersion;
    @SerializedName(value="world_type")
    private String worldType;
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    @SerializedName(value="download_count")
    private int downloadCount;
    @SerializedName(value="rating_avg")
    private double ratingAvg;
    @SerializedName(value="rating_count")
    private int ratingCount;
    @SerializedName(value="is_public")
    private boolean isPublic;
    @SerializedName(value="is_verified")
    private boolean isVerified;
    @SerializedName(value="is_featured")
    private boolean isFeatured;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="updated_at")
    private String updatedAt;
    @SerializedName(value="screenshot_url")
    private String screenshotUrl;
    @SerializedName(value="scan_status")
    private String scanStatus;
    @SerializedName(value="is_quarantined")
    private boolean isQuarantined;
    @SerializedName(value="scan_started_at")
    private String scanStartedAt;
    @SerializedName(value="scan_completed_at")
    private String scanCompletedAt;
    @SerializedName(value="scan_result")
    private Object scanResult;

    public WorldInfo() {
    }

    public WorldInfo(String id, String name, String description, String authorUsername) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.authorUsername = authorUsername;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description.replaceAll("\\r\\n|\\r|\\n", " ").trim();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRawDescription() {
        return this.description != null ? this.description : "";
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public String getAuthorUsername() {
        return this.authorUsername != null ? this.authorUsername : "Unknown";
    }

    public void setAuthorUsername(String authorUsername) {
        this.authorUsername = authorUsername;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFormattedFileSize() {
        return WorldScannerUtil.formatSize(this.fileSize);
    }

    public Long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(Long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion != null ? this.minecraftVersion : "Unknown";
    }

    public void setMinecraftVersion(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public String getWorldType() {
        return this.worldType != null ? this.worldType : "survival";
    }

    public void setWorldType(String worldType) {
        this.worldType = worldType;
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : new ArrayList<String>();
    }

    public void setTags(List<String> tags) {
        this.tags = tags != null ? tags : new ArrayList();
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }

    public void setDownloadCount(int downloadCount) {
        this.downloadCount = downloadCount;
    }

    public String getFormattedDownloadCount() {
        if (this.downloadCount >= 1000000) {
            return String.format("%.1fM", (double)this.downloadCount / 1000000.0);
        }
        if (this.downloadCount >= 1000) {
            return String.format("%.1fk", (double)this.downloadCount / 1000.0);
        }
        return String.valueOf(this.downloadCount);
    }

    public double getRatingAvg() {
        return this.ratingAvg;
    }

    public void setRatingAvg(double ratingAvg) {
        this.ratingAvg = ratingAvg;
    }

    public int getRatingCount() {
        return this.ratingCount;
    }

    public void setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
    }

    public String getFormattedRating() {
        if (this.ratingCount == 0) {
            return "No ratings";
        }
        return String.format("\u2b50%.1f (%d)", this.ratingAvg, this.ratingCount);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public void setVerified(boolean verified) {
        this.isVerified = verified;
    }

    public boolean isFeatured() {
        return this.isFeatured;
    }

    public void setFeatured(boolean featured) {
        this.isFeatured = featured;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getScreenshotUrl() {
        return this.screenshotUrl;
    }

    public void setScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
    }

    public boolean hasScreenshot() {
        return this.screenshotUrl != null && !this.screenshotUrl.isEmpty();
    }

    public String getFormattedCreatedAt() {
        if (this.createdAt == null) {
            return "Unknown";
        }
        try {
            Instant instant = Instant.parse(this.createdAt);
            long daysAgo = (System.currentTimeMillis() - instant.toEpochMilli()) / 86400000L;
            if (daysAgo == 0L) {
                return "Today";
            }
            if (daysAgo == 1L) {
                return "Yesterday";
            }
            if (daysAgo < 7L) {
                return daysAgo + " days ago";
            }
            if (daysAgo < 30L) {
                return daysAgo / 7L + " weeks ago";
            }
            if (daysAgo < 365L) {
                return daysAgo / 30L + " months ago";
            }
            return daysAgo / 365L + " years ago";
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public String getScanStatus() {
        return this.scanStatus != null ? this.scanStatus : "pending";
    }

    public void setScanStatus(String scanStatus) {
        this.scanStatus = scanStatus;
    }

    public boolean isQuarantined() {
        return this.isQuarantined;
    }

    public void setQuarantined(boolean quarantined) {
        this.isQuarantined = quarantined;
    }

    public String getScanStartedAt() {
        return this.scanStartedAt;
    }

    public void setScanStartedAt(String scanStartedAt) {
        this.scanStartedAt = scanStartedAt;
    }

    public String getScanCompletedAt() {
        return this.scanCompletedAt;
    }

    public void setScanCompletedAt(String scanCompletedAt) {
        this.scanCompletedAt = scanCompletedAt;
    }

    public Object getScanResult() {
        return this.scanResult;
    }

    public void setScanResult(Object scanResult) {
        this.scanResult = scanResult;
    }

    public ScanResultDetails getScanResultDetails() {
        if (this.scanResult == null) {
            return null;
        }
        try {
            Gson gson = new Gson();
            String json = gson.toJson(this.scanResult);
            return gson.fromJson(json, ScanResultDetails.class);
        }
        catch (Exception e) {
            System.err.println("[WorldInfo] Failed to parse scan result: " + e.getMessage());
            return null;
        }
    }

    public String getThreatLevel() {
        ScanResultDetails details = this.getScanResultDetails();
        return details != null ? details.getThreatLevel() : "none";
    }

    public boolean isHighThreat() {
        String level = this.getThreatLevel();
        return "high".equals(level) || "critical".equals(level);
    }

    public String getFormattedScanStatus() {
        String status;
        switch (status = this.getScanStatus()) {
            case "clean": {
                return "\u2713 Clean";
            }
            case "scanning": {
                return "\u23f3 Scanning...";
            }
            case "infected": {
                return "\u26a0 Quarantined";
            }
            case "failed": {
                return "\u274c Scan Failed";
            }
        }
        return "\u23f1 Pending Scan";
    }

    public String getFormattedScanStatusWithThreat() {
        ScanResultDetails details;
        String baseStatus = this.getFormattedScanStatus();
        if (("infected".equals(this.getScanStatus()) || this.isQuarantined) && (details = this.getScanResultDetails()) != null) {
            return baseStatus + " [" + details.getFormattedThreatLevel() + "]";
        }
        return baseStatus;
    }

    public boolean isSafeToDownload() {
        return "clean".equals(this.scanStatus) && !this.isQuarantined;
    }

    public boolean isScanning() {
        return "scanning".equals(this.scanStatus);
    }

    public boolean isScanPending() {
        return "pending".equals(this.scanStatus) || this.scanStatus == null;
    }
}

