/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.NotificationManager;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;

public class NotificationBell {
    private static final long UPDATE_INTERVAL = 30000L;
    private final NotificationManager notificationManager;
    private int unreadCount = 0;
    private long lastUpdateTime = 0L;
    private List<WorldNotification> cachedNotifications = new ArrayList<WorldNotification>();

    public NotificationBell(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdateTime > 30000L) {
            this.updateFromServer();
            this.lastUpdateTime = now;
        }
    }

    public void forceUpdate() {
        this.updateFromServer();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateFromServer() {
        try {
            this.unreadCount = this.notificationManager.getUnreadCount();
            this.cachedNotifications = this.notificationManager.getAllNotifications(20);
        }
        catch (Exception e) {
            System.err.println("[NotificationBell] Failed to update: " + e.getMessage());
        }
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public String getBadgeText() {
        if (this.unreadCount == 0) {
            return "";
        }
        if (this.unreadCount > 9) {
            return "9+";
        }
        return String.valueOf(this.unreadCount);
    }

    public boolean shouldShowBadge() {
        return this.unreadCount > 0;
    }

    public List<WorldNotification> getNotifications() {
        return this.cachedNotifications;
    }

    public List<WorldNotification> getUnreadNotifications() {
        ArrayList<WorldNotification> unread = new ArrayList<WorldNotification>();
        for (WorldNotification notif : this.cachedNotifications) {
            if (notif.isRead()) continue;
            unread.add(notif);
        }
        return unread;
    }

    public List<WorldNotification> getSecurityNotifications() {
        ArrayList<WorldNotification> security = new ArrayList<WorldNotification>();
        for (WorldNotification notif : this.cachedNotifications) {
            if (!notif.isSecurityNotification()) continue;
            security.add(notif);
        }
        return security;
    }

    public void markAsRead(String notificationId) {
        boolean success = this.notificationManager.markAsRead(notificationId);
        if (success) {
            for (WorldNotification notif : this.cachedNotifications) {
                if (!notif.getId().equals(notificationId)) continue;
                notif.setRead(true);
                this.unreadCount = Math.max(0, this.unreadCount - 1);
                break;
            }
        }
    }

    public void markAllAsRead() {
        boolean success = this.notificationManager.markAllAsRead();
        if (success) {
            for (WorldNotification notif : this.cachedNotifications) {
                notif.setRead(true);
            }
            this.unreadCount = 0;
        }
    }

    public void deleteNotification(String notificationId) {
        boolean success = this.notificationManager.deleteNotification(notificationId);
        if (success) {
            this.cachedNotifications.removeIf(notif -> notif.getId().equals(notificationId));
            this.forceUpdate();
        }
    }

    public boolean hasCriticalNotifications() {
        for (WorldNotification notif : this.cachedNotifications) {
            if (!notif.isCritical() || notif.isRead()) continue;
            return true;
        }
        return false;
    }
}

