/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;

public class NotificationPanelData {
    public static NotificationItem formatNotification(WorldNotification notification) {
        NotificationItem item = new NotificationItem();
        item.id = notification.getId();
        item.icon = notification.getIcon();
        item.title = notification.getTitle();
        item.message = notification.getShortMessage();
        item.fullMessage = notification.getMessage();
        item.time = notification.getFormattedTime();
        item.isRead = notification.isRead();
        item.isCritical = notification.isCritical();
        item.isSecurity = notification.isSecurityNotification();
        item.backgroundColor = item.isCritical ? 0x40660000 : (!item.isRead ? 1073754982 : 0);
        item.textColor = item.isCritical ? -52429 : (item.isSecurity ? -26317 : -1);
        return item;
    }

    public static List<NotificationItem> formatNotifications(List<WorldNotification> notifications) {
        ArrayList<NotificationItem> items = new ArrayList<NotificationItem>();
        for (WorldNotification notif : notifications) {
            items.add(NotificationPanelData.formatNotification(notif));
        }
        return items;
    }

    public static NotificationGroups groupNotifications(List<WorldNotification> notifications) {
        NotificationGroups groups = new NotificationGroups();
        for (WorldNotification notif : notifications) {
            NotificationItem item = NotificationPanelData.formatNotification(notif);
            if (notif.isCritical()) {
                groups.critical.add(item);
                continue;
            }
            if (notif.isSecurityNotification()) {
                groups.security.add(item);
                continue;
            }
            groups.other.add(item);
        }
        return groups;
    }

    public static String getPanelHeader(int unreadCount) {
        if (unreadCount == 0) {
            return "Notifications";
        }
        if (unreadCount == 1) {
            return "Notifications (1 unread)";
        }
        return "Notifications (" + unreadCount + " unread)";
    }

    public static String getEmptyMessage() {
        return "No notifications";
    }

    public static class NotificationItem {
        public String id;
        public String icon;
        public String title;
        public String message;
        public String fullMessage;
        public String time;
        public boolean isRead;
        public boolean isCritical;
        public boolean isSecurity;
        public int backgroundColor;
        public int textColor;
    }

    public static class NotificationGroups {
        public List<NotificationItem> critical = new ArrayList<NotificationItem>();
        public List<NotificationItem> security = new ArrayList<NotificationItem>();
        public List<NotificationItem> other = new ArrayList<NotificationItem>();

        public boolean hasCritical() {
            return !this.critical.isEmpty();
        }

        public boolean hasSecurity() {
            return !this.security.isEmpty();
        }

        public boolean hasOther() {
            return !this.other.isEmpty();
        }

        public int getTotalCount() {
            return this.critical.size() + this.security.size() + this.other.size();
        }
    }
}

