/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.security;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.TrustedRelay;

public class RelayValidator {
    private static final List<TrustedRelay> OFFICIAL_RELAYS = new ArrayList<TrustedRelay>();

    public static boolean isTrustedRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isEmpty()) {
            return false;
        }
        for (TrustedRelay relay : OFFICIAL_RELAYS) {
            if (!relay.matchesUrl(relayUrl)) continue;
            return true;
        }
        return false;
    }

    public static TrustedRelay getTrustedRelay(String relayUrl) {
        if (relayUrl == null || relayUrl.isEmpty()) {
            return null;
        }
        for (TrustedRelay relay : OFFICIAL_RELAYS) {
            if (!relay.matchesUrl(relayUrl)) continue;
            return relay;
        }
        return null;
    }

    public static List<TrustedRelay> getOfficialRelays() {
        return new ArrayList<TrustedRelay>(OFFICIAL_RELAYS);
    }

    public static RelaySecurityStatus validateRelayConfig() {
        TunnelConfig config = TunnelConfig.getInstance();
        String relayUrl = config.getRelayServerUrl();
        if (relayUrl == null || relayUrl.isEmpty()) {
            return new RelaySecurityStatus(SecurityLevel.ERROR, "No relay server configured", null);
        }
        TrustedRelay trustedRelay = RelayValidator.getTrustedRelay(relayUrl);
        if (trustedRelay != null) {
            return new RelaySecurityStatus(SecurityLevel.TRUSTED, "Connected to official Tunnely relay: " + trustedRelay.getRegion(), trustedRelay);
        }
        return new RelaySecurityStatus(SecurityLevel.UNTRUSTED, "\u26a0\ufe0f WARNING: Custom relay server detected!\nCurrent relay: " + relayUrl + "\n\nThis relay is NOT operated by Tunnely.\nThe relay operator can see:\n  \u2022 Your IP address and connection metadata\n  \u2022 All game traffic (chat, coordinates, etc.)\n\nOnly use custom relays from people you trust!\n\nOfficial relays: See /tunnel relays", null);
    }

    static {
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-na-1", "NA", "wss://na-1.tunnely.org:8080", "BF:DB:31:45:99:2B:C0:EB:6D:6D:1A:F6:91:46:FB:F2:DA:16:0F:ED:C4:CE:72:13:55:F9:FD:AF:6F:65:32:A9"));
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-eu-1", "EU", "wss://eu-1.tunnely.org:8080", "16:70:55:77:A1:B1:CA:A6:37:04:31:F5:0A:4B:38:12:E9:10:81:BB:DD:F7:F2:FB:AF:C2:93:60:22:8B:5A:A9"));
        OFFICIAL_RELAYS.add(new TrustedRelay("relay-apc-1", "APC", "wss://apc-1.tunnely.org:8080", "EF:C9:7D:A8:CF:47:A5:02:24:F4:41:80:88:30:36:83:D5:2B:2D:FE:E9:FF:E5:E3:E4:D0:E9:A8:D6:F0:21:38"));
    }

    public static class RelaySecurityStatus {
        public final SecurityLevel level;
        public final String message;
        public final TrustedRelay trustedRelay;

        public RelaySecurityStatus(SecurityLevel level, String message, TrustedRelay trustedRelay) {
            this.level = level;
            this.message = message;
            this.trustedRelay = trustedRelay;
        }

        public boolean isTrusted() {
            return this.level == SecurityLevel.TRUSTED;
        }

        public boolean isWarning() {
            return this.level == SecurityLevel.UNTRUSTED;
        }

        public boolean isError() {
            return this.level == SecurityLevel.ERROR;
        }
    }

    public static enum SecurityLevel {
        TRUSTED,
        UNTRUSTED,
        ERROR;

    }
}

