/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.models.FriendsDataModels;
import org.texboobcat.tunnelyrefab.ui.screens.ChatScreen;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;

public class UnifiedFriendsScreen
extends class_437 {
    private final class_437 parent;
    private Tab currentTab = Tab.FRIENDS;
    private List<FriendsDataModels.FriendEntry> acceptedFriends = new ArrayList<FriendsDataModels.FriendEntry>();
    private List<FriendsDataModels.PendingRequestEntry> incomingRequests = new ArrayList<FriendsDataModels.PendingRequestEntry>();
    private List<FriendsDataModels.PendingRequestEntry> outgoingRequests = new ArrayList<FriendsDataModels.PendingRequestEntry>();
    private List<FriendsDataModels.ServerEntry> activeServers = new ArrayList<FriendsDataModels.ServerEntry>();
    private class_342 addFriendBox;
    private int scrollOffset = 0;
    private final int ITEM_HEIGHT = 40;
    private String statusMessage = "\u00a7eLoading...";
    private int statusColor = 0xFFFF55;
    private int unreadMessageCount = 0;
    private final Consumer<Integer> unreadCountListener = count -> this.field_22787.execute(() -> {
        this.unreadMessageCount = count;
        this.updateStatusMessage();
    });

    public UnifiedFriendsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Friends & Servers"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)new class_4185(centerX - 155, 35, 150, 20, (class_2561)class_2561.method_43470((String)"Friends"), button -> this.switchTab(Tab.FRIENDS)));
        this.method_37063((class_364)new class_4185(centerX + 5, 35, 150, 20, (class_2561)class_2561.method_43470((String)"Servers"), button -> this.switchTab(Tab.SERVERS)));
        this.addFriendBox = new class_342(this.field_22793, centerX - 105, this.field_22790 - 95, 140, 20, (class_2561)class_2561.method_43470((String)"Username"));
        this.addFriendBox.method_1880(16);
        this.method_37063((class_364)this.addFriendBox);
        this.method_37063((class_364)new class_4185(centerX + 40, this.field_22790 - 95, 60, 20, (class_2561)class_2561.method_43470((String)"+ Add"), button -> this.addFriend()));
        this.method_37063((class_364)new class_4185(centerX - 105, this.field_22790 - 50, 100, 20, (class_2561)class_2561.method_43470((String)"Refresh"), button -> this.loadData()));
        this.method_37063((class_364)new class_4185(centerX + 5, this.field_22790 - 50, 100, 20, (class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)));
        MessageManager.getInstance().subscribeToUnreadCount(this.unreadCountListener);
        this.loadData();
    }

    private void switchTab(Tab tab) {
        if (this.currentTab != tab) {
            this.currentTab = tab;
            this.scrollOffset = 0;
            this.updateStatusMessage();
        }
    }

    private void loadData() {
        this.statusMessage = "\u00a7eLoading...";
        new Thread(() -> {
            this.loadFriendsData();
            this.loadServersData();
            this.field_22787.execute(this::updateStatusMessage);
        }, "Tunnely-LoadData").start();
    }

    private void loadFriendsData() {
        try {
            SupabaseClient client = new SupabaseClient();
            String currentUserId = TunnelConfig.getInstance().getSupabaseUserId();
            SupabaseClient.FriendListResult friendsResult = client.getFriends();
            if (friendsResult.success) {
                ArrayList<FriendsDataModels.FriendEntry> newFriends = new ArrayList<FriendsDataModels.FriendEntry>();
                JsonArray friendsArray = JsonParser.parseString(friendsResult.data).getAsJsonArray();
                for (Object element : friendsArray) {
                    JsonObject friendProfile;
                    JsonObject friend = ((JsonElement)element).getAsJsonObject();
                    String id = friend.get("id").getAsString();
                    String userId = friend.get("user_id").getAsString();
                    String friendIdInRow = friend.get("friend_id").getAsString();
                    boolean weAreUser = userId.equals(currentUserId);
                    String actualFriendId = weAreUser ? friendIdInRow : userId;
                    String username = this.extractUsername(friend, "friend");
                    PresenceManager.OnlineStatus status = PresenceManager.OnlineStatus.OFFLINE;
                    if (friend.has("friend") && !friend.get("friend").isJsonNull() && (friendProfile = friend.getAsJsonObject("friend")).has("last_seen") && !friendProfile.get("last_seen").isJsonNull()) {
                        String lastSeen = friendProfile.get("last_seen").getAsString();
                        status = PresenceManager.getOnlineStatus(lastSeen);
                    }
                    newFriends.add(new FriendsDataModels.FriendEntry(id, actualFriendId, username, status));
                }
                this.field_22787.execute(() -> {
                    this.acceptedFriends = newFriends;
                });
            }
            SupabaseClient.FriendListResult incomingResult = client.getPendingFriendRequests();
            if (incomingResult.success) {
                ArrayList<FriendsDataModels.PendingRequestEntry> newIncoming = new ArrayList<FriendsDataModels.PendingRequestEntry>();
                JsonArray requestsArray = JsonParser.parseString(incomingResult.data).getAsJsonArray();
                for (JsonElement element : requestsArray) {
                    JsonObject request = element.getAsJsonObject();
                    String id = request.get("id").getAsString();
                    String requestUserId = request.get("user_id").getAsString();
                    String username = this.extractUsername(request, "requester");
                    newIncoming.add(new FriendsDataModels.PendingRequestEntry(id, requestUserId, username, true));
                }
                this.field_22787.execute(() -> {
                    this.incomingRequests = newIncoming;
                });
            }
            SupabaseClient.FriendListResult outgoingResult = client.getOutgoingFriendRequests();
            if (outgoingResult.success) {
                ArrayList<FriendsDataModels.PendingRequestEntry> newOutgoing = new ArrayList<FriendsDataModels.PendingRequestEntry>();
                JsonArray requestsArray = JsonParser.parseString(outgoingResult.data).getAsJsonArray();
                for (JsonElement element : requestsArray) {
                    JsonObject request = element.getAsJsonObject();
                    String id = request.get("id").getAsString();
                    String requestFriendId = request.get("friend_id").getAsString();
                    String username = this.extractUsername(request, "friend");
                    newOutgoing.add(new FriendsDataModels.PendingRequestEntry(id, requestFriendId, username, false));
                }
                this.field_22787.execute(() -> {
                    this.outgoingRequests = newOutgoing;
                });
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading friends: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String extractUsername(JsonObject obj, String profileField) {
        JsonObject profile;
        if (obj.has(profileField) && !obj.get(profileField).isJsonNull() && (profile = obj.getAsJsonObject(profileField)).has("minecraft_name")) {
            return profile.get("minecraft_name").getAsString();
        }
        return "Unknown";
    }

    private void loadServersData() {
        try {
            SupabaseClient client = new SupabaseClient();
            SupabaseClient.ServerListResult result = client.getFriendServers();
            if (result.success) {
                ArrayList<FriendsDataModels.ServerEntry> newServers = new ArrayList<FriendsDataModels.ServerEntry>();
                JsonArray serversArray = JsonParser.parseString(result.data).getAsJsonArray();
                CompatibilityDetector.CompatibilityInfo clientCompat = CompatibilityDetector.detect();
                for (JsonElement element : serversArray) {
                    JsonObject server = element.getAsJsonObject();
                    String serverId = server.get("id").getAsString();
                    String endpoint = server.has("public_endpoint") && !server.get("public_endpoint").isJsonNull() ? server.get("public_endpoint").getAsString() : null;
                    if (endpoint == null) continue;
                    String gameMode = server.has("game_mode") ? server.get("game_mode").getAsString() : "survival";
                    String serverName = server.has("server_name") ? server.get("server_name").getAsString() : "Server";
                    String hostName = this.extractUsername(server, "host");
                    String mcVersion = this.getStringOrNull(server, "minecraft_version");
                    String modLoader = this.getStringOrNull(server, "mod_loader");
                    String modpackId = this.getStringOrNull(server, "modpack_id");
                    String modpackVersion = this.getStringOrNull(server, "modpack_version");
                    CompatibilityDetector.CompatibilityInfo serverCompat = new CompatibilityDetector.CompatibilityInfo(mcVersion, modLoader, modpackId, modpackVersion);
                    boolean isCompatible = clientCompat.isCompatibleWith(serverCompat);
                    newServers.add(new FriendsDataModels.ServerEntry(serverId, endpoint, hostName, serverName, gameMode, serverCompat, isCompatible));
                }
                this.field_22787.execute(() -> {
                    this.activeServers = newServers;
                });
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading servers: " + e.getMessage());
        }
    }

    private String getStringOrNull(JsonObject obj, String field) {
        return obj.has(field) && !obj.get(field).isJsonNull() ? obj.get(field).getAsString() : null;
    }

    private void updateStatusMessage() {
        if (this.currentTab == Tab.FRIENDS) {
            int total = this.acceptedFriends.size();
            int pending = this.incomingRequests.size();
            StringBuilder sb = new StringBuilder();
            if (this.unreadMessageCount > 0) {
                sb.append("\u00a7e\ud83d\udcac ").append(this.unreadMessageCount).append(" unread");
                if (pending > 0 || total > 0) {
                    sb.append(" \u2022 ");
                }
            }
            if (pending > 0) {
                sb.append("\u00a7e").append(pending).append(" pending");
                if (total > 0) {
                    sb.append(" \u2022 ");
                }
            }
            if (total > 0) {
                sb.append("\u00a77").append(total).append(" friend").append(total != 1 ? "s" : "");
            }
            if (sb.length() == 0) {
                sb.append("\u00a77No friends yet");
            }
            this.statusMessage = sb.toString();
            this.statusColor = this.unreadMessageCount > 0 || pending > 0 ? 0xFFFF55 : 0xAAAAAA;
        } else {
            int total = this.activeServers.size();
            long compatible = this.activeServers.stream().filter(s -> s.isCompatible).count();
            this.statusMessage = total == 0 ? "\u00a77No active servers" : "\u00a77" + total + " server" + (total != 1 ? "s" : "") + " \u2022 \u00a7a" + compatible + " compatible";
            this.statusColor = 0xAAAAAA;
        }
    }

    private void addFriend() {
        String username = this.addFriendBox.method_1882().trim();
        if (username.isEmpty() || !username.matches("^[a-zA-Z0-9_]{3,16}$")) {
            this.statusMessage = "\u00a7cInvalid username";
            this.statusColor = 0xFF5555;
            return;
        }
        this.statusMessage = "\u00a7eSending...";
        new Thread(() -> {
            boolean success = new SupabaseClient().sendFriendRequestByUsername(username);
            this.field_22787.execute(() -> {
                this.statusMessage = success ? "\u00a7aRequest sent!" : "\u00a7cFailed";
                int n = this.statusColor = success ? 0x55FF55 : 0xFF5555;
                if (success) {
                    this.addFriendBox.method_1852("");
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-AddFriend").start();
    }

    private void removeFriend(String id, String username) {
        new Thread(() -> {
            boolean success = new SupabaseClient().removeFriend(id);
            this.field_22787.execute(() -> {
                if (success) {
                    this.statusMessage = "\u00a7aRemoved " + username;
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Remove").start();
    }

    private void acceptRequest(String id, String username) {
        new Thread(() -> {
            boolean success = new SupabaseClient().acceptFriendRequest(id);
            this.field_22787.execute(() -> {
                if (success) {
                    this.statusMessage = "\u00a7aAccepted!";
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Accept").start();
    }

    private void rejectRequest(String id) {
        new Thread(() -> {
            boolean success = new SupabaseClient().rejectFriendRequest(id);
            this.field_22787.execute(() -> {
                if (success) {
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Reject").start();
    }

    private void cancelRequest(String id) {
        new Thread(() -> {
            boolean success = new SupabaseClient().cancelFriendRequest(id);
            this.field_22787.execute(() -> {
                if (success) {
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Cancel").start();
    }

    private void joinServer(String id, String endpoint) {
        Object serverName = "Friend's Server";
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (!server.id.equals(id)) continue;
            serverName = server.hostName + "'s Server";
            break;
        }
        String finalServerName = serverName;
        new Thread(() -> {
            try {
                ClientTunnelManager manager = ClientTunnelManager.getInstance();
                manager.connectToServer(endpoint, id, () -> this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7aConnected!";
                }), errorMsg -> this.field_22787.execute(() -> {
                    System.err.println("[Tunnely UI] Connection error: " + errorMsg);
                    String errorType = this.categorizeError((String)errorMsg);
                    this.field_22787.method_1507((class_437)new ConnectionInfoScreen(this, finalServerName, errorType, (String)errorMsg, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? () -> this.joinServer(id, endpoint) : null));
                }));
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    String errorType = this.categorizeError(e.getMessage());
                    this.field_22787.method_1507((class_437)new ConnectionInfoScreen(this, finalServerName, errorType, e.getMessage(), null));
                });
            }
        }, "Tunnely-Join").start();
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        int centerX = this.field_22789 / 2;
        UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a76\u00a7lFriends & Servers", (int)centerX, (int)15, (int)0xFFFFFF);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        int underlineStart = this.currentTab == Tab.FRIENDS ? centerX - 155 : centerX + 5;
        UnifiedFriendsScreen.method_25294((class_4587)poseStack, (int)underlineStart, (int)54, (int)(underlineStart + 150), (int)56, (int)-10496);
        int contentTop = 65;
        int contentBottom = this.field_22790 - 110;
        double scale = this.field_22787.method_22683().method_4495();
        int windowWidth = this.field_22787.method_22683().method_4489();
        int windowHeight = this.field_22787.method_22683().method_4506();
        int scissorX = 0;
        int scissorY = (int)((double)windowHeight - (double)contentBottom * scale);
        int scissorWidth = (int)((double)this.field_22789 * scale);
        int scissorHeight = (int)((double)(contentBottom - contentTop) * scale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
        if (this.currentTab == Tab.FRIENDS) {
            this.renderFriendsTab(poseStack, mouseX, mouseY, contentTop, contentBottom - contentTop);
        } else {
            this.renderServersTab(poseStack, mouseX, mouseY, contentTop, contentBottom - contentTop);
        }
        RenderSystem.disableScissor();
        UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)this.statusMessage, (int)centerX, (int)(this.field_22790 - 70), (int)this.statusColor);
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77Add Friend:", (int)(centerX - 105), (int)(this.field_22790 - 108), (int)0xAAAAAA);
    }

    private void renderFriendsTab(class_4587 poseStack, int mouseX, int mouseY, int top, int height) {
        int y = top - this.scrollOffset;
        int centerX = this.field_22789 / 2;
        if (!this.incomingRequests.isEmpty()) {
            UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a7e\u00a7lPending Requests (" + this.incomingRequests.size() + ")"), (int)(centerX - 150), (int)y, (int)0xFFFF55);
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.incomingRequests) {
                if (y > top - 40 && y < top + height) {
                    this.renderPendingRequest(poseStack, mouseX, mouseY, centerX, y, req, true);
                }
                y += 40;
            }
            y += 10;
        }
        if (!this.acceptedFriends.isEmpty()) {
            UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a7a\u00a7lFriends (" + this.acceptedFriends.size() + ")"), (int)(centerX - 150), (int)y, (int)0x55FF55);
            y += 20;
            for (FriendsDataModels.FriendEntry friend : this.acceptedFriends) {
                if (y > top - 40 && y < top + height) {
                    this.renderFriend(poseStack, mouseX, mouseY, centerX, y, friend);
                }
                y += 40;
            }
        }
        if (!this.outgoingRequests.isEmpty()) {
            UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a77\u00a7lPending Sent (" + this.outgoingRequests.size() + ")"), (int)(centerX - 150), (int)(y += 10), (int)0xAAAAAA);
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.outgoingRequests) {
                if (y > top - 40 && y < top + height) {
                    this.renderPendingRequest(poseStack, mouseX, mouseY, centerX, y, req, false);
                }
                y += 40;
            }
        }
        if (this.acceptedFriends.isEmpty() && this.incomingRequests.isEmpty() && this.outgoingRequests.isEmpty()) {
            UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77No friends yet", (int)centerX, (int)(top + 50), (int)0xAAAAAA);
            UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77Add a friend using the box below!", (int)centerX, (int)(top + 65), (int)0xAAAAAA);
        }
    }

    private void renderPendingRequest(class_4587 poseStack, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.PendingRequestEntry req, boolean incoming) {
        int bgColor = incoming ? -2130716928 : 0x40555555;
        UnifiedFriendsScreen.method_25294((class_4587)poseStack, (int)(centerX - 150), (int)y, (int)(centerX + 150), (int)(y + 40 - 2), (int)bgColor);
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a7f" + req.username), (int)(centerX - 140), (int)(y + 8), (int)0xFFFFFF);
        String subtext = incoming ? "\u00a77wants to be friends" : "\u00a78Waiting...";
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)subtext, (int)(centerX - 140), (int)(y + 20), (int)(incoming ? 0xAAAAAA : 0x555555));
        if (incoming) {
            this.renderButton(poseStack, mouseX, mouseY, centerX + 40, y + 10, 45, "Accept", -16733696, -16724992);
            this.renderButton(poseStack, mouseX, mouseY, centerX + 90, y + 10, 45, "Reject", -5636096, -3407872);
        } else {
            this.renderButton(poseStack, mouseX, mouseY, centerX + 80, y + 10, 55, "Cancel", -8961024, -5614336);
        }
    }

    private void renderFriend(class_4587 poseStack, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.FriendEntry friend) {
        UnifiedFriendsScreen.method_25294((class_4587)poseStack, (int)(centerX - 150), (int)y, (int)(centerX + 150), (int)(y + 40 - 2), (int)0x40555555);
        String statusIndicator = friend.onlineStatus.indicator;
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)(statusIndicator + " \u00a7f" + friend.username), (int)(centerX - 140), (int)(y + 13), (int)0xFFFFFF);
        this.renderButton(poseStack, mouseX, mouseY, centerX + 20, y + 10, 55, "\ud83d\udcac Chat", -16759689, -16750934);
        this.renderButton(poseStack, mouseX, mouseY, centerX + 80, y + 10, 55, "Remove", -8978432, -3407872);
    }

    private void renderServersTab(class_4587 poseStack, int mouseX, int mouseY, int top, int height) {
        int y = top - this.scrollOffset;
        int centerX = this.field_22789 / 2;
        if (this.activeServers.isEmpty()) {
            UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77No active servers", (int)centerX, (int)(top + 50), (int)0xAAAAAA);
            return;
        }
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (y > top - 40 && y < top + height) {
                this.renderServer(poseStack, mouseX, mouseY, centerX, y, server);
            }
            y += 40;
        }
    }

    private void renderServer(class_4587 poseStack, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.ServerEntry server) {
        int bgColor = server.isCompatible ? 0x40555555 : 1079325491;
        UnifiedFriendsScreen.method_25294((class_4587)poseStack, (int)(centerX - 150), (int)y, (int)(centerX + 150), (int)(y + 40 - 2), (int)bgColor);
        String icon = server.isCompatible ? "\u00a7a[OK]" : "\u00a7c\u2717";
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)(icon + " \u00a7f" + server.serverName), (int)(centerX - 140), (int)(y + 6), (int)0xFFFFFF);
        UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a77" + server.hostName + " \u2022 " + server.gameMode), (int)(centerX - 140), (int)(y + 18), (int)0xAAAAAA);
        if (server.compatibility.minecraftVersion != null) {
            String badge = "\u00a7e" + server.compatibility.minecraftVersion;
            if (server.compatibility.modLoader != null) {
                String loaderColor = server.compatibility.modLoader.equals("fabric") ? "\u00a7b" : "\u00a7c";
                badge = badge + " " + loaderColor + server.compatibility.modLoader.toUpperCase();
            }
            UnifiedFriendsScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)badge, (int)(centerX - 140), (int)(y + 29), (int)0xFFFFFF);
        }
        int joinColor = server.isCompatible ? -16733696 : -8961024;
        int joinHover = server.isCompatible ? -16724992 : -5614336;
        this.renderButton(poseStack, mouseX, mouseY, centerX + 85, y + 10, 50, "Join", joinColor, joinHover);
    }

    private void renderButton(class_4587 poseStack, int mouseX, int mouseY, int x, int y, int width, String text, int color, int hoverColor) {
        boolean hover = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 18;
        UnifiedFriendsScreen.method_25294((class_4587)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + 18), (int)(hover ? hoverColor : color));
        UnifiedFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a7f" + text), (int)(x + width / 2), (int)(y + 5), (int)0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        int contentTop = 65;
        int contentBottom = this.field_22790 - 110;
        if (mouseY < (double)contentTop || mouseY > (double)contentBottom) {
            return super.method_25402(mouseX, mouseY, button);
        }
        int y = contentTop - this.scrollOffset;
        int centerX = this.field_22789 / 2;
        if (this.currentTab == Tab.FRIENDS) {
            return this.handleFriendsClick(mouseX, mouseY, centerX, y);
        }
        return this.handleServersClick(mouseX, mouseY, centerX, y);
    }

    private boolean handleFriendsClick(double mouseX, double mouseY, int centerX, int y) {
        if (!this.incomingRequests.isEmpty()) {
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.incomingRequests) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40)) {
                    if (this.clickInButton(mouseX, mouseY, centerX + 40, y + 10, 45)) {
                        this.acceptRequest(req.id, req.username);
                        return true;
                    }
                    if (this.clickInButton(mouseX, mouseY, centerX + 90, y + 10, 45)) {
                        this.rejectRequest(req.id);
                        return true;
                    }
                }
                y += 40;
            }
            y += 10;
        }
        if (!this.acceptedFriends.isEmpty()) {
            y += 20;
            for (FriendsDataModels.FriendEntry friend : this.acceptedFriends) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40)) {
                    if (this.clickInButton(mouseX, mouseY, centerX + 20, y + 10, 55)) {
                        this.field_22787.method_1507((class_437)new ChatScreen(this, friend.friendId, friend.username));
                        return true;
                    }
                    if (this.clickInButton(mouseX, mouseY, centerX + 80, y + 10, 55)) {
                        this.removeFriend(friend.id, friend.username);
                        return true;
                    }
                }
                y += 40;
            }
        }
        if (!this.outgoingRequests.isEmpty()) {
            y += 30;
            for (FriendsDataModels.PendingRequestEntry req : this.outgoingRequests) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40) && this.clickInButton(mouseX, mouseY, centerX + 80, y + 10, 55)) {
                    this.cancelRequest(req.id);
                    return true;
                }
                y += 40;
            }
        }
        return super.method_25402(mouseX, mouseY, 0);
    }

    private boolean handleServersClick(double mouseX, double mouseY, int centerX, int y) {
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (mouseY >= (double)y && mouseY < (double)(y + 40) && this.clickInButton(mouseX, mouseY, centerX + 85, y + 10, 50)) {
                this.joinServer(server.id, server.endpoint);
                return true;
            }
            y += 40;
        }
        return super.method_25402(mouseX, mouseY, 0);
    }

    private boolean clickInButton(double mouseX, double mouseY, int x, int y, int width) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + 18);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        this.scrollOffset = Math.max(0, this.scrollOffset - (int)(delta * 10.0));
        return true;
    }

    public void method_25419() {
        MessageManager.getInstance().unsubscribeFromUnreadCount(this.unreadCountListener);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum Tab {
        FRIENDS,
        SERVERS;

    }
}

