/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.auth;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.Message;

public class SupabaseClient {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private final OkHttpClient httpClient;
    private final TunnelConfig config = TunnelConfig.getInstance();

    public SupabaseClient() {
        this.httpClient = new OkHttpClient.Builder().connectTimeout(this.config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.config.getConnectionTimeout(), TimeUnit.MILLISECONDS).build();
    }

    private void logDebug(String message) {
        if (this.config.isDebugMode()) {
            System.out.println(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthResult signIn(String email, String password) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("email", email);
        requestBody.addProperty("password", password);
        String url = this.config.getSupabaseUrl() + "/auth/v1/token?grant_type=password";
        this.logDebug("[Tunnely] Attempting login to: " + url);
        Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson(requestBody))).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "No response body";
            this.logDebug("[Tunnely] Login response code: " + response.code());
            this.logDebug("[Tunnely] Login response: " + responseBody);
            if (response.isSuccessful()) {
                try {
                    JsonObject jsonResponse = GSON.fromJson(responseBody, JsonObject.class);
                    if (jsonResponse.has("access_token") && jsonResponse.has("user")) {
                        String accessToken = jsonResponse.get("access_token").getAsString();
                        JsonObject user = jsonResponse.getAsJsonObject("user");
                        if (user.has("id")) {
                            String userId = user.get("id").getAsString();
                            this.config.setUserJwtToken(accessToken);
                            this.config.setSupabaseUserId(userId);
                            this.config.save();
                            this.logDebug("[Tunnely] Login successful for user: " + userId);
                            AuthResult authResult = new AuthResult(true, accessToken, userId, null);
                            return authResult;
                        }
                        AuthResult authResult = new AuthResult(false, null, null, "Response missing user ID");
                        return authResult;
                    }
                    AuthResult authResult = new AuthResult(false, null, null, "Response missing access_token or user data");
                    return authResult;
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Failed to parse login response: " + e.getMessage());
                    AuthResult authResult = new AuthResult(false, null, null, "Failed to parse response: " + e.getMessage());
                    return authResult;
                }
            }
            String errorMsg = this.parseSupabaseError(responseBody);
            System.err.println("[Tunnely] Login failed: " + errorMsg);
            AuthResult authResult = new AuthResult(false, null, null, errorMsg);
            return authResult;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error during login: " + e.getMessage());
            e.printStackTrace();
            return new AuthResult(false, null, null, "Network error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestPasswordReset(String email) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("email", email);
        String url = this.config.getSupabaseUrl() + "/auth/v1/recover";
        this.logDebug("[Tunnely] Requesting password reset for: " + email);
        Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson(requestBody))).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "No response body";
            this.logDebug("[Tunnely] Password reset response code: " + response.code());
            this.logDebug("[Tunnely] Password reset response: " + responseBody);
            if (response.isSuccessful()) {
                this.logDebug("[Tunnely] Password reset email sent (if account exists)");
                boolean bl = true;
                return bl;
            }
            System.err.println("[Tunnely] Password reset request failed");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error during password reset: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthResult signUp(String email, String password, String minecraftUuid) {
        JsonObject metadata = new JsonObject();
        metadata.addProperty("minecraft_uuid", minecraftUuid);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("email", email);
        requestBody.addProperty("password", password);
        requestBody.add("data", metadata);
        String url = this.config.getSupabaseUrl() + "/auth/v1/signup";
        this.logDebug("[Tunnely] Attempting registration to: " + url);
        this.logDebug("[Tunnely] Registration email: " + email);
        Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson(requestBody))).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "No response body";
            this.logDebug("[Tunnely] Registration response code: " + response.code());
            this.logDebug("[Tunnely] Registration response: " + responseBody);
            if (response.isSuccessful()) {
                AuthResult authResult;
                try {
                    JsonObject user;
                    JsonObject jsonResponse = GSON.fromJson(responseBody, JsonObject.class);
                    if (jsonResponse.has("user") && !jsonResponse.has("access_token") && (user = jsonResponse.getAsJsonObject("user")).has("id")) {
                        String userId = user.get("id").getAsString();
                        this.logDebug("[Tunnely] Registration successful but requires email confirmation for user: " + userId);
                        AuthResult authResult2 = new AuthResult(false, null, userId, "Registration successful! Please check your email to confirm your account, then login.");
                        return authResult2;
                    }
                    if (jsonResponse.has("access_token") && jsonResponse.has("user")) {
                        String accessToken = jsonResponse.get("access_token").getAsString();
                        JsonObject user2 = jsonResponse.getAsJsonObject("user");
                        if (user2.has("id")) {
                            String userId = user2.get("id").getAsString();
                            this.config.setUserJwtToken(accessToken);
                            this.config.setSupabaseUserId(userId);
                            this.config.setMinecraftUuid(minecraftUuid);
                            this.config.save();
                            this.logDebug("[Tunnely] Registration successful for user: " + userId);
                            AuthResult authResult3 = new AuthResult(true, accessToken, userId, null);
                            return authResult3;
                        }
                        AuthResult authResult4 = new AuthResult(false, null, null, "Response missing user ID");
                        return authResult4;
                    }
                    authResult = new AuthResult(false, null, null, "Registration may require email confirmation. Check your email and then try logging in.");
                    return authResult;
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Failed to parse registration response: " + e.getMessage());
                    e.printStackTrace();
                    authResult = new AuthResult(false, null, null, "Failed to parse response: " + e.getMessage());
                    return authResult;
                }
            }
            String errorMsg = this.parseSupabaseError(responseBody);
            System.err.println("[Tunnely] Registration failed: " + errorMsg);
            AuthResult authResult = new AuthResult(false, null, null, errorMsg);
            return authResult;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error during registration: " + e.getMessage());
            e.printStackTrace();
            return new AuthResult(false, null, null, "Network error: " + e.getMessage());
        }
    }

    public boolean createOrUpdateProfile(String userId, String minecraftName, String minecraftUuid) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("id", userId);
        requestBody.addProperty("minecraft_name", minecraftName);
        requestBody.addProperty("minecraft_uuid", minecraftUuid);
        this.logDebug("[Tunnely] Creating/updating profile:");
        this.logDebug("  User ID: " + userId);
        this.logDebug("  Minecraft Name: " + minecraftName);
        this.logDebug("  Minecraft UUID: " + minecraftUuid);
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/user_profiles";
            Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("Content-Type", "application/json").addHeader("Prefer", "resolution=merge-duplicates,return=representation").post(RequestBody.create(JSON, GSON.toJson(requestBody)));
            Response response = this.httpClient.newCall(requestBuilder.build()).execute();
            String responseBody = response.body() != null ? response.body().string() : "No response";
            this.logDebug("[Tunnely] Profile upsert response code: " + response.code());
            this.logDebug("[Tunnely] Profile upsert response: " + responseBody);
            boolean success = response.isSuccessful();
            if (!success) {
                System.err.println("[Tunnely] Failed to upsert profile. Error: " + this.parseSupabaseError(responseBody));
            } else if (response.code() == 201) {
                this.logDebug("[Tunnely] Profile created successfully");
            } else {
                this.logDebug("[Tunnely] Profile updated successfully");
            }
            response.close();
            return success;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to create/update profile: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean updatePresence() {
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            return false;
        }
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("last_seen", this.getCurrentTimestamp());
        try {
            String url = this.config.getSupabaseUrl() + "/rest/v1/user_profiles?id=eq." + userId;
            Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("Content-Type", "application/json").patch(RequestBody.create(JSON, GSON.toJson(requestBody)));
            Response response = this.httpClient.newCall(requestBuilder.build()).execute();
            boolean success = response.isSuccessful();
            if (!success) {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to update presence: " + errorBody);
            }
            response.close();
            return success;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to update presence: " + e.getMessage());
            return false;
        }
    }

    private String getCurrentTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserLookupResult findUserByMinecraftName(String minecraftName) {
        this.logDebug("[Tunnely] Looking up user: " + minecraftName);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/user_profiles?minecraft_name=eq." + minecraftName + "&select=*", "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Lookup response: " + responseBody);
                JsonArray results = GSON.fromJson(responseBody, JsonArray.class);
                if (results.size() > 0) {
                    JsonObject user = results.get(0).getAsJsonObject();
                    String userId = user.get("id").getAsString();
                    String foundName = user.get("minecraft_name").getAsString();
                    UserLookupResult userLookupResult = new UserLookupResult(true, userId, foundName, null);
                    return userLookupResult;
                }
                UserLookupResult userLookupResult = new UserLookupResult(false, null, null, "User not found");
                return userLookupResult;
            }
            UserLookupResult userLookupResult = new UserLookupResult(false, null, null, "Failed to search users");
            return userLookupResult;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error looking up user: " + e.getMessage());
            e.printStackTrace();
            return new UserLookupResult(false, null, null, "Error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUsernameAvailable(String username) {
        this.logDebug("[Tunnely] Checking username availability: " + username);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/user_profiles?minecraft_name=eq." + username + "&select=id", "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                JsonArray results = GSON.fromJson(responseBody, JsonArray.class);
                boolean available = results.size() == 0;
                this.logDebug("[Tunnely] Username '" + username + "' is " + (available ? "available" : "taken"));
                boolean bl = available;
                return bl;
            }
            System.err.println("[Tunnely] Error checking username availability");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error checking username: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject getOwnProfile() {
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely] Cannot get profile: No user ID");
            return null;
        }
        this.logDebug("[Tunnely] Fetching profile for user: " + userId);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/user_profiles?id=eq." + userId + "&select=*", "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                JsonArray results = GSON.fromJson(responseBody, JsonArray.class);
                if (results.size() > 0) {
                    JsonObject profile = results.get(0).getAsJsonObject();
                    this.logDebug("[Tunnely] Profile found: " + profile.toString());
                    JsonObject jsonObject = profile;
                    return jsonObject;
                }
                this.logDebug("[Tunnely] No profile found for user");
                JsonObject jsonObject = null;
                return jsonObject;
            }
            System.err.println("[Tunnely] Failed to fetch profile");
            JsonObject jsonObject = null;
            return jsonObject;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error fetching profile: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean sendFriendRequestByUsername(String minecraftName) {
        this.logDebug("\n[Tunnely] === Sending Friend Request by Username ===");
        this.logDebug("[Tunnely] Target username: " + minecraftName);
        UserLookupResult lookup = this.findUserByMinecraftName(minecraftName);
        if (!lookup.success) {
            System.err.println("[Tunnely] Cannot send friend request: " + lookup.error);
            return false;
        }
        this.logDebug("[Tunnely] Found user ID: " + lookup.userId);
        String currentUserId = this.config.getSupabaseUserId();
        if (currentUserId == null || currentUserId.isEmpty()) {
            System.err.println("[Tunnely] Cannot send friend request: No current user ID");
            return false;
        }
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("user_id", currentUserId);
        requestBody.addProperty("friend_id", lookup.userId);
        requestBody.addProperty("status", "pending");
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends", "POST", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend request sent successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Friend request failed (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to send friend request: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean sendFriendRequest(String friendEmail) {
        this.logDebug("\n[Tunnely] === Sending Friend Request by Email ===");
        this.logDebug("[Tunnely] Target email: " + friendEmail);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("friend_email", friendEmail);
        requestBody.addProperty("status", "pending");
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends", "POST", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend request sent successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Friend request failed (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to send friend request: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean removeFriend(String friendId) {
        this.logDebug("\n[Tunnely] === Removing Friend ===");
        this.logDebug("[Tunnely] Friend ID: " + friendId);
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends?id=eq." + friendId, "DELETE", null);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend removed successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to remove friend (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to remove friend: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public FriendListResult getFriends() {
        this.logDebug("\n[Tunnely] === Getting Friends List ===");
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            return new FriendListResult(false, null, "Not authenticated");
        }
        String endpoint1 = "/rest/v1/friends?select=id,user_id,friend_id,status,created_at,updated_at,friend:friend_id(minecraft_name,minecraft_uuid,last_seen)&user_id=eq." + userId + "&status=eq.accepted";
        String endpoint2 = "/rest/v1/friends?select=id,user_id,friend_id,status,created_at,updated_at,friend:user_id(minecraft_name,minecraft_uuid,last_seen)&friend_id=eq." + userId + "&status=eq.accepted";
        this.logDebug("[Tunnely] Querying both directions for bidirectional friends");
        try {
            String result1 = "";
            String result2 = "";
            try (Response response = this.makeAuthenticatedRequest(endpoint1, "GET", null);){
                if (response.isSuccessful() && response.body() != null) {
                    result1 = response.body().string();
                }
            }
            response = this.makeAuthenticatedRequest(endpoint2, "GET", null);
            try {
                if (response.isSuccessful() && response.body() != null) {
                    result2 = response.body().string();
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            JsonArray array1 = JsonParser.parseString(result1).getAsJsonArray();
            JsonArray array2 = JsonParser.parseString(result2).getAsJsonArray();
            JsonArray merged = new JsonArray();
            for (JsonElement elem : array1) {
                merged.add(elem);
            }
            for (JsonElement elem : array2) {
                merged.add(elem);
            }
            String mergedJson = merged.toString();
            this.logDebug("[Tunnely] Friends list retrieved: " + merged.size() + " friends");
            return new FriendListResult(true, mergedJson, null);
        }
        catch (IOException e) {
            String errorMsg = "Network error fetching friends: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg);
            e.printStackTrace();
            return new FriendListResult(false, null, errorMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FriendListResult getPendingFriendRequests() {
        this.logDebug("\n[Tunnely] === Getting Pending Friend Requests ===");
        String endpoint = "/rest/v1/friends?select=*,requester:user_id(minecraft_name,minecraft_uuid)&friend_id=eq." + this.config.getSupabaseUserId() + "&status=eq.pending";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Pending requests retrieved successfully");
                FriendListResult friendListResult = new FriendListResult(true, responseBody, null);
                return friendListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch pending requests (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            FriendListResult friendListResult = new FriendListResult(false, null, errorMsg);
            return friendListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching pending requests: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new FriendListResult(false, null, errorMsg2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FriendListResult getOutgoingFriendRequests() {
        this.logDebug("\n[Tunnely] === Getting Outgoing Friend Requests ===");
        String endpoint = "/rest/v1/friends?select=*,friend:friend_id(minecraft_name,minecraft_uuid)&user_id=eq." + this.config.getSupabaseUserId() + "&status=eq.pending";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Outgoing requests retrieved successfully");
                FriendListResult friendListResult = new FriendListResult(true, responseBody, null);
                return friendListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch outgoing requests (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            FriendListResult friendListResult = new FriendListResult(false, null, errorMsg);
            return friendListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching outgoing requests: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new FriendListResult(false, null, errorMsg2);
        }
    }

    public boolean acceptFriendRequest(String friendRequestId) {
        this.logDebug("\n[Tunnely] === Accepting Friend Request ===");
        this.logDebug("[Tunnely] Request ID: " + friendRequestId);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("status", "accepted");
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends?id=eq." + friendRequestId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend request accepted");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to accept request (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to accept friend request: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean rejectFriendRequest(String friendRequestId) {
        this.logDebug("\n[Tunnely] === Rejecting Friend Request ===");
        this.logDebug("[Tunnely] Request ID: " + friendRequestId);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("status", "rejected");
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends?id=eq." + friendRequestId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend request rejected");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to reject request (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to reject friend request: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean cancelFriendRequest(String friendRequestId) {
        this.logDebug("\n[Tunnely] === Canceling Friend Request ===");
        this.logDebug("[Tunnely] Request ID: " + friendRequestId);
        Response response = this.makeAuthenticatedRequest("/rest/v1/friends?id=eq." + friendRequestId, "DELETE", null);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Friend request canceled");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to cancel request (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to cancel friend request: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendMessage(String recipientId, String content) {
        this.logDebug("\n[Tunnely] === Sending Message ===");
        this.logDebug("[Tunnely] To: " + recipientId);
        String senderId = this.config.getSupabaseUserId();
        if (senderId == null || senderId.isEmpty()) {
            System.err.println("[Tunnely] Not authenticated");
            return null;
        }
        String conversationId = Message.createConversationId(senderId, recipientId);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("sender_id", senderId);
        requestBody.addProperty("recipient_id", recipientId);
        requestBody.addProperty("content", content);
        requestBody.addProperty("conversation_id", conversationId);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/messages", "POST", requestBody);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                JsonArray results = JsonParser.parseString(responseBody).getAsJsonArray();
                if (results.size() <= 0) return null;
                JsonObject message = results.get(0).getAsJsonObject();
                String messageId = message.get("id").getAsString();
                this.logDebug("[Tunnely] Message sent: " + messageId);
                String string = messageId;
                return string;
            }
            String errorBody = response.body() != null ? response.body().string() : "No error body";
            System.err.println("[Tunnely] Failed to send message (HTTP " + response.code() + "): " + errorBody);
            return null;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to send message: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessagesResult getMessages(String friendId, int limit) {
        this.logDebug("\n[Tunnely] === Getting Messages ===");
        this.logDebug("[Tunnely] Friend ID: " + friendId);
        String userId = this.config.getSupabaseUserId();
        if (userId == null) return new MessagesResult(false, null, "Not authenticated");
        if (userId.isEmpty()) {
            return new MessagesResult(false, null, "Not authenticated");
        }
        String conversationId = Message.createConversationId(userId, friendId);
        String endpoint = "/rest/v1/messages?conversation_id=eq." + conversationId + "&order=sent_at.desc&limit=" + limit + "&select=*";
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Messages retrieved");
                MessagesResult messagesResult = new MessagesResult(true, responseBody, null);
                return messagesResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to get messages (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            MessagesResult messagesResult = new MessagesResult(false, null, errorMsg);
            return messagesResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new MessagesResult(false, null, errorMsg2);
        }
    }

    public boolean markMessageAsRead(String messageId) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("read_at", this.getCurrentTimestamp());
        Response response = this.makeAuthenticatedRequest("/rest/v1/messages?id=eq." + messageId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Message marked as read: " + messageId);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to mark message as read: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUnreadCount() {
        String userId = this.config.getSupabaseUserId();
        if (userId == null) return 0;
        if (userId.isEmpty()) {
            return 0;
        }
        String endpoint = "/rest/v1/messages?recipient_id=eq." + userId + "&read_at=is.null&select=id";
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (!response.isSuccessful()) return 0;
            if (response.body() == null) return 0;
            String responseBody = response.body().string();
            JsonArray messages = JsonParser.parseString(responseBody).getAsJsonArray();
            int n = messages.size();
            return n;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to get unread count: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerListResult getFriendServers() {
        this.logDebug("\n[Tunnely] === Getting Friend Servers ===");
        String endpoint = "/rest/v1/servers?status=eq.active&last_heartbeat=gte." + this.getTimestamp90SecondsAgo() + "&select=*,host:host_id(minecraft_name),minecraft_version,mod_loader,modpack_id,modpack_version&order=created_at.desc";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        this.logDebug("[Tunnely] Note: Filtering for active servers with heartbeat within last 90 seconds");
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Friend servers retrieved successfully");
                ServerListResult serverListResult = new ServerListResult(true, responseBody, null);
                return serverListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch friend servers (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            ServerListResult serverListResult = new ServerListResult(false, null, errorMsg);
            return serverListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching friend servers: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new ServerListResult(false, null, errorMsg2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InviteListResult getPendingInvites() {
        this.logDebug("\n[Tunnely] === Getting Pending Invites ===");
        String endpoint = "/rest/v1/invites?status=eq.pending&select=*";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Invites retrieved successfully");
                InviteListResult inviteListResult = new InviteListResult(true, responseBody, null);
                return inviteListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch invites (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            InviteListResult inviteListResult = new InviteListResult(false, null, errorMsg);
            return inviteListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching invites: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new InviteListResult(false, null, errorMsg2);
        }
    }

    public boolean sendInvite(String serverId, String friendEmail) {
        this.logDebug("\n[Tunnely] === Sending Invite ===");
        this.logDebug("[Tunnely] Server ID: " + serverId);
        this.logDebug("[Tunnely] Friend email: " + friendEmail);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("server_id", serverId);
        requestBody.addProperty("invitee_email", friendEmail);
        requestBody.addProperty("status", "pending");
        Response response = this.makeAuthenticatedRequest("/rest/v1/invites", "POST", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Invite sent successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Invite failed (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to send invite: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean acceptInvite(String inviteId) {
        this.logDebug("\n[Tunnely] === Accepting Invite ===");
        this.logDebug("[Tunnely] Invite ID: " + inviteId);
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("status", "accepted");
        Response response = this.makeAuthenticatedRequest("/rest/v1/invites?id=eq." + inviteId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Invite accepted successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to accept invite (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to accept invite: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean declineInvite(String inviteId) {
        this.logDebug("\n[Tunnely] === Declining Invite ===");
        this.logDebug("[Tunnely] Invite ID: " + inviteId);
        Response response = this.makeAuthenticatedRequest("/rest/v1/invites?id=eq." + inviteId, "DELETE", null);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Invite declined successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to decline invite (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to decline invite: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerListResult getPublicServers() {
        this.logDebug("\n[Tunnely] === Getting Public Servers ===");
        String endpoint = "/rest/v1/servers?status=eq.active&or=(visibility.eq.public,is_public.eq.true)&last_heartbeat=gte." + this.getTimestamp90SecondsAgo() + "&select=*,host:host_id(minecraft_name),minecraft_version,mod_loader,modpack_id,modpack_version,relay_region,relay_id,relay_url,current_players,max_players&order=created_at.desc";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        this.logDebug("[Tunnely] Note: Filtering for active servers with heartbeat within last 90 seconds");
        this.logDebug("[Tunnely] Note: Fetching compatibility fields (minecraft_version, mod_loader, modpack_id, modpack_version)");
        this.logDebug("[Tunnely] Note: Fetching player capacity fields (current_players, max_players)");
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Public servers retrieved successfully");
                ServerListResult serverListResult = new ServerListResult(true, responseBody, null);
                return serverListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch public servers (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            ServerListResult serverListResult = new ServerListResult(false, null, errorMsg);
            return serverListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching public servers: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new ServerListResult(false, null, errorMsg2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RelayListResult getAvailableRelays() {
        this.logDebug("\n[Tunnely] === Getting Available Relays ===");
        String endpoint = "/rest/v1/relays?status=eq.active&select=id,region,url,priority&order=priority.asc";
        this.logDebug("[Tunnely] Endpoint: " + endpoint);
        try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Relays retrieved successfully");
                RelayListResult relayListResult = new RelayListResult(true, responseBody, null);
                return relayListResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch relays (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            RelayListResult relayListResult = new RelayListResult(false, null, errorMsg);
            return relayListResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching relays: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            e.printStackTrace();
            return new RelayListResult(false, null, errorMsg2);
        }
    }

    private String getTimestamp90SecondsAgo() {
        long currentTimeMillis = System.currentTimeMillis();
        long ninetySecondsAgo = currentTimeMillis - 90000L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date(ninetySecondsAgo));
    }

    public boolean updateServerHeartbeat(String serverId, int currentPlayers, int maxPlayers) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("last_heartbeat", Instant.now().toString());
        requestBody.addProperty("status", "active");
        requestBody.addProperty("current_players", currentPlayers);
        requestBody.addProperty("max_players", maxPlayers);
        Response response = this.makeAuthenticatedRequest("/rest/v1/servers?id=eq." + serverId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (!success) {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to update heartbeat (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to update heartbeat: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean markServerInactive(String serverId) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("status", "inactive");
        Response response = this.makeAuthenticatedRequest("/rest/v1/servers?id=eq." + serverId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (!success) {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to mark inactive (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to mark server inactive: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean cleanupStaleServers() {
        this.logDebug("[Tunnely] Triggering cleanup of stale servers...");
        Response response = this.makeAuthenticatedRequest("/rest/v1/rpc/cleanup_stale_servers", "POST", new JsonObject());
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Cleanup completed successfully");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Cleanup failed (HTTP " + response.code() + "): " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to cleanup stale servers: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public Response makeAuthenticatedRequest(String endpoint, String method, JsonObject body) throws IOException {
        Response response;
        String url = this.config.getSupabaseUrl() + endpoint;
        this.logDebug("=== [Tunnely] Making Authenticated Request ===");
        this.logDebug("URL: " + url);
        this.logDebug("Method: " + method);
        this.logDebug("Endpoint: " + endpoint);
        this.logDebug("Has JWT Token: " + (this.config.getUserJwtToken() != null && !this.config.getUserJwtToken().isEmpty()));
        this.logDebug("JWT Token (first 20 chars): " + (String)(this.config.getUserJwtToken() != null && this.config.getUserJwtToken().length() > 20 ? this.config.getUserJwtToken().substring(0, 20) + "..." : "null"));
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).addHeader("Content-Type", "application/json");
        String requestBodyJson = "";
        if (body != null && !method.equals("GET")) {
            requestBodyJson = GSON.toJson(body);
            this.logDebug("Request Body: " + requestBodyJson);
            requestBuilder.method(method, RequestBody.create(JSON, requestBodyJson));
        } else if (method.equals("GET")) {
            this.logDebug("Request Body: (none - GET request)");
            requestBuilder.get();
        } else {
            this.logDebug("Request Body: (empty)");
            requestBuilder.method(method, RequestBody.create(JSON, ""));
        }
        if (method.equals("POST") || method.equals("PATCH")) {
            requestBuilder.addHeader("Prefer", "return=representation");
        }
        String responseBody = (response = this.httpClient.newCall(requestBuilder.build()).execute()).body() != null ? response.body().string() : "No response body";
        this.logDebug("Response Code: " + response.code());
        this.logDebug("Response Message: " + response.message());
        this.logDebug("Response Body: " + responseBody);
        this.logDebug("=== [Tunnely] Request Complete ===\n");
        return response.newBuilder().body(ResponseBody.create(response.body().contentType(), responseBody)).build();
    }

    public ServerRegistrationResult registerServer(String minecraftUuid, int serverPort, String gameMode, String visibility, String serverName, String minecraftVersion, String modLoader, String modpackId, String modpackVersion, String relayId, String relayRegion, String relayUrl, int maxPlayers) {
        return this.registerServer(minecraftUuid, serverPort, gameMode, visibility, serverName, minecraftVersion, modLoader, modpackId, modpackVersion, relayId, relayRegion, relayUrl, maxPlayers, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerRegistrationResult registerServer(String minecraftUuid, int serverPort, String gameMode, String visibility, String serverName, String minecraftVersion, String modLoader, String modpackId, String modpackVersion, String relayId, String relayRegion, String relayUrl, int maxPlayers, List<PortForwardingConfig> portForwards) {
        Object portObj;
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("host_id", this.config.getSupabaseUserId());
        requestBody.addProperty("minecraft_uuid", minecraftUuid);
        requestBody.addProperty("server_port", serverPort);
        requestBody.addProperty("game_mode", gameMode);
        requestBody.addProperty("status", "active");
        requestBody.addProperty("current_players", 0);
        requestBody.addProperty("max_players", maxPlayers);
        String validVisibility = visibility;
        if (!(visibility.equals("public") || visibility.equals("friends_only") || visibility.equals("invite_only"))) {
            validVisibility = "invite_only";
        }
        requestBody.addProperty("visibility", validVisibility);
        requestBody.addProperty("is_public", visibility.equals("public"));
        requestBody.addProperty("server_name", serverName);
        if (minecraftVersion != null && !minecraftVersion.isEmpty()) {
            requestBody.addProperty("minecraft_version", minecraftVersion);
        }
        if (modLoader != null && !modLoader.isEmpty()) {
            requestBody.addProperty("mod_loader", modLoader);
        }
        if (modpackId != null && !modpackId.isEmpty()) {
            requestBody.addProperty("modpack_id", modpackId);
        }
        if (modpackVersion != null && !modpackVersion.isEmpty()) {
            requestBody.addProperty("modpack_version", modpackVersion);
        }
        if (relayId != null && !relayId.isEmpty()) {
            requestBody.addProperty("relay_id", relayId);
        }
        if (relayRegion != null && !relayRegion.isEmpty()) {
            requestBody.addProperty("relay_region", relayRegion);
        }
        if (relayUrl != null && !relayUrl.isEmpty()) {
            requestBody.addProperty("relay_url", relayUrl);
        }
        if (portForwards != null && !portForwards.isEmpty()) {
            JsonArray forwardedPortsArray = new JsonArray();
            for (PortForwardingConfig portForwardingConfig : portForwards) {
                if (!portForwardingConfig.isEnabled()) continue;
                portObj = new JsonObject();
                ((JsonObject)portObj).addProperty("port", portForwardingConfig.getPort());
                ((JsonObject)portObj).addProperty("protocol", portForwardingConfig.getProtocol().toString());
                ((JsonObject)portObj).addProperty("service", portForwardingConfig.getServiceName());
                forwardedPortsArray.add((JsonElement)portObj);
            }
            requestBody.add("forwarded_ports", forwardedPortsArray);
            this.logDebug("[Tunnely] Forwarding " + forwardedPortsArray.size() + " additional port(s)");
        }
        this.logDebug("[Tunnely] Server compatibility: MC " + minecraftVersion + ", Loader: " + (modLoader != null ? modLoader : "vanilla") + (String)(modpackId != null ? ", Modpack: " + modpackId + " v" + modpackVersion : ""));
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/servers", "POST", requestBody);){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                if (responseBody == null || responseBody.trim().isEmpty()) {
                    ServerRegistrationResult serverRegistrationResult = new ServerRegistrationResult(false, null, "Server created but response body is empty. Check Supabase response headers.");
                    return serverRegistrationResult;
                }
                JsonArray jsonArray = GSON.fromJson(responseBody, JsonArray.class);
                if (jsonArray == null || jsonArray.size() == 0) {
                    portObj = new ServerRegistrationResult(false, null, "Server created but response is empty array. Response: " + responseBody);
                    return portObj;
                }
                JsonObject jsonResponse = jsonArray.get(0).getAsJsonObject();
                if (!jsonResponse.has("id")) {
                    ServerRegistrationResult serverRegistrationResult = new ServerRegistrationResult(false, null, "Server created but response missing 'id' field. Response: " + responseBody);
                    return serverRegistrationResult;
                }
                String sessionId = jsonResponse.get("id").getAsString();
                ServerRegistrationResult serverRegistrationResult = new ServerRegistrationResult(true, sessionId, null);
                return serverRegistrationResult;
            }
            String errorMsg = response.body() != null ? response.body().string() : "Unknown error";
            ServerRegistrationResult serverRegistrationResult = new ServerRegistrationResult(false, null, errorMsg);
            return serverRegistrationResult;
        }
        catch (IOException e) {
            return new ServerRegistrationResult(false, null, "Failed to register server: " + e.getMessage());
        }
    }

    public boolean unregisterServer(String sessionId) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("status", "inactive");
        Response response = this.makeAuthenticatedRequest("/rest/v1/servers?id=eq." + sessionId, "PATCH", requestBody);
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to unregister server: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateServerEndpoint(String sessionId, String publicEndpoint) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("public_endpoint", publicEndpoint);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/servers?id=eq." + sessionId, "PATCH", requestBody);){
            if (response.isSuccessful()) {
                this.logDebug("[Tunnely] Updated server endpoint in database: " + publicEndpoint);
                boolean bl = true;
                return bl;
            }
            String errorMsg = response.body() != null ? response.body().string() : "Unknown error";
            System.err.println("[Tunnely] Failed to update server endpoint: " + errorMsg);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to update server endpoint: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateServerVisibility(String sessionId, String visibility) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("visibility", visibility);
        requestBody.addProperty("is_public", visibility.equals("public"));
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/servers?id=eq." + sessionId, "PATCH", requestBody);){
            if (response.isSuccessful()) {
                this.logDebug("[Tunnely] Updated server visibility in database: " + visibility);
                boolean bl = true;
                return bl;
            }
            String errorMsg = response.body() != null ? response.body().string() : "Unknown error";
            System.err.println("[Tunnely] Failed to update server visibility: " + errorMsg);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to update server visibility: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String requestConnectionTicket(String sessionId) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("session_id", sessionId);
        try (Response response = this.makeAuthenticatedRequest("/functions/v1/generate-ticket", "POST", requestBody);){
            if (!response.isSuccessful()) return null;
            if (response.body() == null) return null;
            String responseBody = response.body().string();
            JsonObject jsonResponse = GSON.fromJson(responseBody, JsonObject.class);
            String string = jsonResponse.get("ticket").getAsString();
            return string;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to request ticket: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateAuth() {
        if (!this.config.isAuthenticated()) {
            return false;
        }
        try {
            String endpoint = "/rest/v1/user_profiles?select=id&limit=1";
            try (Response response = this.makeAuthenticatedRequest(endpoint, "GET", null);){
                if (response.isSuccessful()) {
                    boolean bl = true;
                    return bl;
                }
                if (response.code() == 401 || response.code() == 403) {
                    System.err.println("[Tunnely] Auth validation failed: token is invalid or expired");
                    this.config.clearAuth();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Auth validation error: " + e.getMessage());
            return false;
        }
    }

    public boolean needsLogin() {
        return !this.config.isAuthenticated() || !this.validateAuth();
    }

    public boolean isTokenValid() {
        if (!this.config.isAuthenticated()) {
            return false;
        }
        Response response = this.makeAuthenticatedRequest("/rest/v1/servers?limit=1", "GET", null);
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean recordTosAcceptance(String tosVersion) {
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely] Cannot record TOS acceptance: No user ID available");
            return false;
        }
        if (tosVersion == null || tosVersion.isEmpty()) {
            System.err.println("[Tunnely] Cannot record TOS acceptance: No version provided");
            return false;
        }
        this.logDebug("[Tunnely] Recording TOS acceptance: version " + tosVersion + " for user " + userId);
        try {
            String endpoint = "/rest/v1/rpc/add_tos_acceptance";
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("p_user_id", userId);
            requestBody.addProperty("p_version", tosVersion);
            try (Response response = this.makeAuthenticatedRequest(endpoint, "POST", requestBody);){
                if (response.isSuccessful()) {
                    this.logDebug("[Tunnely] TOS acceptance recorded in database");
                    boolean bl = true;
                    return bl;
                }
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to record TOS acceptance (HTTP " + response.code() + "): " + errorBody);
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error recording TOS acceptance: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthResult signInWithOAuth(String accessToken) {
        this.logDebug("[Tunnely] Validating OAuth token with Supabase...");
        this.config.setUserJwtToken(accessToken);
        String url = this.config.getSupabaseUrl() + "/auth/v1/user";
        Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + accessToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "No response body";
            this.logDebug("[Tunnely] OAuth user info response code: " + response.code());
            if (response.isSuccessful()) {
                try {
                    JsonObject user = GSON.fromJson(responseBody, JsonObject.class);
                    if (user.has("id")) {
                        String userId = user.get("id").getAsString();
                        this.config.setSupabaseUserId(userId);
                        this.config.save();
                        this.logDebug("[Tunnely] OAuth login successful for user: " + userId);
                        AuthResult authResult = new AuthResult(true, accessToken, userId, null);
                        return authResult;
                    }
                    AuthResult authResult = new AuthResult(false, null, null, "Response missing user ID");
                    return authResult;
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Failed to parse user response: " + e.getMessage());
                    AuthResult authResult = new AuthResult(false, null, null, "Failed to parse response: " + e.getMessage());
                    return authResult;
                }
            }
            String errorMsg = this.parseSupabaseError(responseBody);
            System.err.println("[Tunnely] OAuth validation failed: " + errorMsg);
            AuthResult authResult = new AuthResult(false, null, null, errorMsg);
            return authResult;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error during OAuth validation: " + e.getMessage());
            e.printStackTrace();
            return new AuthResult(false, null, null, "Network error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthResult exchangeCodeForToken(String code, String redirectUri) {
        this.logDebug("[Tunnely] Exchanging OAuth code for token...");
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("grant_type", "authorization_code");
        requestBody.addProperty("code", code);
        requestBody.addProperty("redirect_uri", redirectUri);
        String url = this.config.getSupabaseUrl() + "/auth/v1/token";
        Request request = new Request.Builder().url(url).post(RequestBody.create(JSON, GSON.toJson(requestBody))).addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "No response body";
            this.logDebug("[Tunnely] Token exchange response code: " + response.code());
            if (response.isSuccessful()) {
                try {
                    JsonObject jsonResponse = GSON.fromJson(responseBody, JsonObject.class);
                    if (jsonResponse.has("access_token") && jsonResponse.has("user")) {
                        String accessToken = jsonResponse.get("access_token").getAsString();
                        JsonObject user = jsonResponse.getAsJsonObject("user");
                        if (user.has("id")) {
                            String userId = user.get("id").getAsString();
                            this.config.setUserJwtToken(accessToken);
                            this.config.setSupabaseUserId(userId);
                            this.config.save();
                            this.logDebug("[Tunnely] Token exchange successful for user: " + userId);
                            AuthResult authResult = new AuthResult(true, accessToken, userId, null);
                            return authResult;
                        }
                        AuthResult authResult = new AuthResult(false, null, null, "Response missing user ID");
                        return authResult;
                    }
                    AuthResult authResult = new AuthResult(false, null, null, "Response missing access_token or user data");
                    return authResult;
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Failed to parse token response: " + e.getMessage());
                    AuthResult authResult = new AuthResult(false, null, null, "Failed to parse response: " + e.getMessage());
                    return authResult;
                }
            }
            String errorMsg = this.parseSupabaseError(responseBody);
            System.err.println("[Tunnely] Token exchange failed: " + errorMsg);
            AuthResult authResult = new AuthResult(false, null, null, errorMsg);
            return authResult;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Network error during token exchange: " + e.getMessage());
            e.printStackTrace();
            return new AuthResult(false, null, null, "Network error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserEmail() {
        String url = this.config.getSupabaseUrl() + "/auth/v1/user";
        Request request = new Request.Builder().url(url).get().addHeader("apikey", this.config.getSupabaseAnonKey()).addHeader("Authorization", "Bearer " + this.config.getUserJwtToken()).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) return null;
            if (response.body() == null) return null;
            JsonObject user = GSON.fromJson(response.body().string(), JsonObject.class);
            if (!user.has("email")) return null;
            String string = user.get("email").getAsString();
            return string;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error getting user email: " + e.getMessage());
        }
        return null;
    }

    private String parseSupabaseError(String responseBody) {
        try {
            JsonObject errorResponse = GSON.fromJson(responseBody, JsonObject.class);
            if (errorResponse.has("error_description")) {
                return errorResponse.get("error_description").getAsString();
            }
            if (errorResponse.has("error")) {
                return errorResponse.get("error").getAsString();
            }
            if (errorResponse.has("msg")) {
                return errorResponse.get("msg").getAsString();
            }
            if (errorResponse.has("message")) {
                return errorResponse.get("message").getAsString();
            }
            return responseBody;
        }
        catch (Exception e) {
            return responseBody;
        }
    }

    public boolean uploadPublicKey(String publicKey) {
        this.logDebug("\n[Tunnely] === Uploading Public Key ===");
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely] Not authenticated");
            return false;
        }
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("public_key", publicKey);
        Response response = this.makeAuthenticatedRequest("/rest/v1/user_profiles?id=eq." + userId, "PATCH", requestBody);
        try {
            boolean success = response.isSuccessful();
            if (success) {
                this.logDebug("[Tunnely] Public key uploaded");
            } else {
                String errorBody = response.body() != null ? response.body().string() : "No error body";
                System.err.println("[Tunnely] Failed to upload public key: " + errorBody);
            }
            boolean bl = success;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Tunnely] Failed to upload public key: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchPublicKey(String userId) {
        this.logDebug("[Tunnely] Fetching public key for user: " + userId);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/user_profiles?id=eq." + userId + "&select=public_key", "GET", null);){
            if (response.isSuccessful() && response.body() != null) {
                JsonObject user;
                String responseBody = response.body().string();
                JsonArray results = JsonParser.parseString(responseBody).getAsJsonArray();
                if (results.size() > 0 && (user = results.get(0).getAsJsonObject()).has("public_key") && !user.get("public_key").isJsonNull()) {
                    String publicKey = user.get("public_key").getAsString();
                    this.logDebug("[Tunnely] Public key fetched");
                    String string = publicKey;
                    return string;
                }
                this.logDebug("[Tunnely] User has no public key (E2EE not enabled)");
                String string = null;
                return string;
            }
            String errorBody = response.body() != null ? response.body().string() : "No error body";
            System.err.println("[Tunnely] Failed to fetch public key: " + errorBody);
            String string = null;
            return string;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to fetch public key: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateRelayConnectionTicket(String challenge) {
        this.logDebug("\n[Tunnely] === Generating Relay Connection Ticket ===");
        this.logDebug("[Tunnely] Challenge: " + challenge.substring(0, Math.min(20, challenge.length())) + "...");
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely] Not authenticated - cannot generate ticket");
            return null;
        }
        String ticket = UUID.randomUUID().toString() + UUID.randomUUID().toString().replace("-", "");
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("user_id", userId);
        requestBody.addProperty("ticket", ticket);
        requestBody.addProperty("challenge", challenge);
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/relay_tickets", "POST", requestBody);){
            if (response.isSuccessful()) {
                this.logDebug("[Tunnely] Relay connection ticket generated successfully");
                String string = ticket;
                return string;
            }
            String errorBody = response.body() != null ? response.body().string() : "No error body";
            System.err.println("[Tunnely] Failed to generate relay ticket: " + errorBody);
            String string = null;
            return string;
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to generate relay ticket: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RelayMeshResult getRelayMeshTopology() {
        this.logDebug("\n[Tunnely] === Getting Relay Mesh Topology ===");
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/rpc/get_relay_mesh_topology", "POST", new JsonObject());){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Relay mesh topology retrieved");
                RelayMeshResult relayMeshResult = new RelayMeshResult(true, responseBody, null);
                return relayMeshResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch relay mesh (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            RelayMeshResult relayMeshResult = new RelayMeshResult(false, null, errorMsg);
            return relayMeshResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching relay mesh: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            return new RelayMeshResult(false, null, errorMsg2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RelayMeshStatsResult getRelayMeshStats() {
        this.logDebug("\n[Tunnely] === Getting Relay Mesh Stats ===");
        try (Response response = this.makeAuthenticatedRequest("/rest/v1/rpc/get_relay_mesh_stats", "POST", new JsonObject());){
            if (response.isSuccessful() && response.body() != null) {
                String responseBody = response.body().string();
                this.logDebug("[Tunnely] Relay mesh stats retrieved");
                RelayMeshStatsResult relayMeshStatsResult = new RelayMeshStatsResult(true, responseBody, null);
                return relayMeshStatsResult;
            }
            String errorBody222 = response.body() != null ? response.body().string() : "No error body";
            String errorMsg = "Failed to fetch relay mesh stats (HTTP " + response.code() + "): " + errorBody222;
            System.err.println("[Tunnely] " + errorMsg);
            RelayMeshStatsResult relayMeshStatsResult = new RelayMeshStatsResult(false, null, errorMsg);
            return relayMeshStatsResult;
        }
        catch (IOException e) {
            String errorMsg2 = "Network error fetching relay mesh stats: " + e.getMessage();
            System.err.println("[Tunnely] " + errorMsg2);
            return new RelayMeshStatsResult(false, null, errorMsg2);
        }
    }

    public static class AuthResult {
        public final boolean success;
        public final String accessToken;
        public final String userId;
        public final String error;

        public AuthResult(boolean success, String accessToken, String userId, String error) {
            this.success = success;
            this.accessToken = accessToken;
            this.userId = userId;
            this.error = error;
        }
    }

    public static class UserLookupResult {
        public final boolean success;
        public final String userId;
        public final String minecraftName;
        public final String error;

        public UserLookupResult(boolean success, String userId, String minecraftName, String error) {
            this.success = success;
            this.userId = userId;
            this.minecraftName = minecraftName;
            this.error = error;
        }
    }

    public static class FriendListResult {
        public final boolean success;
        public final String data;
        public final String error;

        public FriendListResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class MessagesResult {
        public final boolean success;
        public final String data;
        public final String error;

        public MessagesResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class ServerListResult {
        public final boolean success;
        public final String data;
        public final String error;

        public ServerListResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class InviteListResult {
        public final boolean success;
        public final String data;
        public final String error;

        public InviteListResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class RelayListResult {
        public final boolean success;
        public final String data;
        public final String error;

        public RelayListResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class ServerRegistrationResult {
        public final boolean success;
        public final String sessionId;
        public final String error;

        public ServerRegistrationResult(boolean success, String sessionId, String error) {
            this.success = success;
            this.sessionId = sessionId;
            this.error = error;
        }
    }

    public static class RelayMeshResult {
        public final boolean success;
        public final String data;
        public final String error;

        public RelayMeshResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }

    public static class RelayMeshStatsResult {
        public final boolean success;
        public final String data;
        public final String error;

        public RelayMeshStatsResult(boolean success, String data, String error) {
            this.success = success;
            this.data = data;
            this.error = error;
        }
    }
}

