/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;

public class InviteFriendsScreen
extends class_437 {
    private final class_437 parent;
    private final String serverId;
    private FriendListWidget friendList;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public InviteFriendsScreen(class_437 parent, String serverId) {
        super((class_2561)class_2561.method_43470((String)"Invite Friends"));
        this.parent = parent;
        this.serverId = serverId;
    }

    protected void method_25426() {
        super.method_25426();
        this.friendList = new FriendListWidget(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 60, 35);
        this.method_25429((class_364)this.friendList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04 Refresh"), button -> this.loadFriends()).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 50, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 55, this.field_22790 - 50, 100, 20).method_46431());
        this.loadFriends();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS FOR INVITE =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.field_22787.execute(() -> {
                    block13: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends for invite...");
                                JsonArray friends = JsonParser.parseString(result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " total friend(s)");
                                int acceptedCount = 0;
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                    break block13;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friend = element.getAsJsonObject();
                                    if (!friend.has("status") || !friend.get("status").getAsString().equals("accepted")) continue;
                                    String minecraftName = "Unknown";
                                    String friendEmail = "unknown@example.com";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull()) {
                                        JsonObject friendProfile = friend.getAsJsonObject("friend");
                                        if (friendProfile.has("minecraft_name")) {
                                            minecraftName = friendProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (friend.has("friend_name")) {
                                        minecraftName = friend.get("friend_name").getAsString();
                                    }
                                    if (friend.has("friend_email")) {
                                        friendEmail = friend.get("friend_email").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Available to invite: " + minecraftName);
                                    this.friendList.addFriend(friendEmail, minecraftName);
                                    ++acceptedCount;
                                }
                                if (acceptedCount == 0) {
                                    this.statusMessage = "\u00a77No accepted friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                } else {
                                    this.statusMessage = "\u00a7aSelect friends to invite";
                                    this.statusColor = 65280;
                                }
                                System.out.println("[Tunnely UI] " + acceptedCount + " accepted friend(s) available");
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriendsInvite").start();
    }

    private void inviteFriend(String friendEmail, String friendName) {
        System.out.println("[Tunnely UI] ===== INVITING FRIEND =====");
        System.out.println("[Tunnely UI] Friend: " + friendName + " (" + friendEmail + ")");
        System.out.println("[Tunnely UI] Server ID: " + this.serverId);
        this.statusMessage = "\u00a7eSending invite to " + friendName + "...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendInvite(this.serverId, friendEmail);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite sent to " + friendName + "!";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite sent successfully");
                    } else {
                        this.statusMessage = "\u00a7cFailed to send invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to send invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception sending invite: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-SendInvite").start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.friendList.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_25300(this.field_22793, "\u00a76\u00a7lInvite Friends to Server", this.field_22789 / 2, 20, ColorUtil.opaque(0xFFFFFF));
        graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, 35, ColorUtil.opaque(this.statusColor));
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class FriendListWidget
    extends class_4280<FriendEntry> {
        public FriendListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.method_25339();
        }

        public void addFriend(String email, String name) {
            this.method_25321((class_350.class_351)new FriendEntry(email, name));
        }

        class FriendEntry
        extends class_4280.class_4281<FriendEntry> {
            private final String email;
            private final String name;
            private final class_4185 inviteButton;

            public FriendEntry(String email, String name) {
                this.email = email;
                this.name = name;
                this.inviteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invite"), button -> InviteFriendsScreen.this.inviteFriend(email, name)).method_46434(0, 0, 60, 20).method_46431();
            }

            public void method_25343(class_332 graphics, int index, int top, boolean isMouseOver, float partialTick) {
                int left = FriendListWidget.this.method_25342();
                int width = FriendListWidget.this.method_25322();
                int mouseX = (int)((FriendListWidget)FriendListWidget.this).field_22740.field_1729.method_1603() * FriendListWidget.this.field_22740.method_22683().method_4486() / FriendListWidget.this.field_22740.method_22683().method_4480();
                int mouseY = (int)((FriendListWidget)FriendListWidget.this).field_22740.field_1729.method_1604() * FriendListWidget.this.field_22740.method_22683().method_4502() / FriendListWidget.this.field_22740.method_22683().method_4507();
                graphics.method_25303(InviteFriendsScreen.this.field_22793, "\u00a7b" + this.name, left + 5, top + 8, 0xFFFFFF);
                this.inviteButton.method_46421(left + width - 70);
                this.inviteButton.method_46419(top + 7);
                this.inviteButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(class_11909 event, boolean dragging) {
                return this.inviteButton.method_25402(event, dragging);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.name);
            }
        }
    }
}

