/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.FriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.JoinFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;

public class TunnelyMultiplayerScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelConfig config;
    private final List<class_4185> menuButtons = new ArrayList<class_4185>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private class_4185 donateButton;
    private class_4185 backButton;

    public TunnelyMultiplayerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tunnely Multiplayer"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void method_25426() {
        SupabaseClient client;
        super.method_25426();
        this.method_37067();
        if (this.config.isAuthenticated() && (client = new SupabaseClient()).needsLogin()) {
            this.field_22787.method_1507((class_437)new LoginScreen(this.parent));
            return;
        }
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.field_22789 * 0.3)));
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Login / Register"), b -> this.field_22787.method_1507((class_437)new LoginScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.setFooterMessage("\u00a77Please log in to access Tunnely multiplayer features", 0xAAAAAA);
        } else {
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Direct Join"), b -> this.field_22787.method_1507((class_437)new DirectJoinScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Join Friends"), b -> this.field_22787.method_1507((class_437)new JoinFriendsScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Public Lobbies"), b -> this.field_22787.method_1507((class_437)new PublicLobbiesScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Manage Friends"), b -> this.field_22787.method_1507((class_437)new FriendsScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invites"), b -> this.field_22787.method_1507((class_437)new InvitesScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Settings"), b -> this.field_22787.method_1507((class_437)new SettingsScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.field_22790 - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (class_4185 b2 : this.menuButtons) {
            this.method_37063((class_364)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        for (class_4185 b : this.menuButtons) {
            b.method_46421(centerX);
            b.method_46419(y);
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        this.donateButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Donate"), btn -> this.openDonate()).method_46434(centerX, this.field_22790 - 55, this.buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.donateButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), btn -> this.field_22787.method_1507(this.parent)).method_46434(centerX, this.field_22790 - 30, this.buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    private void openDonate() {
        try {
            class_156.method_668().method_670("https://modrinth.com/mod/tunnely");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.setFooterMessage("\u00a7cFailed to open browser", 0xFF5555);
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float delta) {
        g.method_25300(this.field_22793, "\u00a76\u00a7lTunnely Multiplayer", this.field_22789 / 2, 15, ColorUtil.opaque(0xFFAA00));
        boolean authed = this.config.isAuthenticated();
        if (authed) {
            String username = "Player";
            if (this.field_22787.field_1724 != null) {
                username = this.field_22787.field_1724.method_5477().getString();
            }
            g.method_25300(this.field_22793, "\u00a77Logged in as \u00a7b" + username, this.field_22789 / 2, 28, ColorUtil.opaque(0xAAAAAA));
        } else {
            g.method_25300(this.field_22793, "\u00a77Join servers and play with friends", this.field_22789 / 2, 28, ColorUtil.opaque(0xAAAAAA));
        }
        if (!this.footerMessage.isEmpty()) {
            g.method_25300(this.field_22793, this.footerMessage, this.field_22789 / 2, this.field_22790 - 65, ColorUtil.opaque(this.footerColor));
        }
        int areaH = Math.max(0, this.field_22790 - this.safeTop - 70);
        if (this.scrollable) {
            g.method_44379(0, this.safeTop, this.field_22789, this.safeTop + areaH);
        }
        for (class_4185 b : this.menuButtons) {
            b.method_25394(g, mouseX, mouseY, delta);
        }
        if (this.scrollable) {
            g.method_44380();
        }
        this.donateButton.method_25394(g, mouseX, mouseY, delta);
        this.backButton.method_25394(g, mouseX, mouseY, delta);
        super.method_25394(g, mouseX, mouseY, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scrollable) {
            int areaH = Math.max(0, this.field_22790 - this.safeTop - 70);
            int maxScroll = Math.max(0, this.stackTotalH - areaH);
            this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - scrollY * 10.0));
            this.layoutButtons();
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(class_11909 event, boolean dragging) {
        double mouseY = event.comp_4799();
        if (this.scrollable && mouseY >= (double)this.safeTop && mouseY <= (double)(this.field_22790 - 70)) {
            for (class_4185 btn : this.menuButtons) {
                if (!btn.method_25402(event, dragging)) continue;
                return true;
            }
        }
        return super.method_25402(event, dragging);
    }

    public void method_25410(class_310 mc, int w, int h) {
        super.method_25410(mc, w, h);
        this.method_37067();
        this.method_25426();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }
}

