/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;

public class TunnelCommand {
    private static final SuggestionProvider<class_2168> EMAIL_SUGGESTIONS = (context, builder) -> {
        builder.suggest("\"your-email@example.com\"", (Message)class_2561.method_43470((String)"Quote email due to @ symbol"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> PASSWORD_SUGGESTIONS = (context, builder) -> {
        builder.suggest("\"your-password\"", (Message)class_2561.method_43470((String)"Your account password"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> VISIBILITY_SUGGESTIONS = (context, builder) -> {
        builder.suggest("public", (Message)class_2561.method_43470((String)"\ud83c\udf10 Anyone can join - listed in public browser"));
        builder.suggest("friends", (Message)class_2561.method_43470((String)"\ud83d\udc65 Only friends can join"));
        builder.suggest("invite", (Message)class_2561.method_43470((String)"\ud83d\udd12 Most secure - invite only (default)"));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SERVER_NAME_SUGGESTIONS = (context, builder) -> {
        TunnelConfig config = TunnelConfig.getInstance();
        builder.suggest("\"" + config.getSavedServerName() + "\"", (Message)class_2561.method_43470((String)"Current saved server name"));
        builder.suggest("\"My Awesome Server\"", (Message)class_2561.method_43470((String)"Example: custom server name"));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tunnel").then(class_2170.method_9247((String)"status").executes(TunnelCommand::status))).then(class_2170.method_9247((String)"menu").executes(TunnelCommand::openMenu))).then(class_2170.method_9247((String)"login").then(class_2170.method_9244((String)"email", (ArgumentType)StringArgumentType.string()).suggests(EMAIL_SUGGESTIONS).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).suggests(PASSWORD_SUGGESTIONS).executes(TunnelCommand::login))))).then(class_2170.method_9247((String)"register").then(class_2170.method_9244((String)"email", (ArgumentType)StringArgumentType.string()).suggests(EMAIL_SUGGESTIONS).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).suggests(PASSWORD_SUGGESTIONS).executes(TunnelCommand::register))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(source -> source.method_9259(2))).executes(TunnelCommand::start)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests(VISIBILITY_SUGGESTIONS).executes(TunnelCommand::startWithVisibility)).then(class_2170.method_9244((String)"serverName", (ArgumentType)StringArgumentType.greedyString()).suggests(SERVER_NAME_SUGGESTIONS).executes(TunnelCommand::startWithVisibilityAndName))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autostart").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"on").executes(TunnelCommand::autostartOn))).then(class_2170.method_9247((String)"off").executes(TunnelCommand::autostartOff))).executes(TunnelCommand::autostartStatus))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(source -> source.method_9259(2))).executes(TunnelCommand::stop))).then(class_2170.method_9247((String)"endpoint").executes(TunnelCommand::endpoint))).then(class_2170.method_9247((String)"help").executes(TunnelCommand::help)));
    }

    private static int status(CommandContext<class_2168> context) {
        TunnelManager.TunnelStatus status = TunnelManager.getInstance().getStatus();
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a76=== Tunnely Status ==="), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7eAuthenticated: " + (status.authenticated ? "\u00a7aYes" : "\u00a7cNo"))), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7eTunnel Connected: " + (status.connected ? "\u00a7aYes" : "\u00a7cNo"))), false);
        if (status.publicEndpoint != null) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7ePublic Endpoint: \u00a7b" + status.publicEndpoint)), false);
        }
        if (status.sessionId != null) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7eSession ID: \u00a77" + status.sessionId)), false);
        }
        return 1;
    }

    private static int openMenu(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_9228() != null && ((class_2168)context.getSource()).method_9225().field_9236) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Press \u00a7bU \u00a7eor use this command to open the menu"), false);
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] This command must be used from the client. Press \u00a7bU \u00a7eto open the menu."), false);
        }
        return 1;
    }

    private static int login(CommandContext<class_2168> context) {
        String email = StringArgumentType.getString(context, (String)"email");
        String password = StringArgumentType.getString(context, (String)"password");
        boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
        boolean hasOp = ((class_2168)context.getSource()).method_9259(2);
        if (isDedicatedServer && !hasOp) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Commands on multiplayer servers modify the SERVER's config, not yours!"));
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] To login to YOUR account, press \u00a7bU \u00a7eto open the Tunnely menu instead."));
            return 0;
        }
        if (isDedicatedServer && hasOp) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Logging in to the SERVER's account..."), false);
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Logging in..."), false);
        }
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().login(email, password);
            if (result.success) {
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7a[Tunnely] Login successful! User ID: " + result.userId)), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[Tunnely] Login failed: " + result.error)));
            }
        }, "Tunnely-Login").start();
        return 1;
    }

    private static int register(CommandContext<class_2168> context) {
        String email = StringArgumentType.getString(context, (String)"email");
        String password = StringArgumentType.getString(context, (String)"password");
        String minecraftUuid = "";
        if (((class_2168)context.getSource()).method_9228() != null) {
            minecraftUuid = ((class_2168)context.getSource()).method_9228().method_5845();
        }
        boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
        boolean hasOp = ((class_2168)context.getSource()).method_9259(2);
        if (isDedicatedServer && !hasOp) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Commands on multiplayer servers modify the SERVER's config, not yours!"));
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] To register YOUR account, press \u00a7bU \u00a7eto open the Tunnely menu instead."));
            return 0;
        }
        if (isDedicatedServer && hasOp) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Registering the SERVER's account..."), false);
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Registering account..."), false);
        }
        String finalUuid = minecraftUuid;
        new Thread(() -> {
            SupabaseClient.AuthResult result = TunnelManager.getInstance().register(email, password, finalUuid);
            if (result.success) {
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7a[Tunnely] Registration successful! User ID: " + result.userId)), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[Tunnely] Registration failed: " + result.error)));
            }
        }, "Tunnely-Register").start();
        return 1;
    }

    private static int start(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
            TunnelConfig config = TunnelConfig.getInstance();
            String visibility = isDedicatedServer ? config.getSavedVisibility() : "invite_only";
            String serverName = isDedicatedServer ? config.getSavedServerName() : "Minecraft Server";
            boolean success = TunnelManager.getInstance().initializeTunnel(((class_2168)context.getSource()).method_9211(), visibility, serverName);
            if (success) {
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                if (isDedicatedServer) {
                    ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                }
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int startWithVisibility(CommandContext<class_2168> context) {
        String visibilityArg = StringArgumentType.getString(context, (String)"visibility");
        String visibility = TunnelCommand.parseVisibility(visibilityArg);
        if (visibility == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Invalid visibility. Use: public, friends, or invite"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean success;
            String serverName;
            boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
            TunnelConfig config = TunnelConfig.getInstance();
            String string = serverName = isDedicatedServer ? config.getSavedServerName() : "Minecraft Server";
            if (isDedicatedServer) {
                config.setSavedVisibility(visibility);
            }
            if (success = TunnelManager.getInstance().initializeTunnel(((class_2168)context.getSource()).method_9211(), visibility, serverName)) {
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                if (isDedicatedServer) {
                    ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a77Settings saved! Use \u00a7e/tunnel autostart on \u00a77to enable auto-start."), false);
                }
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int startWithVisibilityAndName(CommandContext<class_2168> context) {
        String visibilityArg = StringArgumentType.getString(context, (String)"visibility");
        String visibility = TunnelCommand.parseVisibility(visibilityArg);
        String serverName = StringArgumentType.getString(context, (String)"serverName");
        if (visibility == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Invalid visibility. Use: public, friends, or invite"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Starting tunnel..."), false);
        new Thread(() -> {
            boolean success;
            boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
            TunnelConfig config = TunnelConfig.getInstance();
            if (isDedicatedServer) {
                config.setSavedVisibility(visibility);
                config.setSavedServerName(serverName);
            }
            if (success = TunnelManager.getInstance().initializeTunnel(((class_2168)context.getSource()).method_9211(), visibility, serverName)) {
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7a[Tunnely] Tunnel started successfully!"), false);
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a77Visibility: \u00a7b" + visibility + " \u00a77| Server name: \u00a7b" + serverName)), false);
                if (isDedicatedServer) {
                    ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a77Settings saved! Use \u00a7e/tunnel autostart on \u00a77to enable auto-start."), false);
                }
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Failed to start tunnel. Check console for details."));
            }
        }, "Tunnely-Start-Command").start();
        return 1;
    }

    private static int stop(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Stopping tunnel..."), false);
        TunnelManager.getInstance().shutdownTunnel();
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7a[Tunnely] Tunnel stopped"), false);
        return 1;
    }

    private static int endpoint(CommandContext<class_2168> context) {
        String endpoint = TunnelManager.getInstance().getPublicEndpoint();
        if (endpoint != null) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7e[Tunnely] Public Endpoint: \u00a7b" + endpoint)), false);
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a77Share this address with your friends to let them join!"), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] No active tunnel. Use /tunnel start to create one."));
        }
        return 1;
    }

    private static int help(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a76=== Tunnely Commands ==="), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel status \u00a77- Show tunnel status"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel menu \u00a77- Open Tunnely UI (or press U)"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel login \"email@example.com\" <password> \u00a77- Login"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"  \u00a77(Quote email due to @ symbol)"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel register \"email@example.com\" <password> \u00a77- Register"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel start [visibility] [name] \u00a77- Start tunnel"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"  \u00a77Visibility: \u00a7bpublic\u00a77, \u00a7bfriends\u00a77, \u00a7binvite \u00a77(default)"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel autostart [on|off] \u00a77- Auto-start (dedicated servers)"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel stop \u00a77- Stop tunnel"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e/tunnel endpoint \u00a77- Show public endpoint"), false);
        return 1;
    }

    private static int autostartOn(CommandContext<class_2168> context) {
        boolean isDedicatedServer;
        boolean bl = isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
        if (!isDedicatedServer) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[Tunnely] Auto-start is only available for dedicated servers"));
            return 0;
        }
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAutoStartTunnel(true);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7a[Tunnely] Auto-start enabled!"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a77Tunnel will automatically start when server starts"), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a77Visibility: \u00a7b" + config.getSavedVisibility() + " \u00a77| Server name: \u00a7b" + config.getSavedServerName())), false);
        return 1;
    }

    private static int autostartOff(CommandContext<class_2168> context) {
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAutoStartTunnel(false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Auto-start disabled"), false);
        return 1;
    }

    private static int autostartStatus(CommandContext<class_2168> context) {
        boolean isDedicatedServer = !((class_2168)context.getSource()).method_9211().method_3724();
        TunnelConfig config = TunnelConfig.getInstance();
        if (!isDedicatedServer) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a7e[Tunnely] Auto-start: \u00a77Only available for dedicated servers"), false);
            return 1;
        }
        boolean enabled = config.isAutoStartTunnel();
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a7e[Tunnely] Auto-start: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        if (enabled) {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)("\u00a77Visibility: \u00a7b" + config.getSavedVisibility() + " \u00a77| Server name: \u00a7b" + config.getSavedServerName())), false);
        } else {
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7e/tunnel autostart on \u00a77to enable"), false);
        }
        return 1;
    }

    private static String parseVisibility(String arg) {
        switch (arg.toLowerCase()) {
            case "public": {
                return "public";
            }
            case "friends": {
                return "friends_only";
            }
            case "invite": {
                return "invite_only";
            }
        }
        return null;
    }
}

