/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5489;

public class ConnectionInfoScreen
extends class_437 {
    private final class_437 parent;
    private final String serverName;
    private final String errorType;
    private final String errorMessage;
    private class_5489 messageLabel;
    private class_4185 backButton;
    private class_4185 retryButton;
    private final Runnable retryAction;
    public static final String ERROR_FULL = "FULL";
    public static final String ERROR_NOT_AUTHORIZED = "NOT_AUTHORIZED";
    public static final String ERROR_NOT_FOUND = "NOT_FOUND";
    public static final String ERROR_CONNECTION_FAILED = "CONNECTION_FAILED";
    public static final String ERROR_INCOMPATIBLE = "INCOMPATIBLE";
    public static final String ERROR_GENERIC = "GENERIC";

    public ConnectionInfoScreen(class_437 parent, String serverName, String errorType, String errorMessage) {
        this(parent, serverName, errorType, errorMessage, null);
    }

    public ConnectionInfoScreen(class_437 parent, String serverName, String errorType, String errorMessage, Runnable retryAction) {
        super((class_2561)class_2561.method_43470((String)"Connection Info"));
        this.parent = parent;
        this.serverName = serverName != null ? serverName : "Server";
        this.errorType = errorType != null ? errorType : ERROR_GENERIC;
        this.errorMessage = errorMessage;
        this.retryAction = retryAction;
    }

    protected void method_25426() {
        super.method_25426();
        String displayMessage = this.buildDisplayMessage();
        this.messageLabel = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43470((String)displayMessage), (int)(this.field_22789 - 100));
        this.backButton = new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 50, 95, 20, (class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent));
        this.method_37063((class_364)this.backButton);
        if (this.retryAction != null && this.shouldShowRetry()) {
            this.retryButton = new class_4185(this.field_22789 / 2 + 5, this.field_22790 - 50, 95, 20, (class_2561)class_2561.method_43470((String)"Retry"), button -> {
                this.field_22787.method_1507(this.parent);
                this.retryAction.run();
            });
            this.method_37063((class_364)this.retryButton);
        }
    }

    private boolean shouldShowRetry() {
        return this.errorType.equals(ERROR_FULL) || this.errorType.equals(ERROR_CONNECTION_FAILED);
    }

    private String buildDisplayMessage() {
        String cleanError;
        switch (this.errorType) {
            case "FULL": {
                return "\u00a7c\u00a7lServer Full\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is currently full.\n\n\u00a77Please try again later when a slot becomes available.\n\u00a77You can refresh the server list to see updated player counts.\n\n\u00a78Tip: Join during off-peak hours for better availability.";
            }
            case "NOT_AUTHORIZED": {
                String authReason = this.extractAuthReason(this.errorMessage);
                if (authReason.contains("friends_only")) {
                    return "\u00a7c\u00a7lNot Authorized\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is set to \u00a7eFriends Only\u00a77.\n\n\u00a77You need to be friends with the host to join.\n\u00a77Send them a friend request or ask for an invite.";
                }
                if (authReason.contains("invite_only")) {
                    return "\u00a7c\u00a7lNot Authorized\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is set to \u00a7eInvite Only\u00a77.\n\n\u00a77You need an explicit invite to join this server.\n\u00a77Contact the host to request access.";
                }
                return "\u00a7c\u00a7lNot Authorized\n\n\u00a77You are not authorized to join '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Reason: \u00a7f" + authReason + "\n\n\u00a77Contact the server host for access.";
            }
            case "NOT_FOUND": {
                return "\u00a7c\u00a7lServer Not Found\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' could not be found.\n\n\u00a77Possible reasons:\n\u00a78\u2022 \u00a77The server has been shut down\n\u00a78\u2022 \u00a77The host closed the session\n\u00a78\u2022 \u00a77The server endpoint is invalid\n\n\u00a77Try refreshing the server list.";
            }
            case "CONNECTION_FAILED": {
                return "\u00a7c\u00a7lConnection Failed\n\n\u00a77Failed to connect to '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Possible causes:\n\u00a78\u2022 \u00a77Network connectivity issues\n\u00a78\u2022 \u00a77Relay server is down\n\u00a78\u2022 \u00a77Firewall blocking connection\n\n\u00a77Check your internet connection and try again.";
            }
            case "INCOMPATIBLE": {
                return "\u00a7c\u00a7lIncompatible Version\n\n\u00a77Cannot join '\u00a7f" + this.serverName + "\u00a77' - version mismatch.\n\n\u00a77Your game version, mod loader, or modpack differs from the server.\n\n\u00a77Make sure you have:\n\u00a78\u2022 \u00a77Same Minecraft version\n\u00a78\u2022 \u00a77Same mod loader (Fabric/Forge)\n\u00a78\u2022 \u00a77Same modpack (if applicable)";
            }
        }
        String string = cleanError = this.errorMessage != null ? this.errorMessage : "Unknown error";
        if (cleanError.startsWith("ERROR: ")) {
            cleanError = cleanError.substring(7);
        }
        return "\u00a7c\u00a7lConnection Error\n\n\u00a77Failed to join '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Error: \u00a7f" + cleanError + "\n\n\u00a77Please try again or contact the server host.";
    }

    private String extractAuthReason(String message) {
        int start;
        int end;
        if (message == null) {
            return "Unknown reason";
        }
        if (message.contains("(") && (end = message.indexOf(41, start = message.indexOf(40))) > start) {
            return message.substring(start + 1, end);
        }
        return message;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        String icon = this.getErrorIcon();
        int iconColor = this.getErrorColor();
        ConnectionInfoScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)icon, (int)(this.field_22789 / 2), (int)60, (int)iconColor);
        int messageY = 90;
        this.messageLabel.method_30888(poseStack, this.field_22789 / 2, messageY);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
    }

    private String getErrorIcon() {
        switch (this.errorType) {
            case "FULL": {
                return "\u00a7c\u00a7l\u26a0";
            }
            case "NOT_AUTHORIZED": {
                return "\u00a7c\u00a7l\ud83d\udd12";
            }
            case "NOT_FOUND": {
                return "\u00a7c\u00a7l\u274c";
            }
            case "CONNECTION_FAILED": {
                return "\u00a7c\u00a7l\u26a1";
            }
            case "INCOMPATIBLE": {
                return "\u00a7c\u00a7l\u2699";
            }
        }
        return "\u00a7c\u00a7l!";
    }

    private int getErrorColor() {
        switch (this.errorType) {
            case "FULL": {
                return 0xFFAA00;
            }
            case "NOT_AUTHORIZED": {
                return 0xFF5555;
            }
            case "NOT_FOUND": {
                return 0xAA0000;
            }
            case "CONNECTION_FAILED": {
                return 0xFF5555;
            }
            case "INCOMPATIBLE": {
                return 0xFFAA00;
            }
        }
        return 0xFF5555;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

