/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class JoinFriendsScreen
extends class_437 {
    private final class_437 parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading servers...";
    private int statusColor = 0xFFFF00;
    private boolean isLoading = true;

    public JoinFriendsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Join Friends"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.serverList = new ServerListWidget(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 60, 40);
        this.method_25429((class_364)this.serverList);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155, this.field_22790 - 50, 100, 20, (class_2561)class_2561.method_43470((String)"Refresh"), button -> this.loadServers()));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 55, this.field_22790 - 50, 100, 20, (class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)));
        this.loadServers();
    }

    private void loadServers() {
        System.out.println("[Tunnely UI] ===== LOADING FRIEND SERVERS =====");
        this.isLoading = true;
        this.statusMessage = "\u00a7eLoading servers...";
        this.statusColor = 0xFFFF00;
        this.serverList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getFriendServers();
                this.field_22787.execute(() -> {
                    block10: {
                        this.isLoading = false;
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing server data...");
                                JsonArray servers = JsonParser.parseString(result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + servers.size() + " server(s)");
                                if (servers.size() == 0) {
                                    this.statusMessage = "\u00a77No active servers from friends";
                                    this.statusColor = 0xAAAAAA;
                                    break block10;
                                }
                                for (JsonElement element : servers) {
                                    JsonObject server = element.getAsJsonObject();
                                    String serverId = server.get("id").getAsString();
                                    String endpoint = server.has("public_endpoint") ? server.get("public_endpoint").getAsString() : "N/A";
                                    String gameMode = server.has("game_mode") ? server.get("game_mode").getAsString() : "survival";
                                    String hostName = "Unknown";
                                    if (server.has("host") && !server.get("host").isJsonNull()) {
                                        JsonObject hostProfile = server.getAsJsonObject("host");
                                        if (hostProfile.has("minecraft_name")) {
                                            hostName = hostProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (server.has("host_name")) {
                                        hostName = server.get("host_name").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Server: " + hostName + " @ " + endpoint + " (" + gameMode + ")");
                                    this.serverList.addServer(serverId, hostName, endpoint, gameMode);
                                }
                                this.statusMessage = "\u00a7aFound " + servers.size() + " server(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse server list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing servers: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load servers: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading servers: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.isLoading = false;
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadServers").start();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        this.serverList.method_25394(poseStack, mouseX, mouseY, partialTick);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        JoinFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a76\u00a7lJoin Friends", (int)(this.field_22789 / 2), (int)20, (int)0xFFFFFF);
        JoinFriendsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)this.statusMessage, (int)(this.field_22789 / 2), (int)35, (int)this.statusColor);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class ServerListWidget
    extends class_4280<ServerEntry> {
        public ServerListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.method_25339();
        }

        public void addServer(String id, String hostName, String endpoint, String gameMode) {
            this.method_25321((class_350.class_351)new ServerEntry(id, hostName, endpoint, gameMode));
        }

        class ServerEntry
        extends class_4280.class_4281<ServerEntry> {
            private final String id;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final class_4185 joinButton;

            public ServerEntry(String id, String hostName, String endpoint, String gameMode) {
                this.id = id;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.joinButton = new class_4185(0, 0, 60, 20, (class_2561)class_2561.method_43470((String)"Join"), button -> this.joinServer());
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block5: {
                    System.out.println("[Tunnely UI] Join server requested for: " + this.endpoint);
                    if (this.endpoint == null || this.endpoint.equals("N/A") || !this.endpoint.contains("/")) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid server endpoint";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block5;
                        } else {
                            JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                            JoinFriendsScreen.this.statusColor = 0xFF0000;
                            return;
                        }
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    if (parts.length != 2) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                JoinFriendsScreen.this.statusMessage = "\u00a7eConnecting to " + this.hostName + "'s server...";
                JoinFriendsScreen.this.statusColor = 0xFFFF00;
                ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
                clientManager.connectToServer((String)relayUrl, sessionId, () -> JoinFriendsScreen.this.field_22787.execute(() -> {
                    JoinFriendsScreen.this.statusMessage = "\u00a7aConnecting to Minecraft server...";
                    JoinFriendsScreen.this.statusColor = 65280;
                    System.out.println("[Tunnely UI] Successfully connected to " + this.hostName + "'s server");
                }), error -> JoinFriendsScreen.this.field_22787.execute(() -> {
                    System.err.println("[Tunnely UI] Connection error: " + error);
                    String errorType = this.categorizeError((String)error);
                    JoinFriendsScreen.this.field_22787.method_1507((class_437)new ConnectionInfoScreen(JoinFriendsScreen.this.parent, this.hostName + "'s Server", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                }));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                class_332.method_25303((class_4587)poseStack, (class_327)JoinFriendsScreen.this.field_22793, (String)("\u00a7b" + this.hostName), (int)(left + 5), (int)(top + 5), (int)0xFFFFFF);
                class_332.method_25303((class_4587)poseStack, (class_327)JoinFriendsScreen.this.field_22793, (String)("\u00a77" + this.endpoint), (int)(left + 5), (int)(top + 18), (int)0xAAAAAA);
                class_332.method_25303((class_4587)poseStack, (class_327)JoinFriendsScreen.this.field_22793, (String)("\u00a7e" + this.gameMode), (int)(left + 5), (int)(top + 28), (int)0xFFFFFF);
                this.joinButton.field_22760 = left + width - 70;
                this.joinButton.field_22761 = top + 10;
                this.joinButton.method_25394(poseStack, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.joinButton.method_25402(mouseX, mouseY, button);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)(this.hostName + " - " + this.endpoint));
            }
        }
    }
}

