/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;

public class SettingsScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelConfig config;
    private class_4286 enableTunnelingCheckbox;
    private class_4286 debugModeCheckbox;
    private class_4286 messageNotificationsCheckbox;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String currentUsername = "";

    public SettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.field_22789 / 2 - buttonWidth / 2;
        int startY = this.field_22790 / 2 - 100;
        this.loadCurrentUsername();
        this.enableTunnelingCheckbox = new class_4286(centerX, startY, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Enable Tunneling"), this.config.isEnableTunneling());
        this.method_37063((class_364)this.enableTunnelingCheckbox);
        this.debugModeCheckbox = new class_4286(centerX, startY + 30, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Debug Mode"), this.config.isDebugMode());
        this.method_37063((class_364)this.debugModeCheckbox);
        this.messageNotificationsCheckbox = new class_4286(centerX, startY + 60, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Message Notifications"), this.config.isMessageNotificationsEnabled());
        this.method_37063((class_364)this.messageNotificationsCheckbox);
        this.method_37063((class_364)new class_4185(centerX, startY + 90, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Change Username"), button -> this.field_22787.method_1507((class_437)new UsernameSelectionScreen(this, false))));
        this.method_37063((class_364)new class_4185(centerX, startY + 120, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Logout"), button -> this.logout()));
        this.method_37063((class_364)new class_4185(centerX, startY + 150, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"\u00a7cDelete Account"), button -> this.openDeleteAccountPage()));
        this.method_37063((class_364)new class_4185(centerX, startY + 180, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Save Settings"), button -> this.saveSettings()));
        this.method_37063((class_364)new class_4185(centerX, this.field_22790 - 30, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)));
    }

    private void loadCurrentUsername() {
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                JsonObject profile = client.getOwnProfile();
                this.currentUsername = profile != null && profile.has("minecraft_name") ? profile.get("minecraft_name").getAsString() : "Not set";
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error loading username: " + e.getMessage());
                this.currentUsername = "Error loading";
            }
        }, "Tunnely-LoadUsername").start();
    }

    private void saveSettings() {
        this.config.setEnableTunneling(this.enableTunnelingCheckbox.method_20372());
        this.config.setDebugMode(this.debugModeCheckbox.method_20372());
        this.config.setMessageNotificationsEnabled(this.messageNotificationsCheckbox.method_20372());
        this.config.save();
        this.statusMessage = "\u00a7aSettings saved!";
        this.statusColor = 65280;
    }

    private void openDeleteAccountPage() {
        try {
            class_156.method_668().method_670("https://tunnely.org");
            this.statusMessage = "\u00a7eOpened account deletion page in browser";
            this.statusColor = 0xFFFF00;
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error opening browser: " + e.getMessage());
            this.statusMessage = "\u00a7cFailed to open browser";
            this.statusColor = 0xFF0000;
        }
    }

    private void logout() {
        PresenceManager.getInstance().stop();
        MessageManager.getInstance().stop();
        EncryptionKeyManager.reset();
        this.config.setUserJwtToken("");
        this.config.save();
        this.statusMessage = "\u00a7aLogged out successfully";
        this.statusColor = 65280;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new TunnelyMainScreen(this.parent)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        SettingsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a76\u00a7lSettings", (int)(this.field_22789 / 2), (int)30, (int)0xFFFFFF);
        if (!this.currentUsername.isEmpty()) {
            SettingsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)("\u00a77Current Username: \u00a7f" + this.currentUsername), (int)(this.field_22789 / 2), (int)50, (int)0xFFFFFF);
        }
        int infoY = 150;
        SettingsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77Configuration File:", (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + infoY), (int)0xAAAAAA);
        SettingsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a7econfig/tunnelyrefab.json", (int)(this.field_22789 / 2), (int)(this.field_22790 / 2 + infoY + 15), (int)0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            SettingsScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)this.statusMessage, (int)(this.field_22789 / 2), (int)(this.field_22790 - 50), (int)this.statusColor);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

