/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;

public class UsernameSelectionScreen
extends class_437 {
    private final class_437 parent;
    private final boolean isFirstTime;
    private class_342 usernameBox;
    private class_4185 confirmButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private boolean isChecking = false;

    public UsernameSelectionScreen(class_437 parent, boolean isFirstTime) {
        super((class_2561)class_2561.method_43470((String)(isFirstTime ? "Choose Your Username" : "Change Username")));
        this.parent = parent;
        this.isFirstTime = isFirstTime;
    }

    protected void method_25426() {
        super.method_25426();
        int inputWidth = 200;
        int inputHeight = 20;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.field_22789 / 2 - inputWidth / 2;
        int startY = this.field_22790 / 2 - 40;
        this.usernameBox = new class_342(this.field_22793, centerX, startY, inputWidth, inputHeight, (class_2561)class_2561.method_43470((String)"Username"));
        this.usernameBox.method_1880(16);
        if (!this.isFirstTime) {
            TunnelConfig config = TunnelConfig.getInstance();
            SupabaseClient client = new SupabaseClient();
            JsonObject profile = client.getOwnProfile();
            if (profile != null && profile.has("minecraft_name")) {
                this.usernameBox.method_1852(profile.get("minecraft_name").getAsString());
            }
        }
        this.method_37063((class_364)this.usernameBox);
        this.method_20085((class_364)this.usernameBox);
        this.confirmButton = new class_4185(centerX, startY + 35, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)(this.isFirstTime ? "Continue" : "Save")), button -> this.handleConfirm());
        this.method_37063((class_364)this.confirmButton);
        if (!this.isFirstTime) {
            this.method_37063((class_364)new class_4185(centerX, startY + 60, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)));
        }
    }

    private void handleConfirm() {
        if (this.isChecking) {
            return;
        }
        String username = this.usernameBox.method_1882().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() < 3) {
            this.statusMessage = "\u00a7cUsername must be at least 3 characters";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() > 16) {
            this.statusMessage = "\u00a7cUsername must be 16 characters or less";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]+$")) {
            this.statusMessage = "\u00a7cUsername can only contain letters, numbers, and underscores";
            this.statusColor = 0xFF5555;
            return;
        }
        this.isChecking = true;
        this.confirmButton.field_22763 = false;
        this.statusMessage = "\u00a7eChecking username availability...";
        this.statusColor = 0xFFFF55;
        String finalUsername = username;
        new Thread(() -> {
            try {
                boolean success;
                SupabaseClient client = new SupabaseClient();
                TunnelConfig config = TunnelConfig.getInstance();
                JsonObject currentProfile = client.getOwnProfile();
                String currentUsername = null;
                if (currentProfile != null && currentProfile.has("minecraft_name")) {
                    currentUsername = currentProfile.get("minecraft_name").getAsString();
                }
                if (currentUsername != null && currentUsername.equals(finalUsername)) {
                    this.field_22787.execute(() -> {
                        this.statusMessage = "\u00a7aUsername unchanged";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        this.confirmButton.field_22763 = true;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.field_22787.execute(() -> this.field_22787.method_1507(this.parent));
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                    return;
                }
                boolean available = client.isUsernameAvailable(finalUsername);
                if (!available) {
                    this.field_22787.execute(() -> {
                        this.statusMessage = "\u00a7cUsername is already taken";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.field_22763 = true;
                    });
                    return;
                }
                String userId = config.getSupabaseUserId();
                String minecraftUuid = "";
                if (this.field_22787.field_1724 != null) {
                    minecraftUuid = this.field_22787.field_1724.method_5845();
                }
                if (success = client.createOrUpdateProfile(userId, finalUsername, minecraftUuid)) {
                    this.field_22787.execute(() -> {
                        this.statusMessage = "\u00a7aUsername set successfully!";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.field_22787.execute(() -> {
                                    if (this.isFirstTime) {
                                        this.field_22787.method_1507((class_437)new TunnelyMainScreen(this.parent));
                                    } else {
                                        this.field_22787.method_1507(this.parent);
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                } else {
                    this.field_22787.execute(() -> {
                        this.statusMessage = "\u00a7cFailed to set username. Please try again.";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.field_22763 = true;
                    });
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error setting username: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                    this.isChecking = false;
                    this.confirmButton.field_22763 = true;
                });
            }
        }, "Tunnely-SetUsername").start();
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        String title = this.isFirstTime ? "\u00a76\u00a7lChoose Your Username" : "\u00a76\u00a7lChange Username";
        UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)title, (int)(this.field_22789 / 2), (int)30, (int)0xFFFFFF);
        if (this.isFirstTime) {
            UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77Welcome! Please choose a username for Tunnely.", (int)(this.field_22789 / 2), (int)60, (int)0xAAAAAA);
            UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77This will be visible to your friends.", (int)(this.field_22789 / 2), (int)75, (int)0xAAAAAA);
        } else {
            UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a77Enter your new username below.", (int)(this.field_22789 / 2), (int)60, (int)0xAAAAAA);
        }
        int requirementsY = this.field_22790 / 2 + 30;
        UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a78Requirements:", (int)(this.field_22789 / 2), (int)requirementsY, (int)0x555555);
        UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)"\u00a783-16 characters, letters/numbers/underscores only", (int)(this.field_22789 / 2), (int)(requirementsY + 12), (int)0x555555);
        if (!this.statusMessage.isEmpty()) {
            UsernameSelectionScreen.method_25300((class_4587)poseStack, (class_327)this.field_22793, (String)this.statusMessage, (int)(this.field_22789 / 2), (int)(this.field_22790 - 40), (int)this.statusColor);
        }
    }

    public void method_25419() {
        if (!this.isFirstTime) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25422() {
        return !this.isFirstTime;
    }

    public boolean method_25421() {
        return false;
    }
}

