/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;

public class ModDetector {
    public static List<PortForwardingConfig> detectInstalledMods() {
        int plasmoPort;
        ArrayList<PortForwardingConfig> detectedMods = new ArrayList<PortForwardingConfig>();
        if (ModDetector.isModInstalled("de.maxhenkel.voicechat.Voicechat")) {
            detectedMods.add(new PortForwardingConfig(24454, PortForwardingConfig.Protocol.UDP, "Simple Voice Chat", "Voice communication mod by Max Henkel", true));
            System.out.println("[Tunnely] Detected: Simple Voice Chat (port 24454/UDP) - Auto-enabled");
        }
        if (ModDetector.isModInstalled("su.plo.voice.server.PlasmoVoiceServer") && (plasmoPort = ModDetector.getPlasmoVoicePort()) > 0) {
            detectedMods.add(new PortForwardingConfig(plasmoPort, PortForwardingConfig.Protocol.UDP, "Plasmo Voice", "Advanced voice chat mod with 3D audio"));
            System.out.println("[Tunnely] Detected: Plasmo Voice (port " + plasmoPort + "/UDP)");
        }
        if (detectedMods.isEmpty()) {
            System.out.println("[Tunnely] No additional mods requiring port forwarding detected");
        } else {
            System.out.println("[Tunnely] Detected " + detectedMods.size() + " mod(s) with port forwarding support");
        }
        return detectedMods;
    }

    private static boolean isModInstalled(String className) {
        try {
            Class.forName(className, false, ModDetector.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static int getPlasmoVoicePort() {
        Path configPath = Paths.get("config", "plasmovoice", "server.toml");
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(configPath);
                for (String line : lines) {
                    String portStr;
                    int port;
                    String[] parts;
                    if (!(line = line.trim()).startsWith("port") || !line.contains("=") || (parts = line.split("=")).length != 2 || (port = Integer.parseInt(portStr = parts[1].trim().replaceAll("[^0-9]", ""))) <= 0 || port > 65535) continue;
                    System.out.println("[Tunnely] Read Plasmo Voice port from config: " + port);
                    return port;
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Failed to read Plasmo Voice config: " + e.getMessage());
            }
        }
        try {
            Class<?> configClass = Class.forName("su.plo.voice.server.config.ServerConfig");
            return 24455;
        }
        catch (ClassNotFoundException e) {
            return -1;
        }
    }

    public static String getPortForwardingDescription() {
        return "Forward additional ports to support voice chat and other mods.\nDetected mods will appear below. Enable the ones you want to use.";
    }

    public static boolean isPortSafe(int port) {
        return port >= 1024 && port <= 65535;
    }

    public static boolean isServiceDetected(String serviceName) {
        List<PortForwardingConfig> detected = ModDetector.detectInstalledMods();
        return detected.stream().anyMatch(config -> config.getServiceName().toLowerCase().contains(serviceName.toLowerCase()));
    }

    public static Map<Integer, List<String>> detectConflicts(List<PortForwardingConfig> configs) {
        HashMap<Integer, List<String>> conflicts = new HashMap<Integer, List<String>>();
        HashMap<Integer, String> portToService = new HashMap<Integer, String>();
        for (PortForwardingConfig config : configs) {
            if (!config.isEnabled()) continue;
            int port = config.getPort();
            if (portToService.containsKey(port)) {
                if (!conflicts.containsKey(port)) {
                    conflicts.put(port, new ArrayList());
                    ((List)conflicts.get(port)).add((String)portToService.get(port));
                }
                ((List)conflicts.get(port)).add(config.getServiceName());
                continue;
            }
            portToService.put(port, config.getServiceName());
        }
        return conflicts;
    }

    public static boolean isPortAvailable(int port, PortForwardingConfig.Protocol protocol) {
        if (protocol == PortForwardingConfig.Protocol.TCP) {
            boolean bl;
            ServerSocket socket = new ServerSocket(port);
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            socket.close();
            return bl;
        }
        if (protocol == PortForwardingConfig.Protocol.UDP) {
            DatagramSocket socket = new DatagramSocket(port);
            try {
                boolean bl = true;
                socket.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public static List<String> validatePortForwards(List<PortForwardingConfig> configs) {
        ArrayList<String> errors = new ArrayList<String>();
        Map<Integer, List<String>> conflicts = ModDetector.detectConflicts(configs);
        for (Map.Entry<Integer, List<String>> entry : conflicts.entrySet()) {
            String services = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue());
            errors.add("Port " + String.valueOf(entry.getKey()) + " conflict: " + services);
        }
        for (PortForwardingConfig config : configs) {
            if (!config.isEnabled() || ModDetector.isPortAvailable(config.getPort(), config.getProtocol())) continue;
            errors.add(config.getServiceName() + " (port " + config.getPort() + "): Port already in use by another application");
        }
        return errors;
    }
}

