/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationBell;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationPanelData;

public class NotificationPanelScreen
extends class_437 {
    private final class_437 parent;
    private final NotificationBell notificationBell;
    private List<NotificationPanelData.NotificationItem> items;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private NotificationPanelData.NotificationItem hoveredItem = null;

    public NotificationPanelScreen(class_437 parent, NotificationBell notificationBell) {
        super((class_2561)class_2561.method_43470((String)"Notifications"));
        this.parent = parent;
        this.notificationBell = notificationBell;
        List<WorldNotification> notifications = notificationBell.getNotifications();
        this.items = NotificationPanelData.formatNotifications(notifications);
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int buttonY = this.field_22790 - 30;
        if (this.notificationBell.getUnreadCount() > 0) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Mark All Read"), button -> this.markAllRead()).method_46434(centerX - 105, buttonY, 100, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 5, buttonY, 100, 20).method_46431());
        this.updateMaxScroll();
    }

    private void markAllRead() {
        this.notificationBell.markAllAsRead();
        this.field_22787.method_1507((class_437)new NotificationPanelScreen(this.parent, this.notificationBell));
    }

    private void updateMaxScroll() {
        int contentHeight = this.items.size() * 70;
        int visibleHeight = this.field_22790 - 120;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        String title = NotificationPanelData.getPanelHeader(this.notificationBell.getUnreadCount());
        graphics.method_25300(this.field_22793, title, this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderNotifications(graphics, mouseX, mouseY);
        if (this.maxScrollOffset > 0) {
            graphics.method_25303(this.field_22793, "\u2195 Scroll for more", this.field_22789 / 2 - 40, this.field_22790 - 50, 0x888888);
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    private void renderNotifications(class_332 graphics, int mouseX, int mouseY) {
        int startY = 40;
        int endY = this.field_22790 - 60;
        int centerX = this.field_22789 / 2;
        int contentWidth = Math.min(500, this.field_22789 - 40);
        int contentX = centerX - contentWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        if (this.items.isEmpty()) {
            graphics.method_25300(this.field_22793, NotificationPanelData.getEmptyMessage(), centerX, startY + 30, 0x888888);
        } else {
            int y = startY - this.scrollOffset;
            this.hoveredItem = null;
            for (NotificationPanelData.NotificationItem item : this.items) {
                boolean hovered;
                boolean bl = hovered = mouseX >= contentX && mouseX <= contentX + contentWidth && mouseY >= y && mouseY <= y + 65;
                if (hovered) {
                    this.hoveredItem = item;
                }
                this.renderNotificationItem(graphics, item, contentX, y, contentWidth, hovered);
                y += 70;
            }
        }
        graphics.method_44380();
    }

    private void renderNotificationItem(class_332 graphics, NotificationPanelData.NotificationItem item, int x, int y, int width, boolean hovered) {
        Object message;
        int bgColor = item.backgroundColor;
        if (bgColor == 0) {
            bgColor = hovered ? 0x40404040 : 0x40202020;
        }
        graphics.method_25294(x, y, x + width, y + 65, bgColor);
        graphics.method_25294(x, y, x + width, y + 1, -12566464);
        graphics.method_25303(this.field_22793, item.icon, x + 5, y + 5, item.textColor);
        graphics.method_25303(this.field_22793, item.title, x + 25, y + 5, item.textColor);
        if (!item.isRead) {
            graphics.method_25294(x + width - 10, y + 5, x + width - 5, y + 10, -13408513);
        }
        if (this.field_22793.method_1727((String)(message = item.message)) > width - 30) {
            while (this.field_22793.method_1727((String)message + "...") > width - 30 && ((String)message).length() > 0) {
                message = ((String)message).substring(0, ((String)message).length() - 1);
            }
            message = (String)message + "...";
        }
        graphics.method_25303(this.field_22793, (String)message, x + 25, y + 20, 0xAAAAAA);
        graphics.method_25303(this.field_22793, "\u00a77" + item.time, x + 25, y + 35, 0x888888);
        if (item.isCritical) {
            graphics.method_25303(this.field_22793, "\u00a7c\u00a7l!", x + width - 20, y + 5, -52429);
        }
        if (hovered) {
            graphics.method_25303(this.field_22793, "\u00a77Click to mark as read", x + 5, y + 50, 0x666666);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredItem != null) {
            if (!this.hoveredItem.isRead) {
                this.notificationBell.markAsRead(this.hoveredItem.id);
            }
            return true;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    public boolean method_25421() {
        return true;
    }
}

