/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.worlds.DownloadState;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class PausedDownloadsScreen
extends class_437 {
    private final class_437 parent;
    private final WorldManager worldManager;
    private List<PausedDownloadEntry> pausedDownloads = new ArrayList<PausedDownloadEntry>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private static final int ENTRY_HEIGHT = 70;
    private PausedDownloadEntry hoveredEntry = null;
    private String hoveredButton = null;

    public PausedDownloadsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Paused Downloads"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04 Refresh"), button -> this.loadPausedDownloads()).method_46434(centerX - 155, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 55, this.field_22790 - 30, 100, 20).method_46431());
        this.loadPausedDownloads();
    }

    private void loadPausedDownloads() {
        this.pausedDownloads.clear();
        List<Path> stateFiles = this.worldManager.listPausedDownloads();
        for (Path stateFile : stateFiles) {
            try {
                DownloadState state = this.worldManager.getPausedDownloadInfo(stateFile);
                if (state == null) continue;
                this.pausedDownloads.add(new PausedDownloadEntry(state, stateFile));
            }
            catch (Exception e) {
                System.err.println("Failed to load paused download: " + e.getMessage());
            }
        }
        this.updateMaxScroll();
    }

    private void resumeDownload(PausedDownloadEntry entry) {
        this.field_22787.method_1507((class_437)new DownloadProgressScreen(this.parent, this.worldManager, entry.stateFile));
    }

    private void deleteDownload(PausedDownloadEntry entry) {
        try {
            Files.deleteIfExists(Path.of(entry.state.getTempFilePath(), new String[0]));
            Files.deleteIfExists(entry.stateFile);
            this.loadPausedDownloads();
        }
        catch (Exception e) {
            System.err.println("Failed to delete paused download: " + e.getMessage());
        }
    }

    private void updateMaxScroll() {
        int visibleHeight = this.field_22790 - 100;
        int contentHeight = this.pausedDownloads.size() * 70;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.field_22789 / 2;
        graphics.method_25300(this.field_22793, "\u23f8 Paused Downloads", centerX, 15, 0xFFFFFF);
        String countText = this.pausedDownloads.isEmpty() ? "No paused downloads" : this.pausedDownloads.size() + " paused download" + (this.pausedDownloads.size() > 1 ? "s" : "");
        graphics.method_25300(this.field_22793, "\u00a77" + countText, centerX, 30, 0xAAAAAA);
        if (!this.pausedDownloads.isEmpty()) {
            this.renderDownloadList(graphics, mouseX, mouseY);
        } else {
            graphics.method_25300(this.field_22793, "\u00a77No paused downloads found", centerX, this.field_22790 / 2, 0x888888);
            graphics.method_25300(this.field_22793, "\u00a77Downloads are automatically paused when you close them", centerX, this.field_22790 / 2 + 15, 0x666666);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderDownloadList(class_332 graphics, int mouseX, int mouseY) {
        int startY = 50;
        int endY = this.field_22790 - 40;
        int centerX = this.field_22789 / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.pausedDownloads.size(); ++i) {
            PausedDownloadEntry entry = this.pausedDownloads.get(i);
            int entryY = yOffset + i * 70;
            if (entryY + 70 < startY || entryY > endY) continue;
            this.renderDownloadEntry(graphics, entry, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.method_44380();
    }

    private void renderDownloadEntry(class_332 graphics, PausedDownloadEntry entry, int x, int y, int width, int mouseX, int mouseY) {
        DownloadState state = entry.state;
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 70 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.method_25294(x, y, x + width, y + 70 - 5, bgColor);
        graphics.method_25294(x, y, x + width, y + 1, -12566464);
        graphics.method_25294(x, y + 70 - 5, x + width, y + 70 - 4, -12566464);
        graphics.method_25303(this.field_22793, state.getWorldName(), x + 10, y + 8, 0xFFFFFF);
        String progressText = state.getProgressPercentage() + "% complete";
        graphics.method_25303(this.field_22793, "\u00a77" + progressText, x + 10, y + 22, 0xAAAAAA);
        int barWidth = width - 20;
        int barHeight = 10;
        int barX = x + 10;
        int barY = y + 35;
        graphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, Integer.MIN_VALUE);
        int fillWidth = barWidth * state.getProgressPercentage() / 100;
        graphics.method_25294(barX, barY, barX + fillWidth, barY + barHeight, -2130729728);
        graphics.method_25294(barX, barY, barX + barWidth, barY + 1, -12566464);
        graphics.method_25294(barX, barY + barHeight - 1, barX + barWidth, barY + barHeight, -12566464);
        String bytesInfo = state.getDownloadedBytesFormatted() + " / " + state.getTotalBytesFormatted();
        graphics.method_25303(this.field_22793, "\u00a77" + bytesInfo, x + 10, y + 48, 0x888888);
        String timeInfo = "Paused: " + this.formatTimeAgo(state.getLastUpdateAt());
        graphics.method_25303(this.field_22793, "\u00a78" + timeInfo, x + width - 10 - this.field_22793.method_1727(timeInfo), y + 48, 0x666666);
        int buttonY = y + 8;
        int buttonWidth = 60;
        int buttonHeight = 18;
        int buttonSpacing = 65;
        int buttonStartX = x + width - 130;
        boolean resumeHovered = this.isMouseOverButton(mouseX, mouseY, buttonStartX, buttonY, buttonWidth, buttonHeight);
        if (resumeHovered) {
            graphics.method_25294(buttonStartX, buttonY, buttonStartX + buttonWidth, buttonY + buttonHeight, -2147418368);
            this.hoveredEntry = entry;
            this.hoveredButton = "resume";
        } else {
            graphics.method_25294(buttonStartX, buttonY, buttonStartX + buttonWidth, buttonY + buttonHeight, -2147450880);
        }
        graphics.method_25300(this.field_22793, "\u25b6 Resume", buttonStartX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        boolean deleteHovered = this.isMouseOverButton(mouseX, mouseY, buttonStartX + buttonSpacing, buttonY, buttonWidth, buttonHeight);
        if (deleteHovered) {
            graphics.method_25294(buttonStartX + buttonSpacing, buttonY, buttonStartX + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2130771968);
            this.hoveredEntry = entry;
            this.hoveredButton = "delete";
        } else {
            graphics.method_25294(buttonStartX + buttonSpacing, buttonY, buttonStartX + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2139095040);
        }
        graphics.method_25300(this.field_22793, "\u2716 Delete", buttonStartX + buttonSpacing + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredEntry != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("resume")) {
                this.resumeDownload(this.hoveredEntry);
                return true;
            }
            if (this.hoveredButton.equals("delete")) {
                int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this paused download?", "Delete Paused Download", 0);
                if (choice == 0) {
                    this.deleteDownload(this.hoveredEntry);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.hoveredEntry = null;
        this.hoveredButton = null;
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private String formatTimeAgo(Instant instant) {
        long days;
        if (instant == null) {
            return "Unknown";
        }
        long secondsAgo = Duration.between(instant, Instant.now()).getSeconds();
        if (secondsAgo < 60L) {
            return "Just now";
        }
        if (secondsAgo < 3600L) {
            long minutes;
            return minutes + " minute" + ((minutes = secondsAgo / 60L) > 1L ? "s" : "") + " ago";
        }
        if (secondsAgo < 86400L) {
            long hours;
            return hours + " hour" + ((hours = secondsAgo / 3600L) > 1L ? "s" : "") + " ago";
        }
        return days + " day" + ((days = secondsAgo / 86400L) > 1L ? "s" : "") + " ago";
    }

    private static class PausedDownloadEntry {
        public final DownloadState state;
        public final Path stateFile;

        public PausedDownloadEntry(DownloadState state, Path stateFile) {
            this.state = state;
            this.stateFile = stateFile;
        }
    }
}

