/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.EncryptionKeyManager;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.HostGameScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.NotificationPanelScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UnifiedFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.UsernameSelectionScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldBrowserScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationBell;

public class TunnelyMainScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelConfig config;
    private final TunnelManager manager;
    private final List<class_4185> menuButtons = new ArrayList<class_4185>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private int tickCounter = 0;
    private class_4185 hostButton;
    private class_4185 donateButton;
    private class_4185 backButton;
    private NotificationBell notificationBell;
    private boolean bellHovered = false;

    public TunnelyMainScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tunnely"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.manager = TunnelManager.getInstance();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
        this.manager.setDisconnectListener(() -> this.field_22787.execute(() -> this.updateHostButtonText()));
        if (this.config.isAuthenticated()) {
            try {
                WorldManager worldManager = new WorldManager();
                this.notificationBell = new NotificationBell(worldManager.getNotificationManager());
                this.notificationBell.forceUpdate();
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Failed to initialize notification bell: " + e.getMessage());
            }
        }
        if (this.config.isAuthenticated()) {
            new Thread(() -> {
                try {
                    SupabaseClient client = new SupabaseClient();
                    if (client.needsLogin()) {
                        this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new LoginScreen(this.parent)));
                        return;
                    }
                    JsonObject profile = client.getOwnProfile();
                    if (profile == null || !profile.has("minecraft_name")) {
                        System.out.println("[Tunnely] User missing profile or username, redirecting to username selection");
                        this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new UsernameSelectionScreen(this.parent, true)));
                        return;
                    }
                    PresenceManager.getInstance().start();
                    MessageManager.getInstance().start();
                    EncryptionKeyManager.initializeKeys();
                }
                catch (Exception e) {
                    System.err.println("[Tunnely] Background initialization error: " + e.getMessage());
                }
            }, "Tunnely-Init").start();
        }
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.field_22789 * 0.3)));
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Login / Register"), b -> this.field_22787.method_1507((class_437)new LoginScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
        } else {
            boolean inSingleplayer = this.field_22787.method_1576() != null;
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonText), b -> {
                if (this.field_22787.method_1576() != null) {
                    this.field_22787.method_1507((class_437)new HostGameScreen(this));
                } else {
                    this.setFooterMessage("\u00a7cPlease create or load a world first before hosting!", 0xFF5555);
                }
            }).method_46434(centerX, 0, this.buttonWidth, 20).method_46431();
            this.hostButton.field_22763 = inSingleplayer;
            this.menuButtons.add(this.hostButton);
            if (!inSingleplayer) {
                this.setFooterMessage("\u00a77Tip: Create or load a world to enable hosting", 0xAAAAAA);
            }
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Friends & Servers"), b -> this.field_22787.method_1507((class_437)new UnifiedFriendsScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Direct Join"), b -> this.field_22787.method_1507((class_437)new DirectJoinScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invites"), b -> this.field_22787.method_1507((class_437)new InvitesScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Public Lobbies"), b -> this.field_22787.method_1507((class_437)new PublicLobbiesScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83c\udf0d Browse Worlds"), b -> this.field_22787.method_1507((class_437)new WorldBrowserScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
            this.menuButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Settings"), b -> this.field_22787.method_1507((class_437)new SettingsScreen(this))).method_46434(centerX, 0, this.buttonWidth, 20).method_46431());
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.field_22790 - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (class_4185 b2 : this.menuButtons) {
            this.method_37063((class_364)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        for (class_4185 b : this.menuButtons) {
            b.method_46421(centerX);
            b.method_46419(y);
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.field_22789 / 2 - this.buttonWidth / 2;
        this.donateButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Donate"), btn -> this.openDonate()).method_46434(centerX, this.field_22790 - 55, this.buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.donateButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), btn -> this.field_22787.method_1507(this.parent)).method_46434(centerX, this.field_22790 - 30, this.buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    private void openDonate() {
        try {
            class_156.method_668().method_670("https://ko-fi.com/bobcatmods");
            this.footerMessage = "";
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.footerMessage = "\u00a7cFailed to open browser";
            this.footerColor = 0xFF5555;
        }
    }

    public void method_25393() {
        super.method_25393();
        ++this.tickCounter;
        if (this.tickCounter >= 40) {
            this.tickCounter = 0;
            this.updateHostButtonText();
        }
        if (this.notificationBell != null) {
            this.notificationBell.update();
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float delta) {
        this.method_25420(g, mouseX, mouseY, delta);
        g.method_25300(this.field_22793, "\u00a76\u00a7lTunnely", this.field_22789 / 2, 15, 0xFFFFFF);
        g.method_25300(this.field_22793, "\u00a77NAT Traversal", this.field_22789 / 2, 28, 0xAAAAAA);
        if (this.notificationBell != null) {
            this.renderNotificationBell(g, mouseX, mouseY);
        }
        int clipTop = this.safeTop;
        int clipBottom = this.field_22790 - 70;
        g.method_44379(0, clipTop, this.field_22789, clipBottom);
        for (class_4185 btn : this.menuButtons) {
            btn.method_25394(g, mouseX, mouseY, delta);
        }
        g.method_44380();
        if (this.donateButton != null) {
            this.donateButton.method_25394(g, mouseX, mouseY, delta);
        }
        if (this.backButton != null) {
            this.backButton.method_25394(g, mouseX, mouseY, delta);
        }
        if (!this.footerMessage.isEmpty()) {
            g.method_25300(this.field_22793, this.footerMessage, this.field_22789 / 2, this.field_22790 - 70, this.footerColor);
        }
        if (this.scrollable) {
            int areaTop = this.safeTop;
            int areaH = Math.max(10, this.field_22790 - this.safeTop - 70);
            int barX = this.field_22789 - 10;
            int total = Math.max(1, this.stackTotalH);
            int thumbH = Math.max(20, areaH * areaH / total);
            int maxScroll = Math.max(1, this.stackTotalH - areaH);
            int thumbY = areaTop + (int)(this.scroll * (double)(areaH - thumbH) / (double)maxScroll);
            g.method_25294(barX, areaTop, barX + 6, areaTop + areaH, 0x40FFFFFF);
            g.method_25294(barX, thumbY, barX + 6, thumbY + thumbH, -2130706433);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double delta) {
        if (!this.scrollable) {
            return super.method_25401(mouseX, mouseY, horizontalAmount, delta);
        }
        int areaH = Math.max(10, this.field_22790 - this.safeTop - 70);
        int maxScroll = Math.max(0, this.stackTotalH - areaH);
        this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - delta * 22.0));
        this.layoutButtons();
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.bellHovered && this.notificationBell != null) {
            this.field_22787.method_1507((class_437)new NotificationPanelScreen(this, this.notificationBell));
            return true;
        }
        if (this.donateButton != null && this.donateButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.backButton != null && this.backButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int clipTop = this.safeTop;
        int clipBottom = this.field_22790 - 70;
        if (mouseY >= (double)clipTop && mouseY <= (double)clipBottom) {
            for (class_4185 btn : this.menuButtons) {
                if (!btn.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25410(class_310 mc, int w, int h) {
        super.method_25410(mc, w, h);
        this.method_37067();
        this.method_25426();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }

    private void updateHostButtonText() {
        if (this.hostButton != null) {
            boolean isHosting = this.manager.isHosting();
            String buttonText = isHosting ? "Manage" : "Host Game";
            this.hostButton.method_25355((class_2561)class_2561.method_43470((String)buttonText));
            System.out.println("[Tunnely] Host button updated: " + buttonText);
        }
    }

    private void renderNotificationBell(class_332 g, int mouseX, int mouseY) {
        int bellX = this.field_22789 - 30;
        int bellY = 15;
        int bellSize = 16;
        this.bellHovered = mouseX >= bellX && mouseX <= bellX + bellSize && mouseY >= bellY && mouseY <= bellY + bellSize;
        int bellColor = this.bellHovered ? 0xFFFFFF : 0xCCCCCC;
        g.method_25303(this.field_22793, "\ud83d\udd14", bellX, bellY, bellColor);
        if (this.notificationBell.shouldShowBadge()) {
            String badgeText = this.notificationBell.getBadgeText();
            int badgeColor = this.notificationBell.hasCriticalNotifications() ? -52429 : -13408513;
            int badgeX = bellX + 12;
            int badgeY = bellY - 2;
            int badgeRadius = 8;
            g.method_25294(badgeX - badgeRadius, badgeY, badgeX + badgeRadius, badgeY + badgeRadius * 2, badgeColor);
            int textWidth = this.field_22793.method_1727(badgeText);
            g.method_25303(this.field_22793, badgeText, badgeX - textWidth / 2, badgeY + 2, 0xFFFFFF);
        }
        if (this.bellHovered) {
            int unreadCount = this.notificationBell.getUnreadCount();
            String tooltip = unreadCount > 0 ? "\u00a7e" + unreadCount + " unread notification" + (unreadCount > 1 ? "s" : "") : "\u00a77No new notifications";
            g.method_25303(this.field_22793, tooltip, bellX - 60, bellY + 20, 0xFFFFFF);
        }
    }
}

