/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.WorldEditScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class WorldUpdateScreen
extends class_437 {
    private final class_437 parent;
    private final WorldInfo existingWorld;
    private final WorldManager worldManager;
    private List<String> localWorlds = new ArrayList<String>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 40;
    private int maxScrollOffset = 0;
    private String selectedWorld = null;
    private String statusMessage = "";
    private boolean updating = false;
    private int uploadProgress = 0;

    public WorldUpdateScreen(class_437 parent, WorldInfo existingWorld) {
        super((class_2561)class_2561.method_43470((String)"Update World"));
        this.parent = parent;
        this.existingWorld = existingWorld;
        this.worldManager = new WorldManager();
    }

    public class_437 getParent() {
        return this.parent;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Update World"), button -> this.updateWorld()).method_46434(centerX - 105, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 10, this.field_22790 - 30, 100, 20).method_46431());
        this.loadLocalWorlds();
    }

    private void loadLocalWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0]) && Files.isDirectory(savesDir, new LinkOption[0])) {
                this.localWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).sorted().collect(Collectors.toList());
                this.updateMaxScroll();
            }
        }
        catch (IOException e) {
            this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
        }
    }

    private void updateWorld() {
        if (this.selectedWorld == null) {
            this.statusMessage = "\u00a7cPlease select a world first";
            return;
        }
        this.field_22787.method_1507((class_437)new WorldEditScreen(this, this.existingWorld, this.selectedWorld));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.field_22790 - 180;
        int contentHeight = this.localWorlds.size() * 40;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25300(this.field_22793, "Update: " + this.existingWorld.getName(), this.field_22789 / 2, 15, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Select a local world to replace the uploaded version", this.field_22789 / 2, 35, 0xAAAAAA);
        graphics.method_25300(this.field_22793, "\u00a77This will keep ratings, comments, and download count", this.field_22789 / 2, 48, 0xAAAAAA);
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, 65, 0xFFFFFF);
        }
        if (this.updating && this.uploadProgress > 0) {
            int barWidth = 300;
            int barX = this.field_22789 / 2 - barWidth / 2;
            int barY = 80;
            graphics.method_25294(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.method_25294(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2147439873);
            graphics.method_25294(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.method_25294(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        if (!this.updating) {
            this.renderWorldList(graphics, mouseX, mouseY);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderWorldList(class_332 graphics, int mouseX, int mouseY) {
        int startY = 100;
        int endY = this.field_22790 - 50;
        int centerX = this.field_22789 / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.localWorlds.size(); ++i) {
            String worldName = this.localWorlds.get(i);
            int entryY = yOffset + i * 40;
            if (entryY + 40 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, worldName, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.method_44380();
    }

    private void renderWorldEntry(class_332 graphics, String worldName, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered;
        boolean isSelected = worldName.equals(this.selectedWorld);
        boolean bl = hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 40 - 5;
        int bgColor = isSelected ? -2147461752 : (hovered ? -2143272896 : -2145378272);
        graphics.method_25294(x, y, x + width, y + 40 - 5, bgColor);
        graphics.method_25294(x, y, x + width, y + 1, -12566464);
        graphics.method_25294(x, y + 40 - 5, x + width, y + 40 - 4, -12566464);
        Object displayName = isSelected ? "\u00a7b\u2713 " + worldName : worldName;
        graphics.method_25303(this.field_22793, (String)displayName, x + 5, y + 10, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77saves/" + worldName, x + 5, y + 22, 0x888888);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.updating) {
            int startY = 100;
            int endY = this.field_22790 - 50;
            int centerX = this.field_22789 / 2;
            int entryWidth = 400;
            int entryX = centerX - entryWidth / 2;
            if (mouseX >= (double)entryX && mouseX <= (double)(entryX + entryWidth) && mouseY >= (double)startY && mouseY <= (double)endY) {
                int yOffset = startY - this.scrollOffset;
                for (int i = 0; i < this.localWorlds.size(); ++i) {
                    int entryY = yOffset + i * 40;
                    if (!(mouseY >= (double)entryY) || !(mouseY <= (double)(entryY + 40 - 5))) continue;
                    this.selectedWorld = this.localWorlds.get(i);
                    this.statusMessage = "\u00a7aSelected: " + this.selectedWorld;
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double delta) {
        if (!this.updating) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(delta * 20.0)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

