/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldBrowserScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldUploadScreen
extends class_437 {
    private final class_437 parent;
    private final WorldManager worldManager;
    private class_342 nameBox;
    private class_342 descBox1;
    private class_342 descBox2;
    private class_342 descBox3;
    private class_342 versionBox;
    private class_342 tagBox;
    private List<String> availableWorlds = new ArrayList<String>();
    private int selectedWorldIndex = 0;
    private String worldType = "survival";
    private boolean isPublic = true;
    private boolean pruneChunks = true;
    private List<String> tags = new ArrayList<String>();
    private WorldScannerUtil.ScanResult scanResult = null;
    private boolean scanning = false;
    private boolean uploading = false;
    private String statusMessage = "";
    private int statusColor = 0xAAAAAA;
    private int uploadProgress = 0;

    public WorldUploadScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Upload World"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to upload worlds";
            this.statusColor = 0xFF5555;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Go to Login"), button -> this.field_22787.method_1507((class_437)new LoginScreen(this.parent))).method_46434(this.field_22789 / 2 - 75, this.field_22790 / 2, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 30, 100, 20).method_46431());
            return;
        }
        int centerX = this.field_22789 / 2;
        int leftX = centerX - 150;
        this.loadAvailableWorlds();
        String worldLabel = this.availableWorlds.isEmpty() ? "No worlds found" : (this.selectedWorldIndex < this.availableWorlds.size() ? this.availableWorlds.get(this.selectedWorldIndex) : "Select world");
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)worldLabel), button -> this.cycleWorld()).method_46434(leftX, 35, 300, 20).method_46431());
        this.nameBox = new class_342(this.field_22793, leftX, 75, 300, 20, (class_2561)class_2561.method_43470((String)"Name"));
        this.nameBox.method_1880(100);
        this.nameBox.method_47404((class_2561)class_2561.method_43470((String)"World display name"));
        this.method_37063((class_364)this.nameBox);
        this.descBox1 = new class_342(this.field_22793, leftX, 115, 300, 20, (class_2561)class_2561.method_43470((String)"Description 1"));
        this.descBox1.method_1880(166);
        this.descBox1.method_47404((class_2561)class_2561.method_43470((String)"Description line 1"));
        this.method_37063((class_364)this.descBox1);
        this.descBox2 = new class_342(this.field_22793, leftX, 140, 300, 20, (class_2561)class_2561.method_43470((String)"Description 2"));
        this.descBox2.method_1880(166);
        this.descBox2.method_47404((class_2561)class_2561.method_43470((String)"Description line 2"));
        this.method_37063((class_364)this.descBox2);
        this.descBox3 = new class_342(this.field_22793, leftX, 165, 300, 20, (class_2561)class_2561.method_43470((String)"Description 3"));
        this.descBox3.method_1880(166);
        this.descBox3.method_47404((class_2561)class_2561.method_43470((String)"Description line 3"));
        this.method_37063((class_364)this.descBox3);
        this.versionBox = new class_342(this.field_22793, leftX, 205, 145, 20, (class_2561)class_2561.method_43470((String)"Version"));
        this.versionBox.method_1880(20);
        this.versionBox.method_1852("1.20.1");
        this.method_37063((class_364)this.versionBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.worldType), button -> this.cycleWorldType()).method_46434(leftX + 155, 205, 145, 20).method_46431());
        this.tagBox = new class_342(this.field_22793, leftX, 245, 250, 20, (class_2561)class_2561.method_43470((String)"Tag"));
        this.tagBox.method_1880(30);
        this.tagBox.method_47404((class_2561)class_2561.method_43470((String)"Add tag..."));
        this.method_37063((class_364)this.tagBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> this.addTag()).method_46434(leftX + 255, 245, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isPublic ? "Public" : "Private")), button -> this.toggleVisibility()).method_46434(leftX, 285, 95, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.pruneChunks ? "Prune: ON" : "Prune: OFF")), button -> this.togglePruneChunks()).method_46434(leftX + 100, 285, 95, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Scan World"), button -> this.scanWorld()).method_46434(leftX + 200, 285, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Upload"), button -> this.uploadWorld()).method_46434(centerX - 50, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 55, this.field_22790 - 30, 100, 20).method_46431());
        if (!this.availableWorlds.isEmpty()) {
            this.nameBox.method_1852(this.availableWorlds.get(0));
            this.scanWorld();
        }
    }

    private void loadAvailableWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0])) {
                this.availableWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load worlds: " + e.getMessage());
        }
    }

    private void cycleWorld() {
        if (this.availableWorlds.isEmpty()) {
            return;
        }
        this.selectedWorldIndex = (this.selectedWorldIndex + 1) % this.availableWorlds.size();
        String worldName = this.availableWorlds.get(this.selectedWorldIndex);
        this.nameBox.method_1852(worldName);
        this.scanWorld();
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void cycleWorldType() {
        String[] types = new String[]{"survival", "creative", "adventure", "spectator"};
        int currentIndex = Arrays.asList(types).indexOf(this.worldType);
        this.worldType = types[(currentIndex + 1) % types.length];
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void toggleVisibility() {
        this.isPublic = !this.isPublic;
    }

    private void togglePruneChunks() {
        this.pruneChunks = !this.pruneChunks;
    }

    private void addTag() {
        String tag = this.tagBox.method_1882().trim().toLowerCase();
        if (!tag.isEmpty() && !this.tags.contains(tag) && this.tags.size() < 5) {
            this.tags.add(tag);
            this.tagBox.method_1852("");
        }
    }

    private void removeTag(String tag) {
        this.tags.remove(tag);
    }

    private void scanWorld() {
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanning) {
            return;
        }
        this.scanning = true;
        this.statusMessage = "Scanning world for security issues...";
        this.statusColor = 0xFFFF55;
        String worldFolder = this.availableWorlds.get(this.selectedWorldIndex);
        new Thread(() -> {
            try {
                Path worldPath = Paths.get("saves", new String[0]).resolve(worldFolder);
                WorldScannerUtil.ScanResult result = WorldScannerUtil.scanWorld(worldPath);
                this.field_22787.execute(() -> {
                    this.scanResult = result;
                    this.scanning = false;
                    if (result.isSafe()) {
                        this.statusMessage = "\u00a7a\u2713 Scan complete: Safe (" + result.getFileCount() + " files, " + result.getFormattedSize() + ")";
                        this.statusColor = 0x55FF55;
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Security issues found: " + result.getBlockedFiles().size() + " blocked files";
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.scanning = false;
                    this.statusMessage = "\u00a7cScan failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    private void uploadWorld() {
        if (this.uploading) {
            return;
        }
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanResult == null) {
            this.statusMessage = "\u00a7cPlease scan the world first";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!this.scanResult.isSafe()) {
            this.statusMessage = "\u00a7cWorld has security issues, cannot upload";
            this.statusColor = 0xFF5555;
            return;
        }
        String worldName = this.nameBox.method_1882().trim();
        if (worldName.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a world name";
            this.statusColor = 0xFF5555;
            return;
        }
        this.uploading = true;
        this.statusMessage = "Preparing upload...";
        this.uploadProgress = 0;
        WorldUploadRequest request = new WorldUploadRequest();
        request.setWorldName(worldName);
        request.setWorldFolderName(this.availableWorlds.get(this.selectedWorldIndex));
        request.setDescription(this.descBox1.method_1882() + "\n" + this.descBox2.method_1882() + "\n" + this.descBox3.method_1882());
        request.setMinecraftVersion(this.versionBox.method_1882());
        request.setWorldType(this.worldType);
        request.setTags(new ArrayList<String>(this.tags));
        request.setPublic(this.isPublic);
        request.setPruneUninhabitedChunks(this.pruneChunks);
        request.setProgressCallback((percentage, currentFile) -> this.field_22787.execute(() -> {
            this.uploadProgress = percentage;
            this.statusMessage = "Uploading... " + percentage + "%";
        }));
        new Thread(() -> {
            try {
                WorldManager.UploadResult result = this.worldManager.uploadWorld(request);
                this.field_22787.execute(() -> {
                    this.uploading = false;
                    if (result.isSuccess()) {
                        this.statusMessage = "\u00a7a\u2713 " + result.getMessage();
                        this.statusColor = 0x55FF55;
                        new Thread(() -> {
                            try {
                                Thread.sleep(2000L);
                                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new WorldBrowserScreen(this.parent)));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 " + result.getMessage();
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.uploading = false;
                    this.statusMessage = "\u00a7cUpload failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25300(this.field_22793, "\ud83d\udce4 Upload World", this.field_22789 / 2, 15, 0xFFFFFF);
        int centerX = this.field_22789 / 2;
        int leftX = centerX - 150;
        graphics.method_25303(this.field_22793, "Select World:", leftX, 25, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Display Name:", leftX, 65, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Description:", leftX, 105, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "MC Version:", leftX, 195, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Tags:", leftX, 235, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Visibility:", leftX, 275, 0xFFFFFF);
        int tagY = 270;
        int tagX = leftX;
        for (String tag : this.tags) {
            graphics.method_25294(tagX, tagY, tagX + 60, tagY + 15, -2143272896);
            graphics.method_25303(this.field_22793, tag, tagX + 3, tagY + 3, 0xFFFFFF);
            if (mouseX >= tagX + 52 && mouseX <= tagX + 58 && mouseY >= tagY + 2 && mouseY <= tagY + 13) {
                graphics.method_25294(tagX + 52, tagY + 2, tagX + 58, tagY + 13, -2130771968);
                if (this.field_22787.field_1729.method_1608()) {
                    this.removeTag(tag);
                }
            }
            graphics.method_25303(this.field_22793, "x", tagX + 53, tagY + 3, 0xFFFFFF);
            tagX += 65;
        }
        if (this.scanResult != null) {
            int boxY = 315;
            graphics.method_25294(leftX, boxY, leftX + 300, boxY + 45, -2145378272);
            graphics.method_25294(leftX, boxY, leftX + 300, boxY + 1, -12566464);
            if (this.scanResult.isSafe()) {
                graphics.method_25303(this.field_22793, "\u00a7aSize: " + this.scanResult.getFormattedSize() + " (uncompressed)", leftX + 5, boxY + 5, 0x55FF55);
                graphics.method_25303(this.field_22793, "\u00a7aFiles: " + this.scanResult.getFileCount(), leftX + 5, boxY + 18, 0x55FF55);
                graphics.method_25303(this.field_22793, "\u00a7aStatus: \u2713 Safe to upload", leftX + 5, boxY + 31, 0x55FF55);
            } else {
                graphics.method_25303(this.field_22793, "\u00a7cBlocked files: " + this.scanResult.getBlockedFiles().size(), leftX + 5, boxY + 5, 0xFF5555);
                graphics.method_25303(this.field_22793, "\u00a7cCannot upload - security issues", leftX + 5, boxY + 18, 0xFF5555);
                if (!this.scanResult.getBlockedFiles().isEmpty()) {
                    Object firstBlocked = this.scanResult.getBlockedFiles().get(0);
                    if (((String)firstBlocked).length() > 40) {
                        firstBlocked = ((String)firstBlocked).substring(0, 37) + "...";
                    }
                    graphics.method_25303(this.field_22793, "\u00a7c" + (String)firstBlocked, leftX + 5, boxY + 31, 0xFF5555);
                }
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 45, this.statusColor);
        }
        if (this.uploading && this.uploadProgress > 0) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = this.field_22790 - 60;
            graphics.method_25294(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.method_25294(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2141847723);
            graphics.method_25294(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.method_25294(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    public boolean method_25421() {
        return true;
    }
}

