/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import org.texboobcat.tunnelyrefab.shaded.com.google.gson.Gson;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;

public class ScanStatistics {
    private int totalWorlds;
    private int pendingScans;
    private int scanning;
    private int clean;
    private int infected;
    private int failed;
    private int quarantined;
    private String lastUpdated;

    public static ScanStatistics parse(String statsJson) {
        if (statsJson == null || statsJson.isEmpty()) {
            return null;
        }
        try {
            Gson gson = new Gson();
            JsonObject json = gson.fromJson(statsJson, JsonObject.class);
            ScanStatistics stats = new ScanStatistics();
            stats.totalWorlds = ScanStatistics.getInt(json, "total_worlds");
            stats.pendingScans = ScanStatistics.getInt(json, "pending_scans");
            stats.scanning = ScanStatistics.getInt(json, "scanning");
            stats.clean = ScanStatistics.getInt(json, "clean");
            stats.infected = ScanStatistics.getInt(json, "infected");
            stats.failed = ScanStatistics.getInt(json, "failed");
            stats.quarantined = ScanStatistics.getInt(json, "quarantined");
            stats.lastUpdated = ScanStatistics.getString(json, "last_updated");
            return stats;
        }
        catch (Exception e) {
            System.err.println("[ScanStatistics] Failed to parse: " + e.getMessage());
            return null;
        }
    }

    public String getFormatted() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== Scan Statistics ===\n\n");
        sb.append("Total Worlds: ").append(this.totalWorlds).append("\n");
        sb.append("\nScan Status:\n");
        sb.append("  \u2713 Clean: ").append(this.clean).append(" (").append(this.getPercentage(this.clean)).append("%)\n");
        sb.append("  \u23f1 Pending: ").append(this.pendingScans).append(" (").append(this.getPercentage(this.pendingScans)).append("%)\n");
        sb.append("  \u23f3 Scanning: ").append(this.scanning).append(" (").append(this.getPercentage(this.scanning)).append("%)\n");
        sb.append("  \u26a0 Infected: ").append(this.infected).append(" (").append(this.getPercentage(this.infected)).append("%)\n");
        sb.append("  \u274c Failed: ").append(this.failed).append(" (").append(this.getPercentage(this.failed)).append("%)\n");
        sb.append("\nQuarantined: ").append(this.quarantined).append("\n");
        if (this.lastUpdated != null) {
            sb.append("\nLast Updated: ").append(this.lastUpdated);
        }
        return sb.toString();
    }

    public StatItem[] getItems() {
        return new StatItem[]{new StatItem("Total Worlds", String.valueOf(this.totalWorlds), -1), new StatItem("Clean", String.valueOf(this.clean) + " (" + this.getPercentage(this.clean) + "%)", -13369549), new StatItem("Pending", String.valueOf(this.pendingScans) + " (" + this.getPercentage(this.pendingScans) + "%)", -13261), new StatItem("Scanning", String.valueOf(this.scanning) + " (" + this.getPercentage(this.scanning) + "%)", -13261), new StatItem("Infected", String.valueOf(this.infected) + " (" + this.getPercentage(this.infected) + "%)", -52429), new StatItem("Failed", String.valueOf(this.failed) + " (" + this.getPercentage(this.failed) + "%)", -26317), new StatItem("Quarantined", String.valueOf(this.quarantined), -52429)};
    }

    private String getPercentage(int count) {
        if (this.totalWorlds == 0) {
            return "0";
        }
        double pct = (double)count * 100.0 / (double)this.totalWorlds;
        return String.format("%.1f", pct);
    }

    private static int getInt(JsonObject json, String key) {
        try {
            return json.has(key) ? json.get(key).getAsInt() : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static String getString(JsonObject json, String key) {
        try {
            return json.has(key) ? json.get(key).getAsString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getTotalWorlds() {
        return this.totalWorlds;
    }

    public int getPendingScans() {
        return this.pendingScans;
    }

    public int getScanning() {
        return this.scanning;
    }

    public int getClean() {
        return this.clean;
    }

    public int getInfected() {
        return this.infected;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getQuarantined() {
        return this.quarantined;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public double getCompletionRate() {
        if (this.totalWorlds == 0) {
            return 100.0;
        }
        int incomplete = this.pendingScans + this.scanning;
        return (double)(this.totalWorlds - incomplete) * 100.0 / (double)this.totalWorlds;
    }

    public double getSafetyRate() {
        if (this.totalWorlds == 0) {
            return 100.0;
        }
        return (double)this.clean * 100.0 / (double)this.totalWorlds;
    }

    public double getThreatRate() {
        if (this.totalWorlds == 0) {
            return 0.0;
        }
        return (double)this.infected * 100.0 / (double)this.totalWorlds;
    }

    public static class StatItem {
        public final String label;
        public final String value;
        public final int color;

        public StatItem(String label, String value, int color) {
            this.label = label;
            this.value = value;
            this.color = color;
        }
    }
}

