/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.config;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.tunnelyrefab.security.RelayValidator;
import org.texboobcat.tunnelyrefab.security.TokenEncryptor;
import org.texboobcat.tunnelyrefab.security.TrustedRelay;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.Gson;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.GsonBuilder;

public class TunnelConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/tunnelyrefab.json";
    private String relayServerUrl = "wss://na-1.tunnely.org:8080";
    private String supabaseUrl = "https://lssfzgimcomfmbqlziri.supabase.co";
    private String supabaseAnonKey = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Imxzc2Z6Z2ltY29tZm1icWx6aXJpIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NTkxNzM5MTgsImV4cCI6MjA3NDc0OTkxOH0.LCuUNNVuIPHEMcL9_nmCBy_7okg5jsO5_d91aBriLFQ";
    private String userJwtToken = "";
    private String userRefreshToken = "";
    private String supabaseUserId = "";
    private String minecraftUuid = "";
    private boolean enableTunneling = true;
    private boolean debugMode = false;
    private int connectionTimeout = 30000;
    private List<RelayEndpoint> relays = new ArrayList<RelayEndpoint>();
    private String acceptedTosVersion = "";
    private long tosAcceptedTimestamp = 0L;
    private String encryptedPrivateKey = "";
    private String publicKey = "";
    private boolean messageNotificationsEnabled = true;
    private boolean autoStartTunnel = false;
    private String savedVisibility = "invite_only";
    private String savedServerName = "Minecraft Server";
    private int maxPlayers = 8;
    private boolean offlineMode = false;
    private String defaultGamemode = "survival";
    private long downloadBandwidthLimit = 0L;
    private transient String decryptedJwtToken = null;
    private transient String decryptedRefreshToken = null;
    private static TunnelConfig instance;

    private TunnelConfig() {
    }

    public static TunnelConfig getInstance() {
        if (instance == null) {
            instance = TunnelConfig.load();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TunnelConfig load() {
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (Files.exists(configPath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(configPath.toFile());){
                TunnelConfig config = GSON.fromJson((Reader)reader, TunnelConfig.class);
                if (config != null) {
                    config.decryptTokenOnLoad();
                    if (config.relays == null) {
                        config.relays = new ArrayList<RelayEndpoint>();
                    }
                    if (config.relays.isEmpty() || TunnelConfig.isUsingOldDefaults(config.relays)) {
                        config.relays = TunnelConfig.getOfficialRelays();
                        if (!config.relays.isEmpty()) {
                            config.relayServerUrl = config.relays.get((int)0).url;
                        }
                        config.save();
                        System.out.println("[Tunnely] Migrated to official Tunnely relays");
                    }
                    TunnelConfig tunnelConfig = config;
                    return tunnelConfig;
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Failed to load config: " + e.getMessage());
            }
        }
        TunnelConfig config = new TunnelConfig();
        config.relays = TunnelConfig.getOfficialRelays();
        config.save();
        return config;
    }

    private static boolean isUsingOldDefaults(List<RelayEndpoint> relays) {
        if (relays.size() == 1) {
            RelayEndpoint relay = relays.get(0);
            return relay.url.contains("129.212.186.16") || relay.url.contains("localhost") || relay.url.contains("127.0.0.1") || relay.id.equals("default");
        }
        return false;
    }

    private static List<RelayEndpoint> getOfficialRelays() {
        ArrayList<RelayEndpoint> officialRelays = new ArrayList<RelayEndpoint>();
        List<TrustedRelay> trustedRelays = RelayValidator.getOfficialRelays();
        for (TrustedRelay trustedRelay : trustedRelays) {
            officialRelays.add(new RelayEndpoint(trustedRelay.getId(), trustedRelay.getRegion(), trustedRelay.getUrl()));
        }
        return officialRelays;
    }

    private void decryptTokenOnLoad() {
        String encrypted;
        String decrypted;
        TokenEncryptor encryptor = TokenEncryptor.getInstance();
        if (this.userJwtToken == null || this.userJwtToken.isEmpty()) {
            this.decryptedJwtToken = "";
        } else if (encryptor.isEncrypted(this.userJwtToken)) {
            decrypted = encryptor.decrypt(this.userJwtToken);
            if (decrypted != null) {
                this.decryptedJwtToken = decrypted;
                System.out.println("[Tunnely] JWT token successfully decrypted");
            } else {
                System.err.println("[Tunnely] Failed to decrypt JWT token - it may be from another machine");
                System.err.println("[Tunnely] You will need to log in again");
                this.decryptedJwtToken = "";
                this.userJwtToken = "";
                this.save();
            }
        } else {
            System.out.println("[Tunnely] Migrating plaintext JWT token to encrypted storage");
            this.decryptedJwtToken = this.userJwtToken;
            encrypted = encryptor.encrypt(this.userJwtToken);
            if (encrypted != null) {
                this.userJwtToken = encrypted;
                this.save();
                System.out.println("[Tunnely] JWT token encrypted and saved");
            } else {
                System.err.println("[Tunnely] Failed to encrypt JWT token");
            }
        }
        if (this.userRefreshToken == null || this.userRefreshToken.isEmpty()) {
            this.decryptedRefreshToken = "";
        } else if (encryptor.isEncrypted(this.userRefreshToken)) {
            decrypted = encryptor.decrypt(this.userRefreshToken);
            if (decrypted != null) {
                this.decryptedRefreshToken = decrypted;
                System.out.println("[Tunnely] Refresh token successfully decrypted");
            } else {
                System.err.println("[Tunnely] Failed to decrypt refresh token");
                this.decryptedRefreshToken = "";
                this.userRefreshToken = "";
                this.save();
            }
        } else {
            System.out.println("[Tunnely] Migrating plaintext refresh token to encrypted storage");
            this.decryptedRefreshToken = this.userRefreshToken;
            encrypted = encryptor.encrypt(this.userRefreshToken);
            if (encrypted != null) {
                this.userRefreshToken = encrypted;
                this.save();
                System.out.println("[Tunnely] Refresh token encrypted and saved");
            } else {
                System.err.println("[Tunnely] Failed to encrypt refresh token");
            }
        }
    }

    public void save() {
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[Tunnely] Failed to save config: " + e.getMessage());
        }
    }

    public String getRelayServerUrl() {
        return this.relayServerUrl;
    }

    public void setRelayServerUrl(String relayServerUrl) {
        this.relayServerUrl = relayServerUrl;
    }

    public List<RelayEndpoint> getRelays() {
        if (this.relays == null) {
            this.relays = new ArrayList<RelayEndpoint>();
        }
        return this.relays;
    }

    public void setRelays(List<RelayEndpoint> relays) {
        this.relays = relays != null ? relays : new ArrayList();
        this.save();
    }

    public boolean hasRelayList() {
        return this.relays != null && !this.relays.isEmpty();
    }

    public String getSupabaseUrl() {
        return this.supabaseUrl;
    }

    public void setSupabaseUrl(String supabaseUrl) {
        this.supabaseUrl = supabaseUrl;
    }

    public String getSupabaseAnonKey() {
        return this.supabaseAnonKey;
    }

    public void setSupabaseAnonKey(String supabaseAnonKey) {
        this.supabaseAnonKey = supabaseAnonKey;
    }

    public String getUserJwtToken() {
        return this.decryptedJwtToken != null ? this.decryptedJwtToken : "";
    }

    public void setUserJwtToken(String userJwtToken) {
        if (userJwtToken == null || userJwtToken.isEmpty()) {
            this.decryptedJwtToken = "";
            this.userJwtToken = "";
            this.save();
            return;
        }
        this.decryptedJwtToken = userJwtToken;
        TokenEncryptor encryptor = TokenEncryptor.getInstance();
        String encrypted = encryptor.encrypt(userJwtToken);
        if (encrypted != null) {
            this.userJwtToken = encrypted;
            System.out.println("[Tunnely] JWT token encrypted and stored securely");
        } else {
            System.err.println("[Tunnely] Encryption failed, storing token in plaintext");
            this.userJwtToken = userJwtToken;
        }
        this.save();
    }

    public String getUserRefreshToken() {
        return this.decryptedRefreshToken != null ? this.decryptedRefreshToken : "";
    }

    public void setUserRefreshToken(String refreshToken) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            this.decryptedRefreshToken = "";
            this.userRefreshToken = "";
            this.save();
            return;
        }
        this.decryptedRefreshToken = refreshToken;
        TokenEncryptor encryptor = TokenEncryptor.getInstance();
        String encrypted = encryptor.encrypt(refreshToken);
        if (encrypted != null) {
            this.userRefreshToken = encrypted;
            System.out.println("[Tunnely] Refresh token encrypted and stored securely");
        } else {
            System.err.println("[Tunnely] Encryption failed, storing refresh token in plaintext");
            this.userRefreshToken = refreshToken;
        }
        this.save();
    }

    public String getSupabaseUserId() {
        return this.supabaseUserId;
    }

    public void setSupabaseUserId(String supabaseUserId) {
        this.supabaseUserId = supabaseUserId;
        this.save();
    }

    public String getMinecraftUuid() {
        return this.minecraftUuid;
    }

    public void setMinecraftUuid(String minecraftUuid) {
        this.minecraftUuid = minecraftUuid;
        this.save();
    }

    public boolean isEnableTunneling() {
        return this.enableTunneling;
    }

    public void setEnableTunneling(boolean enableTunneling) {
        this.enableTunneling = enableTunneling;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isAuthenticated() {
        return this.userJwtToken != null && !this.userJwtToken.isEmpty();
    }

    public String getAcceptedTosVersion() {
        return this.acceptedTosVersion != null ? this.acceptedTosVersion : "";
    }

    public void setAcceptedTosVersion(String version) {
        this.acceptedTosVersion = version;
        this.tosAcceptedTimestamp = System.currentTimeMillis();
        this.save();
    }

    public long getTosAcceptedTimestamp() {
        return this.tosAcceptedTimestamp;
    }

    public boolean needsTosAcceptance(String currentTosVersion) {
        if (this.acceptedTosVersion == null || this.acceptedTosVersion.isEmpty()) {
            return true;
        }
        return !this.acceptedTosVersion.equals(currentTosVersion);
    }

    public void clearAuth() {
        this.userJwtToken = "";
        this.decryptedJwtToken = "";
        this.userRefreshToken = "";
        this.decryptedRefreshToken = "";
        this.supabaseUserId = "";
        this.save();
        System.out.println("[Tunnely] Authentication cleared");
    }

    public boolean isAutoStartTunnel() {
        return this.autoStartTunnel;
    }

    public void setAutoStartTunnel(boolean autoStartTunnel) {
        this.autoStartTunnel = autoStartTunnel;
        this.save();
    }

    public String getSavedVisibility() {
        return this.savedVisibility != null ? this.savedVisibility : "invite_only";
    }

    public void setSavedVisibility(String visibility) {
        this.savedVisibility = visibility;
        this.save();
    }

    public String getSavedServerName() {
        return this.savedServerName != null ? this.savedServerName : "Minecraft Server";
    }

    public void setSavedServerName(String serverName) {
        this.savedServerName = serverName;
        this.save();
    }

    public String getEncryptedPrivateKey() {
        return this.encryptedPrivateKey != null ? this.encryptedPrivateKey : "";
    }

    public void setEncryptedPrivateKey(String encryptedPrivateKey) {
        this.encryptedPrivateKey = encryptedPrivateKey;
        this.save();
    }

    public String getPublicKey() {
        return this.publicKey != null ? this.publicKey : "";
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        this.save();
    }

    public boolean hasEncryptionKeys() {
        return !this.getEncryptedPrivateKey().isEmpty() && !this.getPublicKey().isEmpty();
    }

    public boolean isMessageNotificationsEnabled() {
        return this.messageNotificationsEnabled;
    }

    public void setMessageNotificationsEnabled(boolean enabled) {
        this.messageNotificationsEnabled = enabled;
        this.save();
    }

    public int getMaxPlayers() {
        return this.maxPlayers > 0 ? this.maxPlayers : 8;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = Math.max(1, Math.min(20, maxPlayers));
        this.save();
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean offlineMode) {
        this.offlineMode = offlineMode;
        this.save();
    }

    public String getDefaultGamemode() {
        return this.defaultGamemode != null ? this.defaultGamemode : "survival";
    }

    public void setDefaultGamemode(String gamemode) {
        this.defaultGamemode = gamemode;
        this.save();
    }

    public long getDownloadBandwidthLimit() {
        return this.downloadBandwidthLimit;
    }

    public void setDownloadBandwidthLimit(long bytesPerSecond) {
        this.downloadBandwidthLimit = Math.max(0L, bytesPerSecond);
        this.save();
    }

    public static class RelayEndpoint {
        public String id;
        public String region;
        public String url;

        public RelayEndpoint() {
        }

        public RelayEndpoint(String id, String region, String url) {
            this.id = id;
            this.region = region;
            this.url = url;
        }
    }
}

