/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_420;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.ToastNotificationManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.util.TunnelyResolver;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_420.class})
public abstract class DirectJoinServerScreenMixin {
    @Shadow
    private class_4185 field_2462;
    @Shadow
    private class_342 field_2463;
    private boolean tunnelyrefab$lastWasEndpoint = false;
    private boolean tunnelyrefab$normalizing = false;

    @Shadow
    private void method_2169() {
    }

    @Inject(method={"updateSelectButtonStatus"}, at={@At(value="TAIL")})
    private void tunnelyrefab$allowTunnelyUrls(CallbackInfo ci) {
        String input = this.field_2463.method_1882();
        if (!this.field_2462.field_22763 && TunnelyResolver.isEndpoint(input)) {
            this.field_2462.field_22763 = true;
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void tunnelyrefab$wireResponder(CallbackInfo ci) {
        this.field_2463.method_1863(s -> {
            this.method_2169();
            this.tunnelyrefab$onInputChanged();
        });
    }

    @Inject(method={"onSelect"}, at={@At(value="HEAD")}, cancellable=true)
    private void tunnelyrefab$interceptTunnelyEndpoint(CallbackInfo ci) {
        String input = this.field_2463.method_1882();
        TunnelyResolver.ParsedEndpoint endpoint = TunnelyResolver.parseEndpoint(input);
        if (endpoint == null) {
            return;
        }
        this.tunnelyrefab$setNormalizedText(endpoint);
        ToastNotificationManager.getInstance().showWarning("Tunnely", "Connecting via relay " + endpoint.relayUrl + " (session " + endpoint.sessionId + ")");
        ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, err -> {
            ToastNotificationManager.getInstance().showWarning("Tunnely", "Connection failed: " + err);
            String type = DirectJoinServerScreenMixin.tunnelyrefab$categorizeError(err);
            class_310.method_1551().execute(() -> {
                class_310 mc = class_310.method_1551();
                mc.method_1507((class_437)new ConnectionInfoScreen(mc.field_1755, "Direct Connection", type, (String)err, () -> ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, e -> {})));
            });
        });
        ci.cancel();
    }

    private void tunnelyrefab$onInputChanged() {
        String value = this.field_2463.method_1882();
        boolean isEndpoint = TunnelyResolver.isEndpoint(value);
        if (isEndpoint != this.tunnelyrefab$lastWasEndpoint) {
            this.tunnelyrefab$lastWasEndpoint = isEndpoint;
            if (isEndpoint) {
                this.field_2462.method_25355((class_2561)class_2561.method_43470((String)"Join via Tunnely"));
                ToastNotificationManager.getInstance().showWarning("Tunnely", "Endpoint detected. Press Join to connect via relay.");
                TunnelyResolver.ParsedEndpoint parsed = TunnelyResolver.parseEndpoint(value);
                if (parsed != null) {
                    this.tunnelyrefab$setNormalizedText(parsed);
                }
            } else {
                this.field_2462.method_25355((class_2561)class_2561.method_43471((String)"selectServer.select"));
            }
        }
    }

    private void tunnelyrefab$setNormalizedText(TunnelyResolver.ParsedEndpoint endpoint) {
        if (this.tunnelyrefab$normalizing) {
            return;
        }
        this.tunnelyrefab$normalizing = true;
        try {
            String normalized = endpoint.relayUrl + "/" + endpoint.sessionId;
            if (!normalized.equals(this.field_2463.method_1882())) {
                this.field_2463.method_1852(normalized);
            }
        }
        finally {
            this.tunnelyrefab$normalizing = false;
        }
    }

    private static String tunnelyrefab$categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lower = error.toLowerCase();
        if (lower.contains("full") || lower.contains("capacity")) {
            return "FULL";
        }
        if (lower.contains("not authorized") || lower.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lower.contains("not found") || lower.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lower.contains("connection") || lower.contains("timeout") || lower.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lower.contains("incompatible") || lower.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }
}

