/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.realtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.SupabaseRealtimeClient;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;

public class RealtimeManager {
    private static RealtimeManager instance;
    private final TunnelConfig config;
    private final List<SupabaseRealtimeClient> activeClients;
    private final List<Consumer<JsonObject>> messageListeners = new ArrayList<Consumer<JsonObject>>();
    private final List<Consumer<JsonObject>> friendRequestListeners = new ArrayList<Consumer<JsonObject>>();
    private final List<Consumer<JsonObject>> friendAcceptListeners = new ArrayList<Consumer<JsonObject>>();
    private boolean isRunning = false;

    private RealtimeManager() {
        this.config = TunnelConfig.getInstance();
        this.activeClients = new ArrayList<SupabaseRealtimeClient>();
    }

    public static synchronized RealtimeManager getInstance() {
        if (instance == null) {
            instance = new RealtimeManager();
        }
        return instance;
    }

    public boolean start() {
        if (this.isRunning) {
            System.out.println("[Tunnely Realtime] Already running");
            return true;
        }
        if (!this.config.isAuthenticated()) {
            System.err.println("[Tunnely Realtime] Not authenticated");
            return false;
        }
        String userId = this.config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely Realtime] No user ID");
            return false;
        }
        String supabaseUrl = this.config.getSupabaseUrl();
        String apiKey = this.config.getSupabaseAnonKey();
        String accessToken = this.config.getUserJwtToken();
        if (supabaseUrl == null || apiKey == null || accessToken == null) {
            System.err.println("[Tunnely Realtime] Missing credentials");
            return false;
        }
        boolean anySuccess = false;
        try {
            SupabaseRealtimeClient messagesClient = new SupabaseRealtimeClient(supabaseUrl, apiKey, accessToken, userId, this::onMessageReceived);
            messagesClient.connect();
            Thread.sleep(1000L);
            if (messagesClient.isSubscribed()) {
                this.activeClients.add(messagesClient);
                anySuccess = true;
                System.out.println("[Tunnely Realtime] \u2713 Subscribed to messages");
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Realtime] Failed to subscribe to messages: " + e.getMessage());
        }
        this.isRunning = anySuccess;
        return anySuccess;
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        for (SupabaseRealtimeClient client : this.activeClients) {
            try {
                client.disconnect();
            }
            catch (Exception e) {
                System.err.println("[Tunnely Realtime] Error disconnecting client: " + e.getMessage());
            }
        }
        this.activeClients.clear();
        this.isRunning = false;
        System.out.println("[Tunnely Realtime] Stopped");
    }

    public void addMessageListener(Consumer<JsonObject> listener) {
        this.messageListeners.add(listener);
    }

    public void removeMessageListener(Consumer<JsonObject> listener) {
        this.messageListeners.remove(listener);
    }

    public void addFriendRequestListener(Consumer<JsonObject> listener) {
        this.friendRequestListeners.add(listener);
    }

    public void addFriendAcceptListener(Consumer<JsonObject> listener) {
        this.friendAcceptListeners.add(listener);
    }

    private void onMessageReceived(JsonObject record) {
        for (Consumer<JsonObject> listener : this.messageListeners) {
            try {
                listener.accept(record);
            }
            catch (Exception e) {
                System.err.println("[Tunnely Realtime] Error in message listener: " + e.getMessage());
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning && !this.activeClients.isEmpty();
    }

    public int getActiveSubscriptionCount() {
        return this.activeClients.size();
    }
}

