/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.UiRenderUtil;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class DownloadSettingsScreen
extends class_437 {
    private final class_437 parent;
    private final TunnelConfig config;
    private final WorldManager worldManager;
    private BandwidthSlider bandwidthSlider;
    private String statusMessage = "";

    public DownloadSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Download Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.bandwidthSlider = new BandwidthSlider(centerX - 150, centerY - 20, 300, 20);
        this.method_37063((class_364)this.bandwidthSlider);
        int presetY = centerY + 20;
        int buttonWidth = 90;
        int buttonSpacing = 95;
        int startX = centerX - buttonSpacing * 3;
        this.addPresetButton(startX, presetY, "Unlimited", 0L);
        this.addPresetButton(startX + buttonSpacing, presetY, "100 KB/s", 102400L);
        this.addPresetButton(startX + buttonSpacing * 2, presetY, "500 KB/s", 512000L);
        this.addPresetButton(startX + buttonSpacing * 3, presetY, "1 MB/s", 0x100000L);
        this.addPresetButton(startX + buttonSpacing * 4, presetY, "2 MB/s", 0x200000L);
        this.addPresetButton(startX + buttonSpacing * 5, presetY, "5 MB/s", 0x500000L);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Settings"), button -> this.saveSettings()).method_46434(centerX - 100, centerY + 80, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX - 50, this.field_22790 - 30, 100, 20).method_46431());
    }

    private void addPresetButton(int x, int y, String label, long bytesPerSecond) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)label), button -> this.setBandwidthPreset(bytesPerSecond)).method_46434(x, y, 85, 18).method_46431());
    }

    private void setBandwidthPreset(long bytesPerSecond) {
        this.worldManager.setBandwidthLimit(bytesPerSecond);
        this.bandwidthSlider.updateFromConfig();
        this.statusMessage = "\u00a7aPreset applied: " + this.formatBytesPerSecond(bytesPerSecond);
    }

    private void saveSettings() {
        this.statusMessage = "\u00a7aSettings saved!";
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u2699 Download Settings", centerX, 20, 0xFFFFFF);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77Configure download speed limits", centerX, 40, 0xAAAAAA);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "Download Speed Limit", centerX, centerY - 40, 0xFFFFFF);
        long currentLimit = this.config.getDownloadBandwidthLimit();
        String limitText = this.formatBytesPerSecond(currentLimit);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a7e" + limitText, centerX, centerY + 5, 0xFFFF55);
        String helpText1 = "\u00a77Set to 0 (Unlimited) for maximum speed";
        String helpText2 = "\u00a77Limit speed to avoid network congestion";
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, helpText1, centerX, centerY - 60, 0x888888);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, helpText2, centerX, centerY - 48, 0x888888);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77Quick Presets", centerX, centerY + 60, 0xAAAAAA);
        int useCaseY = centerY + 110;
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a78Recommendations:", centerX, useCaseY, 0x666666);
        UiRenderUtil.drawString(graphics, this.field_22793, "\u00a78\u2022 Gaming (active): 1-2 MB/s", centerX - 150, useCaseY + 15, 0x666666);
        UiRenderUtil.drawString(graphics, this.field_22793, "\u00a78\u2022 Shared network: 500 KB/s", centerX - 150, useCaseY + 27, 0x666666);
        UiRenderUtil.drawString(graphics, this.field_22793, "\u00a78\u2022 Mobile hotspot: 100 KB/s", centerX - 150, useCaseY + 39, 0x666666);
        UiRenderUtil.drawString(graphics, this.field_22793, "\u00a78\u2022 No constraint: Unlimited", centerX - 150, useCaseY + 51, 0x666666);
        if (!this.statusMessage.isEmpty()) {
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, this.statusMessage, centerX, this.field_22790 - 50, 0xFFFFFF);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond == 0L) {
            return "Unlimited";
        }
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    private class BandwidthSlider
    extends class_357 {
        private static final long MAX_LIMIT = 0xA00000L;

        public BandwidthSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
            this.updateFromConfig();
            this.method_25346();
        }

        public void updateFromConfig() {
            long currentLimit = DownloadSettingsScreen.this.config.getDownloadBandwidthLimit();
            this.field_22753 = currentLimit == 0L ? 0.0 : Math.min(1.0, (double)currentLimit / 1.048576E7);
            this.method_25346();
        }

        protected void method_25346() {
            long limit = (long)(this.field_22753 * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            this.method_25355((class_2561)class_2561.method_43470((String)DownloadSettingsScreen.this.formatBytesPerSecond(limit)));
        }

        protected void method_25344() {
            long limit = (long)(this.field_22753 * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            DownloadSettingsScreen.this.config.setDownloadBandwidthLimit(limit);
            DownloadSettingsScreen.this.worldManager.setBandwidthLimit(limit);
            DownloadSettingsScreen.this.statusMessage = "\u00a7aBandwidth limit updated";
        }
    }
}

