/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonArray;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonElement;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonParser;
import org.texboobcat.tunnelyrefab.ui.UiRenderUtil;

public class FriendsScreen
extends class_437 {
    private final class_437 parent;
    private FriendListWidget friendList;
    private class_342 friendEmailBox;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public FriendsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Friends"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int inputWidth = 200;
        int centerX = this.field_22789 / 2 - inputWidth / 2;
        this.friendEmailBox = new class_342(this.field_22793, centerX, this.field_22790 - 95, inputWidth - 70, 20, (class_2561)class_2561.method_43470((String)"Minecraft Username"));
        this.friendEmailBox.method_1880(16);
        this.friendEmailBox.method_47404((class_2561)class_2561.method_43470((String)"Minecraft username"));
        this.method_37063((class_364)this.friendEmailBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), button -> this.addFriend()).method_46434(centerX + inputWidth - 65, this.field_22790 - 95, 60, 20).method_46431());
        this.friendList = new FriendListWidget(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 110, 35);
        this.method_25429((class_364)this.friendList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04 Refresh"), button -> this.loadFriends()).method_46434(this.field_22789 / 2 - 155, this.field_22790 - 50, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 55, this.field_22790 - 50, 100, 20).method_46431());
        this.loadFriends();
    }

    private void addFriend() {
        String username = this.friendEmailBox.method_1882().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF0000;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]{3,16}$")) {
            this.statusMessage = "\u00a7cInvalid Minecraft username";
            this.statusColor = 0xFF0000;
            System.err.println("[Tunnely UI] Invalid username format: " + username);
            return;
        }
        System.out.println("[Tunnely UI] ===== ADDING FRIEND =====");
        System.out.println("[Tunnely UI] Username: " + username);
        this.statusMessage = "\u00a7eSending friend request...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendFriendRequestByUsername(username);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend request sent to " + username + "!";
                        this.statusColor = 65280;
                        this.friendEmailBox.method_1852("");
                        System.out.println("[Tunnely UI] \u2713 Friend request succeeded, reloading list");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cUser not found or request failed";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Friend request failed for: " + username);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception adding friend: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-AddFriend").start();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.field_22787.execute(() -> {
                    block7: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends data...");
                                JsonArray friends = JsonParser.parseString(result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " friend(s)");
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends yet. Add some above!";
                                    this.statusColor = 0xAAAAAA;
                                    break block7;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friendProfile;
                                    JsonObject friend = element.getAsJsonObject();
                                    String friendId = friend.get("id").getAsString();
                                    String minecraftName = "Unknown";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull() && (friendProfile = friend.getAsJsonObject("friend")).has("minecraft_name")) {
                                        minecraftName = friendProfile.get("minecraft_name").getAsString();
                                    }
                                    String status = friend.has("status") ? friend.get("status").getAsString() : "unknown";
                                    System.out.println("[Tunnely UI] Friend: " + minecraftName + " (status: " + status + ")");
                                    this.friendList.addFriend(friendId, minecraftName, status);
                                }
                                this.statusMessage = "\u00a7a" + friends.size() + " friend(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriends").start();
    }

    private void removeFriend(String friendId) {
        System.out.println("[Tunnely UI] ===== REMOVING FRIEND =====");
        System.out.println("[Tunnely UI] Friend ID: " + friendId);
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.removeFriend(friendId);
                this.field_22787.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aFriend removed";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Friend removed successfully");
                        this.loadFriends();
                    } else {
                        this.statusMessage = "\u00a7cFailed to remove friend";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to remove friend");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception removing friend: " + e.getMessage());
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-RemoveFriend").start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
        this.friendList.method_25394(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a76\u00a7lManage Friends", this.field_22789 / 2, 20, 0xFFFFFF);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, this.statusMessage, this.field_22789 / 2, 35, this.statusColor);
        UiRenderUtil.drawString(graphics, this.field_22793, "Add Friend (Minecraft name):", this.field_22789 / 2 - 100, this.field_22790 - 110, 0xFFFFFF);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private class FriendListWidget
    extends class_4280<FriendEntry> {
        public FriendListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.method_25339();
        }

        public void addFriend(String id, String name, String status) {
            this.method_25321((class_350.class_351)new FriendEntry(id, name, status));
        }

        class FriendEntry
        extends class_4280.class_4281<FriendEntry> {
            private final String id;
            private final String name;
            private final String status;
            private final class_4185 removeButton;

            public FriendEntry(String id, String name, String status) {
                this.id = id;
                this.name = name;
                this.status = status;
                this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), button -> FriendsScreen.this.removeFriend(id)).method_46434(0, 0, 70, 20).method_46431();
            }

            public void method_25343(class_332 graphics, int y, int x, boolean isMouseOver, float partialTick) {
                UiRenderUtil.drawString(graphics, FriendsScreen.this.field_22793, "\u00a7b" + this.name, x + 5, y + 5, 0xFFFFFF);
                String statusText = this.status.equals("accepted") ? "\u00a7a\u2713 Friends" : (this.status.equals("pending") ? "\u00a7e\u23f3 Pending" : "\u00a77Unknown");
                UiRenderUtil.drawString(graphics, FriendsScreen.this.field_22793, statusText, x + 5, y + 18, 0xFFFFFF);
                int rowWidth = FriendListWidget.this.method_25322();
                this.removeButton.method_46421(x + rowWidth - 80);
                this.removeButton.method_46419(y + 7);
                this.removeButton.method_25394(graphics, 0, 0, partialTick);
            }

            public boolean method_25402(class_11909 event, boolean pressed) {
                if (!pressed) {
                    return super.method_25402(event, pressed);
                }
                if (event.method_74245() == 0 && this.removeButton.method_25402(event, pressed)) {
                    return true;
                }
                return super.method_25402(event, pressed);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)(this.name + " - " + this.status));
            }
        }
    }
}

