/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonArray;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonElement;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonParser;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.UiRenderUtil;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;
import org.texboobcat.tunnelyrefab.util.SafeDisconnect;

public class PublicLobbiesScreen
extends class_437 {
    private final class_437 parent;
    private String statusMessage = "\u00a7eLoading public servers...";
    private int statusColor = 0xFFFF00;
    private class_4286 compatibleOnlyCheckbox;
    private CompatibilityDetector.CompatibilityInfo clientCompatibility;
    private String regionFilter = "ALL";
    private class_4185 regionButton;
    private class_4185 refreshButton;
    private class_4185 backButton;
    private Set<String> availableRegions = new HashSet<String>();
    private volatile boolean isLoading = false;
    private List<ServerEntry> servers = new ArrayList<ServerEntry>();
    private int totalServersCount = 0;
    private int compatibleServersCount = 0;
    private int totalPlayersOnline = 0;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private static final int SERVER_ENTRY_HEIGHT = 70;
    private static boolean warningShownThisSession = false;
    private boolean skipWarning;

    public PublicLobbiesScreen(class_437 parent) {
        this(parent, false);
    }

    public PublicLobbiesScreen(class_437 parent, boolean skipWarning) {
        super((class_2561)class_2561.method_43470((String)"Public Lobbies"));
        this.parent = parent;
        this.skipWarning = skipWarning;
        this.clientCompatibility = CompatibilityDetector.detect();
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.skipWarning && !warningShownThisSession && this.clientCompatibility.modpackId == null) {
            warningShownThisSession = true;
            this.field_22787.method_1507((class_437)new WarningPopupScreen(new PublicLobbiesScreen(this.parent, true), this.parent, "Warning: No Modpack Detected", "You don't have a modpack file detected.\\n\\nThis means you're highly likely to be incompatible with most public servers.\\n\\nHost public servers use modpacks from CurseForge. Most servers listed here expect you to also have those mods.\\n\\nYou can still browse, but check compatibility carefully!", 0xFFAA00, null));
            return;
        }
        int buttonY = this.field_22790 - 30;
        this.compatibleOnlyCheckbox = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Compatible Only"), (class_327)this.field_22793).method_54789(15, buttonY - 25).method_54794(false).method_54791((checkbox, value) -> this.filterServers()).method_54788();
        this.method_37063((class_364)this.compatibleOnlyCheckbox);
        this.regionButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Region: " + this.regionFilter)), button -> this.cycleRegion()).method_46434(15, buttonY - 50, 120, 20).method_46431();
        this.method_37063((class_364)this.regionButton);
        this.refreshButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04 Refresh"), button -> this.loadServers()).method_46434(this.field_22789 / 2 - 155, buttonY, 100, 20).method_46431();
        this.method_37063((class_364)this.refreshButton);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 5, buttonY, 150, 20).method_46431();
        this.method_37063((class_364)this.backButton);
        this.loadServers();
    }

    private void cycleRegion() {
        String[] regions = this.availableRegions.toArray(new String[0]);
        if (regions.length == 0) {
            this.regionFilter = "ALL";
        } else {
            int currentIndex = -1;
            for (int i = 0; i < regions.length; ++i) {
                if (!regions[i].equals(this.regionFilter)) continue;
                currentIndex = i;
                break;
            }
            this.regionFilter = (currentIndex = (currentIndex + 1) % (regions.length + 1)) < regions.length ? regions[currentIndex] : "ALL";
        }
        this.regionButton.method_25355((class_2561)class_2561.method_43470((String)("Region: " + this.regionFilter)));
        this.filterServers();
    }

    private void loadServers() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.statusMessage = "\u00a7eLoading servers...";
        this.statusColor = 0xFFFF00;
        this.refreshButton.field_22763 = false;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getPublicServers();
                if (!result.success) {
                    throw new Exception(result.error != null ? result.error : "Failed to load servers");
                }
                String json = result.data;
                JsonArray array = JsonParser.parseString(json).getAsJsonArray();
                ArrayList<ServerEntry> loadedServers = new ArrayList<ServerEntry>();
                HashSet<String> regions = new HashSet<String>();
                int totalPlayers = 0;
                int compatible = 0;
                for (JsonElement el : array) {
                    JsonObject obj = el.getAsJsonObject();
                    ServerEntry entry = new ServerEntry(obj);
                    loadedServers.add(entry);
                    if (entry.region != null && !entry.region.isEmpty()) {
                        regions.add(entry.region);
                    }
                    totalPlayers += entry.currentPlayers;
                    if (!entry.isCompatible) continue;
                    ++compatible;
                }
                int finalTotalPlayers = totalPlayers;
                int finalCompatible = compatible;
                this.field_22787.execute(() -> {
                    this.servers = loadedServers;
                    this.availableRegions = regions;
                    this.totalServersCount = loadedServers.size();
                    this.compatibleServersCount = finalCompatible;
                    this.totalPlayersOnline = finalTotalPlayers;
                    this.filterServers();
                    this.calculateMaxScroll();
                    this.statusMessage = "\u00a7aLoaded " + loadedServers.size() + " servers";
                    this.statusColor = 65280;
                    this.isLoading = false;
                    this.refreshButton.field_22763 = true;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cError loading servers: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                    this.isLoading = false;
                    this.refreshButton.field_22763 = true;
                });
            }
        }).start();
    }

    private void filterServers() {
        this.calculateMaxScroll();
    }

    private void calculateMaxScroll() {
        int visibleCount = 0;
        for (ServerEntry entry : this.servers) {
            if (!this.shouldShowServer(entry)) continue;
            ++visibleCount;
        }
        int contentTop = 80;
        int contentBottom = this.field_22790 - 80;
        int visibleHeight = contentBottom - contentTop;
        int totalHeight = visibleCount * 70;
        this.maxScroll = Math.max(0, totalHeight - visibleHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
    }

    private boolean shouldShowServer(ServerEntry entry) {
        if (this.compatibleOnlyCheckbox != null && this.compatibleOnlyCheckbox.method_20372() && !entry.isCompatible) {
            return false;
        }
        return this.regionFilter.equals("ALL") || this.regionFilter.equals(entry.region);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a76\u00a7lPublic Lobbies", this.field_22789 / 2, 15, 0xFFAA00);
        String stats = "\u00a77Showing \u00a7e" + this.getVisibleCount() + "\u00a77 of \u00a7e" + this.totalServersCount + "\u00a77 server(s)";
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, stats, this.field_22789 / 2, 30, 0xAAAAAA);
        String leftInfo = "\u00a77Players Online: \u00a7e" + this.totalPlayersOnline;
        UiRenderUtil.drawString(graphics, this.field_22793, leftInfo, 15, 55, 0xAAAAAA);
        String rightInfo = "\u00a77Compatible: \u00a7a" + this.compatibleServersCount + "\u00a77/\u00a7e" + this.totalServersCount;
        int rightWidth = this.field_22793.method_1727(rightInfo);
        UiRenderUtil.drawString(graphics, this.field_22793, rightInfo, this.field_22789 - rightWidth - 15, 55, 0xAAAAAA);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int contentTop = 80;
        int contentBottom = this.field_22790 - 80;
        graphics.method_44379(10, contentTop, this.field_22789 - 10, contentBottom);
        int yPos = contentTop - this.scrollOffset;
        for (ServerEntry entry : this.servers) {
            if (!this.shouldShowServer(entry)) continue;
            if (yPos + 70 >= contentTop && yPos <= contentBottom) {
                this.renderServerEntry(graphics, entry, yPos, mouseX, mouseY);
            }
            yPos += 70;
        }
        graphics.method_44380();
        if (this.maxScroll > 0) {
            this.renderScrollbar(graphics, contentTop, contentBottom);
        }
        if (!this.statusMessage.isEmpty()) {
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 - 50, this.statusColor);
        }
    }

    private int getVisibleCount() {
        int count = 0;
        for (ServerEntry entry : this.servers) {
            if (!this.shouldShowServer(entry)) continue;
            ++count;
        }
        return count;
    }

    private void renderServerEntry(class_332 graphics, ServerEntry entry, int y, int mouseX, int mouseY) {
        boolean buttonHovered;
        float playerRatio;
        int left = 20;
        int width = this.field_22789 - 40;
        boolean isHovered = mouseX >= left && mouseX <= left + width && mouseY >= y && mouseY <= y + 70;
        int bgColor = isHovered ? 0x33FFFFFF : 0x22000000;
        graphics.method_25294(left, y, left + width, y + 70 - 2, bgColor);
        String compatIcon = entry.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
        UiRenderUtil.drawString(graphics, this.field_22793, compatIcon, left + 8, y + 8, 0xFFFFFF);
        String displayName = entry.serverName.length() > 30 ? entry.serverName.substring(0, 27) + "..." : entry.serverName;
        UiRenderUtil.drawString(graphics, this.field_22793, "\u00a7f\u00a7l" + displayName, left + 28, y + 8, 0xFFFFFF);
        String hostInfo = "\u00a77Host: \u00a7f" + (String)(entry.hostName.length() > 15 ? entry.hostName.substring(0, 12) + "..." : entry.hostName);
        UiRenderUtil.drawString(graphics, this.field_22793, hostInfo, left + 28, y + 22, 0xAAAAAA);
        float f = playerRatio = entry.maxPlayers > 0 ? (float)entry.currentPlayers / (float)entry.maxPlayers : 0.0f;
        String playerColor = playerRatio >= 0.9f ? "\u00a7c" : (playerRatio >= 0.7f ? "\u00a7e" : "\u00a7a");
        String playerText = "\u00a77Players: " + playerColor + entry.currentPlayers + "\u00a77/\u00a7f" + entry.maxPlayers;
        int hostWidth = this.field_22793.method_1727(hostInfo);
        UiRenderUtil.drawString(graphics, this.field_22793, playerText, left + 28 + hostWidth + 15, y + 22, 0xAAAAAA);
        int badgeX = left + 28;
        int badgeY = y + 36;
        if (entry.minecraftVersion != null) {
            String versionText = "\u00a7e" + entry.minecraftVersion;
            UiRenderUtil.drawString(graphics, this.field_22793, versionText, badgeX, badgeY, 0xFFFFFF);
            badgeX += this.field_22793.method_1727(versionText) + 8;
        }
        if (entry.modLoader != null) {
            String loaderColor = entry.modLoader.toLowerCase().contains("fabric") ? "\u00a7b" : (entry.modLoader.toLowerCase().contains("forge") ? "\u00a7c" : "\u00a7d");
            String loaderText = loaderColor + entry.modLoader.toUpperCase();
            UiRenderUtil.drawString(graphics, this.field_22793, loaderText, badgeX, badgeY, 0xFFFFFF);
            badgeX += this.field_22793.method_1727(loaderText) + 8;
        } else {
            String vanillaText = "\u00a77VANILLA";
            UiRenderUtil.drawString(graphics, this.field_22793, vanillaText, badgeX, badgeY, 0xFFFFFF);
            badgeX += this.field_22793.method_1727(vanillaText) + 8;
        }
        if (entry.region != null) {
            String regionText = "\u00a76" + entry.region.toUpperCase();
            UiRenderUtil.drawString(graphics, this.field_22793, regionText, badgeX, badgeY, 0xFFFFFF);
            badgeX += this.field_22793.method_1727(regionText) + 8;
        }
        if (entry.gameMode != null) {
            String gameModeText = "\u00a79" + entry.gameMode.substring(0, 1).toUpperCase() + entry.gameMode.substring(1);
            UiRenderUtil.drawString(graphics, this.field_22793, gameModeText, badgeX, badgeY, 0xFFFFFF);
        }
        if (entry.modpackId != null) {
            String modpackText = "\u00a7d\ud83d\udce6 " + (String)(entry.modpackId.length() > 20 ? entry.modpackId.substring(0, 17) + "..." : entry.modpackId);
            if (entry.modpackVersion != null) {
                modpackText = modpackText + " \u00a77v" + entry.modpackVersion;
            }
            UiRenderUtil.drawString(graphics, this.field_22793, modpackText, left + 28, y + 50, 0xFFFFFF);
        }
        int buttonWidth = 60;
        int buttonHeight = 20;
        int buttonX = left + width - buttonWidth - 10;
        int buttonY = y + (70 - buttonHeight) / 2;
        boolean bl = buttonHovered = mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
        int buttonColor = entry.isCompatible ? (buttonHovered ? -16724992 : -16733696) : (buttonHovered ? -5614336 : -8961024);
        graphics.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonColor);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a7fJoin", buttonX + buttonWidth / 2, buttonY + 6, 0xFFFFFF);
    }

    private void renderScrollbar(class_332 graphics, int contentTop, int contentBottom) {
        int trackX = this.field_22789 - 15;
        int trackHeight = contentBottom - contentTop;
        int thumbHeight = Math.max(20, (int)((float)(contentBottom - contentTop) / (float)(this.maxScroll + (contentBottom - contentTop)) * (float)trackHeight));
        int thumbY = contentTop + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(trackHeight - thumbHeight));
        graphics.method_25294(trackX, contentTop, trackX + 6, contentBottom, Integer.MIN_VALUE);
        graphics.method_25294(trackX, thumbY, trackX + 6, thumbY + thumbHeight, -5592406);
    }

    public boolean method_25402(class_11909 event, boolean pressed) {
        if (!pressed && event.method_74245() == 0) {
            double mouseX = event.comp_4798();
            double mouseY = event.comp_4799();
            int contentTop = 80;
            int contentBottom = this.field_22790 - 80;
            if (mouseY >= (double)contentTop && mouseY <= (double)contentBottom) {
                int yPos = contentTop - this.scrollOffset;
                for (ServerEntry entry : this.servers) {
                    if (!this.shouldShowServer(entry)) continue;
                    if (mouseY >= (double)yPos && mouseY <= (double)(yPos + 70)) {
                        int left = 20;
                        int width = this.field_22789 - 40;
                        int buttonWidth = 60;
                        int buttonX = left + width - buttonWidth - 10;
                        int buttonY = yPos + 25;
                        if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20)) {
                            this.joinServer(entry);
                            return true;
                        }
                    }
                    yPos += 70;
                }
            }
        }
        return super.method_25402(event, pressed);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void joinServer(ServerEntry entry) {
        String sessionId;
        Object relayUrl;
        block4: {
            String endpoint = entry.publicEndpoint;
            if (endpoint.startsWith("ws://") || endpoint.startsWith("wss://")) {
                int lastSlash = endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < endpoint.length() - 1) {
                    relayUrl = endpoint.substring(0, lastSlash);
                    sessionId = endpoint.substring(lastSlash + 1);
                    break block4;
                } else {
                    this.showError("Invalid endpoint format");
                    return;
                }
            }
            if (!endpoint.contains("/")) {
                this.showError("Invalid endpoint format");
                return;
            }
            String[] parts = endpoint.split("/", 2);
            relayUrl = "wss://" + parts[0];
            sessionId = parts[1];
        }
        SafeDisconnect.disconnectAndThen(() -> this.lambda$joinServer$10((String)relayUrl, sessionId, entry));
    }

    private void showError(String message) {
        this.statusMessage = "\u00a7c" + message;
        this.statusColor = 0xFF5555;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        if (this.maxScroll > 0) {
            this.scrollOffset -= (int)(scrollDelta * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, scrollDelta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private /* synthetic */ void lambda$joinServer$10(String relayUrl, String sessionId, ServerEntry entry) {
        ClientTunnelManager manager = ClientTunnelManager.getInstance();
        manager.connectToServer(relayUrl, sessionId, () -> System.out.println("[Tunnely] Connected to " + entry.serverName), error -> this.field_22787.execute(() -> this.showError("Connection failed: " + error)));
    }

    private static class ServerEntry {
        final String id;
        final String serverName;
        final String hostName;
        final String publicEndpoint;
        final int currentPlayers;
        final int maxPlayers;
        final String gameMode;
        final String minecraftVersion;
        final String modLoader;
        final String modpackId;
        final String modpackVersion;
        final String region;
        final boolean isCompatible;

        ServerEntry(JsonObject obj) {
            this.id = obj.has("id") && !obj.get("id").isJsonNull() ? obj.get("id").getAsString() : "";
            this.serverName = obj.has("server_name") && !obj.get("server_name").isJsonNull() ? obj.get("server_name").getAsString() : "Unnamed Server";
            String extractedHostName = "Unknown";
            if (obj.has("host") && !obj.get("host").isJsonNull()) {
                JsonObject hostProfile = obj.getAsJsonObject("host");
                if (hostProfile.has("minecraft_name") && !hostProfile.get("minecraft_name").isJsonNull()) {
                    extractedHostName = hostProfile.get("minecraft_name").getAsString();
                }
            } else if (obj.has("host_name") && !obj.get("host_name").isJsonNull()) {
                extractedHostName = obj.get("host_name").getAsString();
            }
            this.hostName = extractedHostName;
            this.publicEndpoint = obj.has("public_endpoint") && !obj.get("public_endpoint").isJsonNull() ? obj.get("public_endpoint").getAsString() : "";
            this.currentPlayers = obj.has("current_players") && !obj.get("current_players").isJsonNull() ? obj.get("current_players").getAsInt() : 0;
            this.maxPlayers = obj.has("max_players") && !obj.get("max_players").isJsonNull() ? obj.get("max_players").getAsInt() : 0;
            this.gameMode = obj.has("game_mode") && !obj.get("game_mode").isJsonNull() ? obj.get("game_mode").getAsString() : null;
            this.region = obj.has("relay_region") && !obj.get("relay_region").isJsonNull() ? obj.get("relay_region").getAsString() : null;
            this.minecraftVersion = obj.has("minecraft_version") && !obj.get("minecraft_version").isJsonNull() ? obj.get("minecraft_version").getAsString() : null;
            this.modLoader = obj.has("mod_loader") && !obj.get("mod_loader").isJsonNull() ? obj.get("mod_loader").getAsString() : null;
            this.modpackId = obj.has("modpack_id") && !obj.get("modpack_id").isJsonNull() ? obj.get("modpack_id").getAsString() : null;
            this.modpackVersion = obj.has("modpack_version") && !obj.get("modpack_version").isJsonNull() ? obj.get("modpack_version").getAsString() : null;
            CompatibilityDetector.CompatibilityInfo clientInfo = CompatibilityDetector.detect();
            CompatibilityDetector.CompatibilityInfo serverInfo = new CompatibilityDetector.CompatibilityInfo(this.minecraftVersion, this.modLoader, this.modpackId, this.modpackVersion);
            this.isCompatible = clientInfo.isCompatibleWith(serverInfo);
        }
    }
}

