/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.UiRenderUtil;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.worlds.ContentModerator;
import org.texboobcat.tunnelyrefab.worlds.ImageLoader;
import org.texboobcat.tunnelyrefab.worlds.WorldComment;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.DownloadProtection;

public class WorldDetailsScreen
extends class_437 {
    private final class_437 parent;
    private final WorldInfo world;
    private final WorldManager worldManager;
    private boolean downloading = false;
    private String statusMessage = "";
    private int downloadProgress = 0;
    private int userRating = 0;
    private List<WorldComment> comments = new ArrayList<WorldComment>();
    private class_342 commentBox;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private static final int COMMENT_HEIGHT = 50;

    public WorldDetailsScreen(class_437 parent, WorldInfo world) {
        super((class_2561)class_2561.method_43470((String)"World Details"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.loadUserRating();
        this.loadComments();
        this.commentBox = new class_342(this.field_22793, centerX - 200, this.field_22790 - 60, 340, 20, (class_2561)class_2561.method_43470((String)"Write a comment..."));
        this.commentBox.method_1880(500);
        this.method_37063((class_364)this.commentBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Post"), button -> this.postComment()).method_46434(centerX + 145, this.field_22790 - 60, 55, 20).method_46431());
        for (int i = 1; i <= 5; ++i) {
            int rating = i;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(rating <= this.userRating ? "\u2605" : "\u2606")), button -> this.rateWorld(rating)).method_46434(centerX - 60 + (i - 1) * 25, this.field_22790 - 35, 20, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b07 Download"), button -> this.downloadWorld()).method_46434(this.field_22789 - 110, 10, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190 Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(10, 10, 80, 20).method_46431());
    }

    private void loadComments() {
        new Thread(() -> {
            List<WorldComment> loadedComments = this.worldManager.getComments(this.world.getId(), 20);
            this.field_22787.execute(() -> {
                this.comments = loadedComments;
            });
        }).start();
    }

    private void postComment() {
        String commentText = this.commentBox.method_1882().trim();
        if (commentText.isEmpty()) {
            this.statusMessage = "\u00a7cComment cannot be empty";
            return;
        }
        if (!ContentModerator.quickCheck(commentText)) {
            this.statusMessage = "\u00a7cComment contains inappropriate content";
            return;
        }
        this.statusMessage = "Posting comment...";
        new Thread(() -> {
            WorldManager.CommentResult result = this.worldManager.postComment(this.world.getId(), commentText);
            this.field_22787.execute(() -> {
                if (result.isSuccess()) {
                    this.statusMessage = "\u00a7aComment posted successfully!";
                    this.commentBox.method_1852("");
                    this.loadComments();
                } else {
                    this.statusMessage = "\u00a7c" + result.getMessage();
                }
            });
        }).start();
    }

    private void loadUserRating() {
        new Thread(() -> {
            int rating = this.worldManager.getUserRating(this.world.getId());
            this.field_22787.execute(() -> {
                this.userRating = rating;
            });
        }).start();
    }

    private void rateWorld(int rating) {
        new Thread(() -> {
            boolean success = this.worldManager.rateWorld(this.world.getId(), rating);
            this.field_22787.execute(() -> {
                if (success) {
                    this.userRating = rating;
                    this.statusMessage = "\u00a7aRated " + rating + " stars!";
                    this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                } else {
                    this.statusMessage = "\u00a7cFailed to rate world";
                }
            });
        }).start();
    }

    private void downloadWorld() {
        if (this.downloading) {
            return;
        }
        DownloadProtection.DownloadCheckResult check = DownloadProtection.checkDownloadSafety(this.world);
        if (check.isBlocked()) {
            this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFF5555, null));
            return;
        }
        if (check.isWarning()) {
            this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFFAA00, () -> this.proceedWithDownload()));
            return;
        }
        this.proceedWithDownload();
    }

    private void proceedWithDownload() {
        this.field_22787.method_1507((class_437)new DownloadProgressScreen(this, this.world));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\ud83c\udf0d World Details", this.field_22789 / 2, 15, 0xFFFFFF);
        int centerX = this.field_22789 / 2;
        int startY = 40 - this.scrollOffset;
        if (this.world.hasScreenshot()) {
            int screenshotWidth = 256;
            int screenshotHeight = 144;
            int screenshotX = centerX - screenshotWidth / 2;
            int screenshotY = startY;
            class_2960 screenshot = ImageLoader.loadImage(this.world.getScreenshotUrl());
            graphics.method_70845(screenshot, screenshotX, screenshotY, 0, 0, (float)screenshotWidth, (float)screenshotHeight, (float)screenshotWidth, (float)screenshotHeight);
            graphics.method_25294(screenshotX - 1, screenshotY - 1, screenshotX + screenshotWidth + 1, screenshotY, -1);
            graphics.method_25294(screenshotX - 1, screenshotY + screenshotHeight, screenshotX + screenshotWidth + 1, screenshotY + screenshotHeight + 1, -1);
            graphics.method_25294(screenshotX - 1, screenshotY, screenshotX, screenshotY + screenshotHeight, -1);
            graphics.method_25294(screenshotX + screenshotWidth, screenshotY, screenshotX + screenshotWidth + 1, screenshotY + screenshotHeight, -1);
            startY += screenshotHeight + 15;
        }
        Object nameText = this.world.getName();
        if (this.world.isVerified()) {
            nameText = "\u2713 " + (String)nameText;
        }
        if (this.world.isFeatured()) {
            nameText = "\u2b50 " + (String)nameText;
        }
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, (String)nameText, centerX, startY, 0xFFFFFF);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77by " + this.world.getAuthorUsername(), centerX, startY + 15, 0xAAAAAA);
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, this.world.getFormattedRating(), centerX, startY + 30, 0xFFFF55);
        String stats1 = "\u00a77\ud83d\udce5 " + this.world.getFormattedDownloadCount() + " downloads | \ud83d\udcbe " + this.world.getFormattedFileSize();
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, stats1, centerX, startY + 50, 0xAAAAAA);
        String stats2 = "\u00a77\ud83c\udfae Minecraft " + this.world.getMinecraftVersion() + " | \ud83c\udfd7 " + this.world.getWorldType();
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, stats2, centerX, startY + 65, 0xAAAAAA);
        if (!this.world.getTags().isEmpty()) {
            int tagY = startY + 85;
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77Tags:", centerX, tagY, 0xAAAAAA);
            StringBuilder tagsStr = new StringBuilder();
            for (String tag : this.world.getTags()) {
                tagsStr.append("[").append(tag).append("] ");
            }
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77" + tagsStr.toString(), centerX, tagY + 15, 0x888888);
        }
        int descY = startY + 115;
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77Description:", centerX, descY, 0xAAAAAA);
        int boxX = centerX - 200;
        int boxY = descY + 15;
        int boxWidth = 400;
        int boxHeight = 60;
        graphics.method_25294(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -2145378272);
        graphics.method_25294(boxX, boxY, boxX + boxWidth, boxY + 1, -12566464);
        graphics.method_25294(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -12566464);
        String description = this.world.getDescription();
        if (!description.isEmpty()) {
            String[] lines = this.wrapText(description, boxWidth - 10);
            int lineY = boxY + 5;
            for (int i = 0; i < Math.min(lines.length, 4); ++i) {
                UiRenderUtil.drawString(graphics, this.field_22793, "\u00a77" + lines[i], boxX + 5, lineY, 0xAAAAAA);
                lineY += 12;
            }
        } else {
            UiRenderUtil.drawString(graphics, this.field_22793, "\u00a77No description provided", boxX + 5, boxY + 5, 0x888888);
        }
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77Uploaded: " + this.world.getFormattedCreatedAt(), centerX, descY + boxHeight + 15, 0x888888);
        int commentsY = descY + boxHeight + 35;
        UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77\ud83d\udcac Comments (" + this.comments.size() + ")", centerX, commentsY, 0xFFFFFF);
        int commentBoxY = commentsY + 20;
        int availableHeight = this.field_22790 - commentBoxY - 70;
        int commentBoxHeight = Math.min(availableHeight, 150);
        graphics.method_25294(boxX, commentBoxY, boxX + boxWidth, commentBoxY + commentBoxHeight, -2146430960);
        graphics.method_25294(boxX, commentBoxY, boxX + boxWidth, commentBoxY + 1, -12566464);
        graphics.method_25294(boxX, commentBoxY + commentBoxHeight - 1, boxX + boxWidth, commentBoxY + commentBoxHeight, -12566464);
        graphics.method_44379(boxX, commentBoxY, boxX + boxWidth, commentBoxY + commentBoxHeight);
        if (this.comments.isEmpty()) {
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, "\u00a77No comments yet. Be the first to comment!", centerX, commentBoxY + commentBoxHeight / 2 - 5, 0x888888);
        } else {
            int yOffset = commentBoxY + 5;
            int visibleComments = commentBoxHeight / 50 + 1;
            for (int i = 0; i < Math.min(this.comments.size(), visibleComments); ++i) {
                WorldComment comment = this.comments.get(i);
                this.renderComment(graphics, comment, boxX + 5, yOffset, boxWidth - 10);
                yOffset += 50;
            }
        }
        graphics.method_44380();
        int totalContentHeight = startY + commentsY + 20 + this.comments.size() * 50 + 100;
        this.maxScrollOffset = Math.max(0, totalContentHeight - this.field_22790 + 100);
        if (!this.statusMessage.isEmpty()) {
            UiRenderUtil.drawCenteredString(graphics, this.field_22793, this.statusMessage, centerX, this.field_22790 - 80, 0xFFFFFF);
        }
        if (this.downloading && this.downloadProgress > 0) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = this.field_22790 - 60;
            graphics.method_25294(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.method_25294(barX, barY, barX + barWidth * this.downloadProgress / 100, barY + 10, -2141847723);
            graphics.method_25294(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.method_25294(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    public boolean method_25421() {
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double delta) {
        int scrollAmount = (int)(delta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - scrollAmount));
        return true;
    }

    private void renderComment(class_332 graphics, WorldComment comment, int x, int y, int width) {
        String header = "\u00a7e" + comment.getUsername() + " \u00a78\u2022 \u00a77" + comment.getFormattedTime();
        if (comment.isEdited()) {
            header = header + " \u00a78(edited)";
        }
        UiRenderUtil.drawString(graphics, this.field_22793, header, x, y, 0xFFFFFF);
        String[] lines = this.wrapText(comment.getComment(), width);
        int lineY = y + 11;
        for (int i = 0; i < Math.min(lines.length, 2); ++i) {
            UiRenderUtil.drawString(graphics, this.field_22793, "\u00a77" + lines[i], x, lineY, 0xCCCCCC);
            lineY += 9;
        }
        if (lines.length > 2) {
            UiRenderUtil.drawString(graphics, this.field_22793, "\u00a78...", x, lineY, 0x888888);
        }
        graphics.method_25294(x, y + 50 - 3, x + width, y + 50 - 2, -14342875);
    }

    private String[] wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }
}

