/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.minecraft.class_155;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonObject;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.JsonParser;

public class CompatibilityDetector {
    public static CompatibilityInfo detect() {
        String minecraftVersion = CompatibilityDetector.detectMinecraftVersion();
        String modLoader = CompatibilityDetector.detectModLoader();
        String modpackId = CompatibilityDetector.detectModpackId();
        String modpackVersion = CompatibilityDetector.detectModpackVersion(modpackId);
        return new CompatibilityInfo(minecraftVersion, modLoader, modpackId, modpackVersion);
    }

    private static String detectMinecraftVersion() {
        try {
            String version = class_155.method_16673().comp_4025();
            if (version != null && !version.isEmpty()) {
                return version;
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to detect Minecraft version: " + e.getMessage());
        }
        return "Unknown";
    }

    private static String detectModLoader() {
        try {
            Class.forName("net.fabricmc.loader.api.FabricLoader");
            return "fabric";
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("net.minecraftforge.fml.common.Mod");
                try {
                    Class.forName("net.neoforged.neoforge.common.NeoForge");
                    return "neoforge";
                }
                catch (ClassNotFoundException e) {
                    return "forge";
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("org.quiltmc.loader.api.QuiltLoader");
                    return "quilt";
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    return null;
                }
            }
        }
    }

    private static String detectModpackId() {
        Optional<String> curseId = CompatibilityDetector.detectCurseForgeModpack();
        if (curseId.isPresent()) {
            return curseId.get();
        }
        Optional<String> modrinthId = CompatibilityDetector.detectModrinthModpack();
        if (modrinthId.isPresent()) {
            return modrinthId.get();
        }
        Optional<String> customId = CompatibilityDetector.detectCustomModpack();
        if (customId.isPresent()) {
            return customId.get();
        }
        return null;
    }

    private static String detectModpackVersion(String modpackId) {
        if (modpackId == null) {
            return null;
        }
        if (modpackId.startsWith("curse:")) {
            return CompatibilityDetector.detectCurseForgeVersion();
        }
        if (modpackId.startsWith("modrinth:")) {
            return CompatibilityDetector.detectModrinthVersion();
        }
        return CompatibilityDetector.detectCustomModpackVersion();
    }

    private static Optional<String> detectCurseForgeModpack() {
        try {
            Path manifestPath = Paths.get("manifest.json", new String[0]);
            if (Files.exists(manifestPath, new LinkOption[0])) {
                String content = Files.readString(manifestPath);
                JsonObject manifest = JsonParser.parseString(content).getAsJsonObject();
                if (manifest.has("projectID")) {
                    int projectId = manifest.get("projectID").getAsInt();
                    return Optional.of("curse:" + projectId);
                }
                if (manifest.has("name")) {
                    String name = manifest.get("name").getAsString();
                    return Optional.of("curse:" + name.replaceAll("[^a-zA-Z0-9_-]", ""));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static String detectCurseForgeVersion() {
        try {
            String content;
            JsonObject manifest;
            Path manifestPath = Paths.get("manifest.json", new String[0]);
            if (Files.exists(manifestPath, new LinkOption[0]) && (manifest = JsonParser.parseString(content = Files.readString(manifestPath)).getAsJsonObject()).has("version")) {
                return manifest.get("version").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Optional<String> detectModrinthModpack() {
        try {
            String content;
            JsonObject index;
            Path modrinthPath = Paths.get("modrinth.index.json", new String[0]);
            if (Files.exists(modrinthPath, new LinkOption[0]) && (index = JsonParser.parseString(content = Files.readString(modrinthPath)).getAsJsonObject()).has("name")) {
                String name = index.get("name").getAsString();
                return Optional.of("modrinth:" + name.replaceAll("[^a-zA-Z0-9_-]", ""));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static String detectModrinthVersion() {
        try {
            String content;
            JsonObject index;
            Path modrinthPath = Paths.get("modrinth.index.json", new String[0]);
            if (Files.exists(modrinthPath, new LinkOption[0]) && (index = JsonParser.parseString(content = Files.readString(modrinthPath)).getAsJsonObject()).has("versionId")) {
                return index.get("versionId").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Optional<String> detectCustomModpack() {
        try {
            String content;
            JsonObject custom;
            Path customPath = Paths.get("tunnelyrefab-modpack.json", new String[0]);
            if (Files.exists(customPath, new LinkOption[0]) && (custom = JsonParser.parseString(content = Files.readString(customPath)).getAsJsonObject()).has("id")) {
                return Optional.of(custom.get("id").getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static String detectCustomModpackVersion() {
        try {
            String content;
            JsonObject custom;
            Path customPath = Paths.get("tunnelyrefab-modpack.json", new String[0]);
            if (Files.exists(customPath, new LinkOption[0]) && (custom = JsonParser.parseString(content = Files.readString(customPath)).getAsJsonObject()).has("version")) {
                return custom.get("version").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class CompatibilityInfo {
        public final String minecraftVersion;
        public final String modLoader;
        public final String modpackId;
        public final String modpackVersion;

        public CompatibilityInfo(String minecraftVersion, String modLoader, String modpackId, String modpackVersion) {
            this.minecraftVersion = minecraftVersion;
            this.modLoader = modLoader;
            this.modpackId = modpackId;
            this.modpackVersion = modpackVersion;
        }

        public String toString() {
            return String.format("MC:%s Loader:%s Modpack:%s/%s", this.minecraftVersion, this.modLoader != null ? this.modLoader : "vanilla", this.modpackId != null ? this.modpackId : "none", this.modpackVersion != null ? this.modpackVersion : "n/a");
        }

        public boolean isCompatibleWith(CompatibilityInfo other) {
            String otherLoader;
            if (!this.minecraftVersion.equals(other.minecraftVersion)) {
                return false;
            }
            String thisLoader = this.modLoader != null ? this.modLoader : "vanilla";
            String string = otherLoader = other.modLoader != null ? other.modLoader : "vanilla";
            if (!thisLoader.equals(otherLoader)) {
                return false;
            }
            if (this.modpackId != null && other.modpackId != null) {
                if (!this.modpackId.equals(other.modpackId)) {
                    return false;
                }
                if (this.modpackVersion != null && other.modpackVersion != null && !this.modpackVersion.equals(other.modpackVersion)) {
                    return false;
                }
            }
            return true;
        }
    }
}

