/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.util;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class SafeDisconnect {
    public static boolean isInWorldOrServer() {
        class_310 minecraft = class_310.method_1551();
        return minecraft.field_1687 != null || minecraft.field_1724 != null;
    }

    public static boolean isInMultiplayer() {
        class_310 minecraft = class_310.method_1551();
        return minecraft.method_1558() != null;
    }

    public static boolean isInSingleplayer() {
        class_310 minecraft = class_310.method_1551();
        return minecraft.field_1687 != null && minecraft.method_1558() == null && minecraft.method_1496();
    }

    public static boolean disconnect(class_437 returnScreen) {
        class_310 minecraft = class_310.method_1551();
        if (!SafeDisconnect.isInWorldOrServer()) {
            System.out.println("[Tunnely SafeDisconnect] Not in world or server, no disconnect needed");
            return false;
        }
        System.out.println("[Tunnely SafeDisconnect] Disconnecting from current world/server...");
        if (SafeDisconnect.isInSingleplayer()) {
            System.out.println("[Tunnely SafeDisconnect] In singleplayer world - saving and exiting");
            minecraft.field_1687.method_8525((class_2561)class_2561.method_43470((String)"Disconnecting"));
            minecraft.method_52703((class_437)new class_442());
        } else if (SafeDisconnect.isInMultiplayer()) {
            System.out.println("[Tunnely SafeDisconnect] In multiplayer server - disconnecting");
            minecraft.field_1687.method_8525((class_2561)class_2561.method_43470((String)"Disconnecting"));
            minecraft.method_52703((class_437)new class_442());
        } else {
            System.out.println("[Tunnely SafeDisconnect] Unknown state - clearing level");
            minecraft.method_52703((class_437)new class_442());
        }
        return true;
    }

    public static void disconnectAndThen(Runnable callback) {
        class_310 minecraft = class_310.method_1551();
        if (!SafeDisconnect.isInWorldOrServer()) {
            System.out.println("[Tunnely SafeDisconnect] Not in world, running callback immediately");
            callback.run();
            return;
        }
        System.out.println("[Tunnely SafeDisconnect] Disconnecting, will run callback after disconnect");
        boolean disconnected = SafeDisconnect.disconnect(null);
        if (disconnected) {
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    minecraft.execute(callback);
                    System.out.println("[Tunnely SafeDisconnect] Callback executed after disconnect");
                }
                catch (InterruptedException e) {
                    System.err.println("[Tunnely SafeDisconnect] Error waiting for disconnect: " + e.getMessage());
                    e.printStackTrace();
                }
            }, "Tunnely-SafeDisconnect").start();
        } else {
            callback.run();
        }
    }

    public static String getConnectionStateDescription() {
        if (SafeDisconnect.isInSingleplayer()) {
            return "singleplayer world";
        }
        if (SafeDisconnect.isInMultiplayer()) {
            return "multiplayer server";
        }
        if (SafeDisconnect.isInWorldOrServer()) {
            return "world";
        }
        return "none";
    }
}

