/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class InviteFriendsScreen
extends Screen {
    private final Screen parent;
    private final String serverId;
    private FriendListWidget friendList;
    private String statusMessage = "\u00a7eLoading friends...";
    private int statusColor = 0xFFFF00;

    public InviteFriendsScreen(Screen parent, String serverId) {
        super((Component)Component.m_237113_((String)"Invite Friends"));
        this.parent = parent;
        this.serverId = serverId;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.friendList = new FriendListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 50, this.f_96544_ - 60, 35);
        this.m_7787_((GuiEventListener)this.friendList);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 50, 100, 20, (Component)Component.m_237113_((String)"Refresh"), button -> this.loadFriends()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 55, this.f_96544_ - 50, 100, 20, (Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)));
        this.loadFriends();
    }

    private void loadFriends() {
        System.out.println("[Tunnely UI] ===== LOADING FRIENDS FOR INVITE =====");
        this.statusMessage = "\u00a7eLoading friends...";
        this.statusColor = 0xFFFF00;
        this.friendList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.FriendListResult result = client.getFriends();
                this.f_96541_.execute(() -> {
                    block13: {
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing friends for invite...");
                                JsonArray friends = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + friends.size() + " total friend(s)");
                                int acceptedCount = 0;
                                if (friends.size() == 0) {
                                    this.statusMessage = "\u00a77No friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                    break block13;
                                }
                                for (JsonElement element : friends) {
                                    JsonObject friend = element.getAsJsonObject();
                                    if (!friend.has("status") || !friend.get("status").getAsString().equals("accepted")) continue;
                                    String minecraftName = "Unknown";
                                    String friendEmail = "unknown@example.com";
                                    if (friend.has("friend") && !friend.get("friend").isJsonNull()) {
                                        JsonObject friendProfile = friend.getAsJsonObject("friend");
                                        if (friendProfile.has("minecraft_name")) {
                                            minecraftName = friendProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (friend.has("friend_name")) {
                                        minecraftName = friend.get("friend_name").getAsString();
                                    }
                                    if (friend.has("friend_email")) {
                                        friendEmail = friend.get("friend_email").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Available to invite: " + minecraftName);
                                    this.friendList.addFriend(friendEmail, minecraftName);
                                    ++acceptedCount;
                                }
                                if (acceptedCount == 0) {
                                    this.statusMessage = "\u00a77No accepted friends to invite";
                                    this.statusColor = 0xAAAAAA;
                                } else {
                                    this.statusMessage = "\u00a7aSelect friends to invite";
                                    this.statusColor = 65280;
                                }
                                System.out.println("[Tunnely UI] " + acceptedCount + " accepted friend(s) available");
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse friends";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing friends: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load friends: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading friends: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadFriendsInvite").start();
    }

    private void inviteFriend(String friendEmail, String friendName) {
        System.out.println("[Tunnely UI] ===== INVITING FRIEND =====");
        System.out.println("[Tunnely UI] Friend: " + friendName + " (" + friendEmail + ")");
        System.out.println("[Tunnely UI] Server ID: " + this.serverId);
        this.statusMessage = "\u00a7eSending invite to " + friendName + "...";
        this.statusColor = 0xFFFF00;
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                boolean success = client.sendInvite(this.serverId, friendEmail);
                this.f_96541_.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aInvite sent to " + friendName + "!";
                        this.statusColor = 65280;
                        System.out.println("[Tunnely UI] \u2713 Invite sent successfully");
                    } else {
                        this.statusMessage = "\u00a7cFailed to send invite";
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to send invite");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception sending invite: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-SendInvite").start();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.friendList.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        InviteFriendsScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a76\u00a7lInvite Friends to Server", (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        InviteFriendsScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.statusMessage, (int)(this.f_96543_ / 2), (int)35, (int)this.statusColor);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class FriendListWidget
    extends ObjectSelectionList<FriendEntry> {
        public FriendListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.m_93516_();
        }

        public void addFriend(String email, String name) {
            this.m_7085_((AbstractSelectionList.Entry)new FriendEntry(email, name));
        }

        class FriendEntry
        extends ObjectSelectionList.Entry<FriendEntry> {
            private final String email;
            private final String name;
            private final Button inviteButton;

            public FriendEntry(String email, String name) {
                this.email = email;
                this.name = name;
                this.inviteButton = new Button(0, 0, 60, 20, (Component)Component.m_237113_((String)"Invite"), button -> InviteFriendsScreen.this.inviteFriend(email, name));
            }

            public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)InviteFriendsScreen.this.f_96547_, (String)("\u00a7b" + this.name), (int)(left + 5), (int)(top + 8), (int)0xFFFFFF);
                this.inviteButton.f_93620_ = left + width - 70;
                this.inviteButton.f_93621_ = top + 7;
                this.inviteButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.inviteButton.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.name);
            }
        }
    }
}

