/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.messaging;

import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.MessageEncryption;

public class EncryptionKeyManager {
    private static final Map<String, String> publicKeyCache = new ConcurrentHashMap<String, String>();
    private static volatile boolean keysInitialized = false;

    public static boolean initializeKeys() {
        if (keysInitialized) {
            return true;
        }
        boolean result = EncryptionKeyManager.ensureKeysExist();
        if (result) {
            keysInitialized = true;
            System.out.println("[Tunnely E2EE] \u2713 Encryption system initialized");
        }
        return result;
    }

    private static boolean ensureKeysExist() {
        TunnelConfig config = TunnelConfig.getInstance();
        if (config.hasEncryptionKeys()) {
            System.out.println("[Tunnely E2EE] Keys already exist");
            return true;
        }
        System.out.println("[Tunnely E2EE] Generating new encryption keys...");
        try {
            KeyPair keyPair = MessageEncryption.generateKeyPair();
            String publicKeyStr = MessageEncryption.publicKeyToString(keyPair.getPublic());
            String privateKeyStr = MessageEncryption.privateKeyToString(keyPair.getPrivate());
            config.setPublicKey(publicKeyStr);
            config.setEncryptedPrivateKey(privateKeyStr);
            System.out.println("[Tunnely E2EE] \u2713 Keys generated and stored locally");
            SupabaseClient client = new SupabaseClient();
            boolean uploaded = client.uploadPublicKey(publicKeyStr);
            if (uploaded) {
                System.out.println("[Tunnely E2EE] \u2713 Public key uploaded to database");
                return true;
            }
            System.err.println("[Tunnely E2EE] \u2717 Failed to upload public key");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] \u2717 Failed to generate keys: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static String getPrivateKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String privateKey = config.getEncryptedPrivateKey();
        if (privateKey.isEmpty()) {
            return null;
        }
        return privateKey;
    }

    public static String getPublicKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String publicKey = config.getPublicKey();
        return publicKey.isEmpty() ? null : publicKey;
    }

    public static String fetchRecipientPublicKey(String recipientId, boolean forceRefresh) {
        String cachedKey;
        if (recipientId == null || recipientId.isEmpty()) {
            System.err.println("[Tunnely E2EE] Invalid recipient ID");
            return null;
        }
        if (!forceRefresh && publicKeyCache.containsKey(recipientId) && (cachedKey = publicKeyCache.get(recipientId)) != null && !cachedKey.isEmpty()) {
            System.out.println("[Tunnely E2EE] Using cached public key for: " + recipientId.substring(0, 8) + "...");
            return cachedKey;
        }
        System.out.println("[Tunnely E2EE] Fetching public key for: " + recipientId.substring(0, 8) + "...");
        SupabaseClient client = new SupabaseClient();
        String publicKey = client.fetchPublicKey(recipientId);
        if (publicKey != null && !publicKey.isEmpty()) {
            publicKeyCache.put(recipientId, publicKey);
            System.out.println("[Tunnely E2EE] \u2713 Public key cached for recipient");
        } else {
            System.out.println("[Tunnely E2EE] \u26a0 Recipient has no public key (encryption not enabled)");
            publicKeyCache.put(recipientId, null);
        }
        return publicKey;
    }

    public static String fetchRecipientPublicKey(String recipientId) {
        return EncryptionKeyManager.fetchRecipientPublicKey(recipientId, false);
    }

    public static void clearCachedPublicKey(String recipientId) {
        publicKeyCache.remove(recipientId);
        System.out.println("[Tunnely E2EE] Cleared cached key for: " + recipientId.substring(0, 8) + "...");
    }

    public static void clearAllCachedKeys() {
        publicKeyCache.clear();
        System.out.println("[Tunnely E2EE] Cleared all cached public keys");
    }

    public static SyncResult synchronizeKeysWithFriend(String friendId) {
        System.out.println("[Tunnely E2EE] === Synchronizing Keys with Friend ===");
        if (!EncryptionKeyManager.ensureKeysExist()) {
            return new SyncResult(false, "Failed to generate your encryption keys", null);
        }
        String friendPublicKey = EncryptionKeyManager.fetchRecipientPublicKey(friendId, true);
        if (friendPublicKey == null || friendPublicKey.isEmpty()) {
            return new SyncResult(false, "Friend has not enabled encryption yet", null);
        }
        try {
            MessageEncryption.stringToPublicKey(friendPublicKey);
            System.out.println("[Tunnely E2EE] \u2713 Friend's public key is valid");
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] \u2717 Friend's public key is invalid: " + e.getMessage());
            EncryptionKeyManager.clearCachedPublicKey(friendId);
            return new SyncResult(false, "Friend's encryption key is corrupted", null);
        }
        try {
            String testMessage = "test_sync_" + System.currentTimeMillis();
            String ourPublicKey = EncryptionKeyManager.getPublicKey();
            String ourPrivateKey = EncryptionKeyManager.getPrivateKey();
            if (ourPublicKey == null || ourPrivateKey == null) {
                return new SyncResult(false, "Your encryption keys are missing", null);
            }
            String encrypted = MessageEncryption.encryptWithKey(testMessage, ourPublicKey);
            String decrypted = MessageEncryption.decryptWithKey(encrypted, ourPrivateKey);
            if (!testMessage.equals(decrypted)) {
                return new SyncResult(false, "Your encryption keys are corrupted", null);
            }
            System.out.println("[Tunnely E2EE] \u2713 Self-test passed");
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] \u2717 Self-test failed: " + e.getMessage());
            return new SyncResult(false, "Your encryption keys are corrupted", null);
        }
        System.out.println("[Tunnely E2EE] \u2713 Keys synchronized successfully");
        return new SyncResult(true, "Encryption ready", friendPublicKey);
    }

    public static EncryptionResult encryptMessage(String message, String recipientId) {
        try {
            String recipientPublicKey = EncryptionKeyManager.fetchRecipientPublicKey(recipientId);
            if (recipientPublicKey == null || recipientPublicKey.isEmpty()) {
                System.err.println("[Tunnely E2EE] Recipient has no public key");
                return new EncryptionResult(null, false, "Recipient has not enabled encryption");
            }
            try {
                MessageEncryption.stringToPublicKey(recipientPublicKey);
            }
            catch (Exception e) {
                System.err.println("[Tunnely E2EE] Recipient's public key is invalid");
                EncryptionKeyManager.clearCachedPublicKey(recipientId);
                return new EncryptionResult(null, false, "Recipient's encryption key is invalid");
            }
            String encrypted = MessageEncryption.encryptWithKey(message, recipientPublicKey);
            System.out.println("[Tunnely E2EE] \u2713 Message encrypted (" + encrypted.length() + " bytes)");
            return new EncryptionResult(encrypted, true, null);
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Encryption failed: " + e.getMessage());
            e.printStackTrace();
            return new EncryptionResult(null, false, "Encryption error: " + e.getMessage());
        }
    }

    public static String decryptMessage(String encryptedMessage) {
        try {
            if (!MessageEncryption.isEncrypted(encryptedMessage)) {
                return encryptedMessage;
            }
            String privateKey = EncryptionKeyManager.getPrivateKey();
            if (privateKey == null || privateKey.isEmpty()) {
                System.err.println("[Tunnely E2EE] Cannot decrypt: no private key available");
                return "[\ud83d\udd12 Encrypted - No keys]";
            }
            String decrypted = MessageEncryption.decryptWithKey(encryptedMessage, privateKey);
            return decrypted;
        }
        catch (BadPaddingException e) {
            System.err.println("[Tunnely E2EE] Decryption failed: Message encrypted with different key");
            return "[\ud83d\udd12 Encrypted - Wrong key]";
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Decryption error: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return "[\ud83d\udd12 Encrypted - Error]";
        }
    }

    public static boolean verifyAndRepairPublicKey() {
        TunnelConfig config = TunnelConfig.getInstance();
        String userId = config.getSupabaseUserId();
        if (userId == null || userId.isEmpty()) {
            System.err.println("[Tunnely E2EE] Cannot verify public key: not authenticated");
            return false;
        }
        try {
            SupabaseClient client = new SupabaseClient();
            String dbPublicKey = client.fetchPublicKey(userId);
            if (dbPublicKey != null && !dbPublicKey.isEmpty()) {
                System.out.println("[Tunnely E2EE] \u2713 Public key verified in database");
                return true;
            }
            System.out.println("[Tunnely E2EE] \u26a0 Public key missing from database");
            if (config.hasEncryptionKeys()) {
                String localPublicKey = config.getPublicKey();
                System.out.println("[Tunnely E2EE] Re-uploading existing local public key...");
                boolean uploaded = client.uploadPublicKey(localPublicKey);
                if (uploaded) {
                    System.out.println("[Tunnely E2EE] \u2713 Public key re-uploaded to database");
                    return true;
                }
                System.err.println("[Tunnely E2EE] \u2717 Failed to re-upload public key");
                return false;
            }
            System.out.println("[Tunnely E2EE] Generating new encryption keys...");
            return EncryptionKeyManager.ensureKeysExist();
        }
        catch (Exception e) {
            System.err.println("[Tunnely E2EE] Error verifying public key: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void reset() {
        publicKeyCache.clear();
        keysInitialized = false;
        System.out.println("[Tunnely E2EE] Encryption manager reset");
    }

    public static class SyncResult {
        public final boolean success;
        public final String message;
        public final String friendPublicKey;

        public SyncResult(boolean success, String message, String friendPublicKey) {
            this.success = success;
            this.message = message;
            this.friendPublicKey = friendPublicKey;
        }
    }

    public static class EncryptionResult {
        public final String encryptedMessage;
        public final boolean success;
        public final String errorMessage;

        public EncryptionResult(String encryptedMessage, boolean success, String errorMessage) {
            this.encryptedMessage = encryptedMessage;
            this.success = success;
            this.errorMessage = errorMessage;
        }
    }
}

