/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;

public class HeartbeatManager {
    private static final int HEARTBEAT_INTERVAL_SECONDS = 30;
    private static final int INITIAL_DELAY_SECONDS = 5;
    private final String serverId;
    private final MinecraftServer minecraftServer;
    private final SupabaseClient supabaseClient;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> heartbeatTask;
    private volatile boolean running = false;

    public HeartbeatManager(String serverId, MinecraftServer minecraftServer) {
        this.serverId = serverId;
        this.minecraftServer = minecraftServer;
        this.supabaseClient = new SupabaseClient();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "Tunnely-Heartbeat");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void start() {
        if (this.running) {
            System.out.println("[Tunnely Heartbeat] Already running for server: " + this.serverId);
            return;
        }
        System.out.println("[Tunnely Heartbeat] Starting heartbeat for server: " + this.serverId);
        System.out.println("[Tunnely Heartbeat] Interval: 30s");
        this.running = true;
        this.heartbeatTask = this.scheduler.scheduleAtFixedRate(this::sendHeartbeat, 5L, 30L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        System.out.println("[Tunnely Heartbeat] Stopping heartbeat for server: " + this.serverId);
        this.running = false;
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel(false);
            this.heartbeatTask = null;
        }
        this.markServerInactive();
    }

    public void shutdown() {
        this.stop();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void sendHeartbeat() {
        try {
            int currentPlayers = this.minecraftServer.m_7416_();
            int maxPlayers = this.minecraftServer.m_7418_();
            System.out.println("[Tunnely Heartbeat] Sending heartbeat for server: " + this.serverId + " (" + currentPlayers + "/" + maxPlayers + " players)");
            boolean success = this.supabaseClient.updateServerHeartbeat(this.serverId, currentPlayers, maxPlayers);
            if (success) {
                System.out.println("[Tunnely Heartbeat] \u2713 Heartbeat sent successfully");
            } else {
                System.err.println("[Tunnely Heartbeat] \u2717 Failed to send heartbeat");
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Heartbeat] \u2717 Error sending heartbeat: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void markServerInactive() {
        try {
            System.out.println("[Tunnely Heartbeat] Marking server as inactive: " + this.serverId);
            boolean success = this.supabaseClient.markServerInactive(this.serverId);
            if (success) {
                System.out.println("[Tunnely Heartbeat] \u2713 Server marked as inactive");
            } else {
                System.err.println("[Tunnely Heartbeat] \u2717 Failed to mark server as inactive");
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely Heartbeat] \u2717 Error marking server inactive: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getServerId() {
        return this.serverId;
    }
}

