/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

public enum PortForwardError {
    PORT_IN_USE("Port is already in use", "Close any applications using this port or choose a different port."),
    PERMISSION_DENIED("Permission denied", "Some ports require administrator privileges. Try running as administrator."),
    PORT_CONFLICT("Port conflict detected", "Multiple services are trying to use the same port. Disable one of them."),
    INVALID_PORT("Invalid port number", "Port must be between 1024 and 65535."),
    SOCKET_CREATION_FAILED("Failed to create network socket", "Check your network settings and firewall configuration."),
    RELAY_UNAVAILABLE("Relay server does not support this port", "The relay server may not support UDP forwarding or the specific port requested."),
    RATE_LIMITED("Too many port forward requests", "Wait 60 seconds before trying again."),
    NETWORK_UNREACHABLE("Network is unreachable", "Check your internet connection and try again."),
    TIMEOUT("Port forwarding request timed out", "The relay server took too long to respond. Try again."),
    UNKNOWN("Unknown error occurred", "Check the console logs for more details.");

    private final String message;
    private final String solution;

    private PortForwardError(String message, String solution) {
        this.message = message;
        this.solution = solution;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getFullMessage() {
        return this.message + ". " + this.solution;
    }

    public String toString() {
        return this.getFullMessage();
    }

    public static PortForwardError fromException(Exception e) {
        String msg = e.getMessage().toLowerCase();
        if (msg.contains("address already in use") || msg.contains("bind failed")) {
            return PORT_IN_USE;
        }
        if (msg.contains("permission denied") || msg.contains("access is denied")) {
            return PERMISSION_DENIED;
        }
        if (msg.contains("network is unreachable") || msg.contains("no route to host")) {
            return NETWORK_UNREACHABLE;
        }
        if (msg.contains("timeout") || msg.contains("timed out")) {
            return TIMEOUT;
        }
        return UNKNOWN;
    }
}

