/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.worlds.DownloadState;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class DownloadProgressScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private final WorldInfo world;
    private final Path stateFile;
    private Timer progressTimer;
    private String statusMessage = "Starting download...";
    private int downloadProgress = 0;
    private String downloadedBytes = "0 B";
    private String totalBytes = "0 B";
    private String speed = "0 B/s";
    private boolean isPaused = false;
    private boolean isCompleted = false;
    private boolean isCancelled = false;
    private boolean isExtracting = false;
    private Button pauseButton;
    private Button cancelButton;
    private BandwidthSlider bandwidthSlider;

    public DownloadProgressScreen(Screen parent, WorldInfo world) {
        super((Component)Component.m_237113_((String)"Downloading World"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
        this.stateFile = null;
    }

    public DownloadProgressScreen(Screen parent, WorldManager worldManager, Path stateFile) {
        super((Component)Component.m_237113_((String)"Resuming Download"));
        this.parent = parent;
        this.worldManager = worldManager;
        this.world = null;
        this.stateFile = stateFile;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.pauseButton = Button.m_253074_((Component)Component.m_237113_((String)"\u23f8 Pause"), button -> this.togglePause()).m_252987_(centerX - 105, centerY + 50, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.pauseButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2716 Cancel"), button -> this.cancelDownload()).m_252987_(centerX + 5, centerY + 50, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.bandwidthSlider = new BandwidthSlider(centerX - 150, centerY + 90, 300, 20);
        this.m_142416_((GuiEventListener)this.bandwidthSlider);
        int presetY = centerY + 120;
        int presetX = centerX - 165;
        this.addPresetButton(presetX, presetY, "Unlimited", 0L);
        this.addPresetButton(presetX + 70, presetY, "100 KB/s", 102400L);
        this.addPresetButton(presetX + 140, presetY, "500 KB/s", 512000L);
        this.addPresetButton(presetX + 210, presetY, "1 MB/s", 0x100000L);
        this.addPresetButton(presetX + 280, presetY, "2 MB/s", 0x200000L);
        this.startDownload();
    }

    private void addPresetButton(int x, int y, String label, long bytesPerSecond) {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)label), button -> this.setBandwidthLimit(bytesPerSecond)).m_252987_(x, y, 65, 18).m_253136_());
    }

    private void setBandwidthLimit(long bytesPerSecond) {
        this.worldManager.setBandwidthLimit(bytesPerSecond);
        this.bandwidthSlider.updateFromConfig();
        this.statusMessage = "Bandwidth limit set to: " + this.formatBytesPerSecond(bytesPerSecond);
    }

    private void startDownload() {
        this.startProgressMonitoring();
        new Thread(() -> {
            try {
                WorldManager.DownloadResult result;
                if (this.stateFile != null) {
                    this.statusMessage = "Resuming download...";
                    result = this.worldManager.resumePausedDownload(this.stateFile, Paths.get("saves", new String[0]), this::onProgress);
                } else {
                    this.statusMessage = "Starting download...";
                    result = this.worldManager.downloadWorldResumable(this.world.getId(), Paths.get("saves", new String[0]), this::onProgress);
                }
                this.f_96541_.execute(() -> {
                    this.stopProgressMonitoring();
                    if (result.isSuccess()) {
                        this.isCompleted = true;
                        this.statusMessage = "\u00a7a\u2713 Download complete! World saved to: " + result.getWorldFolderName();
                        this.downloadProgress = 100;
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                DownloadProgressScreen.this.f_96541_.execute(() -> {
                                    if (!DownloadProgressScreen.this.isCancelled) {
                                        DownloadProgressScreen.this.f_96541_.m_91152_(DownloadProgressScreen.this.parent);
                                    }
                                });
                            }
                        }, 3000L);
                    } else {
                        this.statusMessage = result.getMessage().contains("paused") ? "\u00a7eDownload paused. You can resume it later from the Downloads menu." : "\u00a7c\u2717 " + result.getMessage();
                    }
                });
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> {
                    this.stopProgressMonitoring();
                    this.statusMessage = "\u00a7cDownload failed: " + e.getMessage();
                    e.printStackTrace();
                });
            }
        }).start();
    }

    private void onProgress(int percentage, String message) {
        this.f_96541_.execute(() -> {
            this.downloadProgress = percentage;
            if (message.contains("Extracting")) {
                this.isExtracting = true;
                this.statusMessage = message;
            } else if (!this.isExtracting) {
                this.statusMessage = message;
            }
        });
    }

    private void startProgressMonitoring() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DownloadState state = DownloadProgressScreen.this.worldManager.getCurrentDownloadState();
                if (state != null) {
                    DownloadProgressScreen.this.f_96541_.execute(() -> {
                        DownloadProgressScreen.this.downloadedBytes = state.getDownloadedBytesFormatted();
                        DownloadProgressScreen.this.totalBytes = state.getTotalBytesFormatted();
                        DownloadProgressScreen.this.speed = DownloadProgressScreen.this.formatBytesPerSecond(state.getDownloadSpeed());
                        DownloadProgressScreen.this.isPaused = state.isPaused();
                        if (DownloadProgressScreen.this.pauseButton != null) {
                            DownloadProgressScreen.this.pauseButton.m_93666_((Component)Component.m_237113_((String)(DownloadProgressScreen.this.isPaused ? "\u25b6 Resume" : "\u23f8 Pause")));
                        }
                    });
                }
            }
        }, 0L, 500L);
    }

    private void stopProgressMonitoring() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
    }

    private void togglePause() {
        if (this.isExtracting) {
            this.statusMessage = "\u00a7cCannot pause during extraction";
            return;
        }
        if (this.isCompleted || this.isCancelled) {
            return;
        }
        if (this.isPaused) {
            this.statusMessage = "\u00a7ePlease use the Downloads menu to resume";
        } else {
            this.worldManager.pauseCurrentDownload();
            this.isPaused = true;
            this.statusMessage = "\u00a7ePausing download...";
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    DownloadProgressScreen.this.f_96541_.execute(() -> {
                        DownloadProgressScreen.this.stopProgressMonitoring();
                        DownloadProgressScreen.this.f_96541_.m_91152_(DownloadProgressScreen.this.parent);
                    });
                }
            }, 1000L);
        }
    }

    private void cancelDownload() {
        if (this.isCompleted) {
            this.f_96541_.m_91152_(this.parent);
            return;
        }
        int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to cancel this download?", "Cancel Download", 0);
        if (choice == 0) {
            this.worldManager.cancelCurrentDownload();
            this.isCancelled = true;
            this.stopProgressMonitoring();
            this.statusMessage = "\u00a7cDownload cancelled";
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        String title = this.world != null ? "Downloading: " + this.world.getName() : "Resuming Download";
        graphics.m_280137_(this.f_96547_, title, centerX, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, this.statusMessage, centerX, centerY - 80, 0xFFFFFF);
        int barWidth = 300;
        int barHeight = 30;
        int barX = centerX - barWidth / 2;
        int barY = centerY - 50;
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, Integer.MIN_VALUE);
        int fillWidth = barWidth * this.downloadProgress / 100;
        int fillColor = this.isCompleted ? -2147418368 : (this.isPaused ? -2130729728 : -2141847723);
        graphics.m_280509_(barX, barY, barX + fillWidth, barY + barHeight, fillColor);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + 2, -12566464);
        graphics.m_280509_(barX, barY + barHeight - 2, barX + barWidth, barY + barHeight, -12566464);
        graphics.m_280509_(barX, barY, barX + 2, barY + barHeight, -12566464);
        graphics.m_280509_(barX + barWidth - 2, barY, barX + barWidth, barY + barHeight, -12566464);
        String progressText = this.downloadProgress + "%";
        graphics.m_280137_(this.f_96547_, progressText, centerX, barY + 10, 0xFFFFFF);
        String bytesInfo = this.downloadedBytes + " / " + this.totalBytes;
        graphics.m_280137_(this.f_96547_, bytesInfo, centerX, centerY - 15, 0xAAAAAA);
        if (!this.isCompleted && !this.isPaused) {
            graphics.m_280137_(this.f_96547_, "Speed: " + this.speed, centerX, centerY, 0xAAAAAA);
        } else if (this.isPaused) {
            graphics.m_280137_(this.f_96547_, "\u00a7ePaused", centerX, centerY, 0xFFAA00);
        }
        graphics.m_280137_(this.f_96547_, "Download Speed Limit", centerX, centerY + 75, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        long currentLimit = this.worldManager.getBandwidthLimit();
        String limitText = currentLimit == 0L ? "Unlimited" : this.formatBytesPerSecond(currentLimit);
        graphics.m_280137_(this.f_96547_, "\u00a77" + limitText, centerX, centerY + 113, 0xAAAAAA);
    }

    public void m_7861_() {
        this.stopProgressMonitoring();
        super.m_7861_();
    }

    public boolean m_6913_() {
        return this.isCompleted || this.isCancelled;
    }

    private String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond == 0L) {
            return "Unlimited";
        }
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    private class BandwidthSlider
    extends AbstractSliderButton {
        private static final long MAX_LIMIT = 0xA00000L;

        public BandwidthSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.updateFromConfig();
            this.m_5695_();
        }

        public void updateFromConfig() {
            long currentLimit = DownloadProgressScreen.this.worldManager.getBandwidthLimit();
            this.f_93577_ = currentLimit == 0L ? 0.0 : Math.min(1.0, (double)currentLimit / 1.048576E7);
            this.m_5695_();
        }

        protected void m_5695_() {
            long limit = (long)(this.f_93577_ * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            this.m_93666_((Component)Component.m_237113_((String)DownloadProgressScreen.this.formatBytesPerSecond(limit)));
        }

        protected void m_5697_() {
            long limit = (long)(this.f_93577_ * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            DownloadProgressScreen.this.worldManager.setBandwidthLimit(limit);
        }
    }
}

