/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.tunnelyrefab.config.PortForwardingConfig;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.security.RelayValidator;
import org.texboobcat.tunnelyrefab.tunnel.ModDetector;
import org.texboobcat.tunnelyrefab.tunnel.TunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.InviteFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.ContentModerator;

public class HostGameScreen
extends Screen {
    private final Screen parent;
    private final TunnelManager manager;
    private EditBox serverNameBox;
    private EditBox maxPlayersBox;
    private Button visibilityButton;
    private Button toggleVisibilityButton;
    private Button onlineModeButton;
    private Button gamemodeButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private String selectedVisibility = "invite_only";
    private String currentServerVisibility = "invite_only";
    private int warningIconX = 0;
    private int warningIconY = 0;
    private boolean showWarningTooltip = false;
    private int centerX = 0;
    private int buttonWidth = 200;
    private int buttonHeight = 20;
    private List<PortForwardingConfig> availablePortForwards = new ArrayList<PortForwardingConfig>();
    private Map<PortForwardingConfig, Checkbox> portForwardCheckboxes = new HashMap<PortForwardingConfig, Checkbox>();
    private final List<AbstractWidget> scrollWidgets = new ArrayList<AbstractWidget>();
    private final Map<AbstractWidget, Integer> widgetBaseY = new HashMap<AbstractWidget, Integer>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int scrollTop;
    private int scrollBottom;
    private int scrollLeft;
    private int scrollRight;
    private int contentHeight = 0;
    private boolean draggingScrollbar = false;
    private int dragStartMouseY = 0;
    private int dragStartScrollOffset = 0;
    private int labelServerNameY;
    private int labelMaxPlayersY;
    private int labelVisibilityY;
    private int visibilityDescY;
    private int labelOnlineModeY;
    private int labelGamemodeY;
    private int portSectionLabelY;
    private int portSectionDescY;

    public HostGameScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Host Game"));
        this.parent = parent;
        this.manager = TunnelManager.getInstance();
    }

    protected void m_7856_() {
        boolean inSingleplayer;
        super.m_7856_();
        if (this.availablePortForwards.isEmpty()) {
            this.availablePortForwards = ModDetector.detectInstalledMods();
        }
        this.buttonWidth = 200;
        this.buttonHeight = 20;
        this.centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        boolean bl = inSingleplayer = this.f_96541_.m_91092_() != null;
        if (!inSingleplayer) {
            int y = 80;
            ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u26a0 Not In World"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$0(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).m_252987_((int)this.centerX, (int)y, (int)this.buttonWidth, (int)this.buttonHeight).m_253136_())).f_93623_ = false;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.centerX, this.f_96544_ - 30, this.buttonWidth, this.buttonHeight).m_253136_());
            this.statusMessage = "\u00a7cYou must be in a world to host!";
            this.statusColor = 0xFF5555;
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            int y = 80;
            if (status.publicEndpoint != null) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Copy Endpoint"), button -> this.copyToClipboard(status.publicEndpoint)).m_252987_(this.centerX, y, this.buttonWidth, this.buttonHeight).m_253136_());
                y += 30;
            }
            this.toggleVisibilityButton = Button.m_253074_((Component)this.getActiveVisibilityButtonText(), button -> {
                this.cycleActiveVisibility();
                this.toggleVisibilityButton.m_93666_(this.getActiveVisibilityButtonText());
            }).m_252987_(this.centerX, y, this.buttonWidth, this.buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.toggleVisibilityButton);
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Invite Friends"), button -> this.f_96541_.m_91152_((Screen)new InviteFriendsScreen(this, status.sessionId))).m_252987_(this.centerX, y += 30, this.buttonWidth, this.buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cStop Hosting"), button -> this.stopTunnel()).m_252987_(this.centerX, y += 40, this.buttonWidth, this.buttonHeight).m_253136_());
        } else {
            this.scrollTop = 60;
            this.scrollBottom = this.f_96544_ - 80;
            this.scrollLeft = this.centerX;
            this.scrollRight = this.centerX + this.buttonWidth;
            this.scrollOffset = 0;
            this.scrollWidgets.clear();
            this.widgetBaseY.clear();
            this.contentHeight = 0;
            int contentY = this.scrollTop;
            this.labelServerNameY = contentY - 12;
            this.serverNameBox = new EditBox(this.f_96547_, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (Component)Component.m_237113_((String)"Server Name"));
            this.serverNameBox.m_94199_(32);
            this.serverNameBox.m_257771_((Component)Component.m_237113_((String)"Enter server name..."));
            this.serverNameBox.m_94144_("Minecraft Server");
            this.m_142416_((GuiEventListener)this.serverNameBox);
            this.registerScrollableWidget((AbstractWidget)this.serverNameBox, contentY);
            this.labelMaxPlayersY = (contentY += 35) - 12;
            this.maxPlayersBox = new EditBox(this.f_96547_, this.centerX, contentY, this.buttonWidth, this.buttonHeight, (Component)Component.m_237113_((String)"Max Players"));
            this.maxPlayersBox.m_94199_(2);
            this.maxPlayersBox.m_257771_((Component)Component.m_237113_((String)"Max players (1-20)..."));
            this.maxPlayersBox.m_94144_(String.valueOf(TunnelConfig.getInstance().getMaxPlayers()));
            this.maxPlayersBox.m_94153_(text -> {
                if (text.isEmpty()) {
                    return true;
                }
                try {
                    int val = Integer.parseInt(text);
                    return val >= 1 && val <= 20;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.m_142416_((GuiEventListener)this.maxPlayersBox);
            this.registerScrollableWidget((AbstractWidget)this.maxPlayersBox, contentY);
            this.labelVisibilityY = (contentY += 35) - 12;
            this.visibilityButton = Button.m_253074_((Component)this.getVisibilityButtonText(), button -> {
                this.cycleVisibility();
                this.visibilityButton.m_93666_(this.getVisibilityButtonText());
            }).m_252987_(this.centerX, contentY, this.buttonWidth, this.buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.visibilityButton);
            this.registerScrollableWidget((AbstractWidget)this.visibilityButton, contentY);
            this.visibilityDescY = (contentY += 30) + 5;
            this.labelOnlineModeY = (contentY += 25) - 12;
            this.onlineModeButton = Button.m_253074_((Component)this.getOnlineModeButtonText(), button -> {
                this.toggleOnlineMode();
                this.onlineModeButton.m_93666_(this.getOnlineModeButtonText());
            }).m_252987_(this.centerX, contentY, this.buttonWidth, this.buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.onlineModeButton);
            this.registerScrollableWidget((AbstractWidget)this.onlineModeButton, contentY);
            this.labelGamemodeY = (contentY += 35) - 12;
            this.gamemodeButton = Button.m_253074_((Component)this.getGamemodeButtonText(), button -> {
                this.cycleGamemode();
                this.gamemodeButton.m_93666_(this.getGamemodeButtonText());
            }).m_252987_(this.centerX, contentY, this.buttonWidth, this.buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.gamemodeButton);
            this.registerScrollableWidget((AbstractWidget)this.gamemodeButton, contentY);
            contentY += 35;
            if (!this.availablePortForwards.isEmpty()) {
                this.portSectionLabelY = contentY;
                this.portSectionDescY = contentY + 12;
                contentY += 26;
                for (final PortForwardingConfig portConfig : this.availablePortForwards) {
                    boolean portAvailable = ModDetector.isPortAvailable(portConfig.getPort(), portConfig.getProtocol());
                    String label = portConfig.getServiceName() + " (" + portConfig.getShortDisplayString() + ")";
                    if (!portAvailable) {
                        label = label + " \u26a0";
                    }
                    Checkbox checkbox = new Checkbox(this.centerX, contentY, 200, 20, (Component)Component.m_237113_((String)label), portConfig.isEnabled()){

                        public void m_5691_() {
                            super.m_5691_();
                            portConfig.setEnabled(this.m_93840_());
                        }
                    };
                    if (!portAvailable) {
                        checkbox.f_93623_ = false;
                        portConfig.setEnabled(false);
                    }
                    this.m_142416_((GuiEventListener)checkbox);
                    this.portForwardCheckboxes.put(portConfig, checkbox);
                    this.registerScrollableWidget((AbstractWidget)checkbox, contentY);
                    contentY += 22;
                }
            }
            this.contentHeight = contentY - this.scrollTop;
            this.maxScroll = Math.max(0, this.contentHeight - (this.scrollBottom - this.scrollTop));
            this.layoutScrollWidgets();
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aStart Hosting"), button -> this.startTunnel()).m_252987_(this.centerX, this.f_96544_ - 60, this.buttonWidth, this.buttonHeight).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.centerX, this.f_96544_ - 30, this.buttonWidth, this.buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        if (TunnelConfig.getInstance().isOfflineMode() && this.warningIconX > 0 && this.warningIconY > 0) {
            int iconWidth = this.f_96547_.m_92895_("(!)");
            this.showWarningTooltip = mouseX >= this.warningIconX && mouseX <= this.warningIconX + iconWidth + 4 && mouseY >= this.warningIconY - 2 && mouseY <= this.warningIconY + 12;
        } else {
            this.showWarningTooltip = false;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFAA00);
        if (this.f_96541_.m_91092_() == null) {
            graphics.m_280137_(this.f_96547_, "\u00a7c\u26a0 Cannot Host Server", this.f_96543_ / 2, 40, 0xFF5555);
            graphics.m_280137_(this.f_96547_, "\u00a77You must be in a single-player world to host.", this.f_96543_ / 2, 60, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77Steps:", this.f_96543_ / 2, 80, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a771. Go back to the main menu", this.f_96543_ / 2, 95, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a772. Create a new world or load an existing one", this.f_96543_ / 2, 107, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a773. Open the menu and click 'Tunnely'", this.f_96543_ / 2, 119, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a774. Click 'Host Game' to start hosting", this.f_96543_ / 2, 131, 0xAAAAAA);
            if (!this.statusMessage.isEmpty()) {
                graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 50, this.statusColor);
            }
            return;
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.connected) {
            graphics.m_280137_(this.f_96547_, "\u00a7a\u2713 Server is Running", this.f_96543_ / 2, 40, 65280);
            if (status.publicEndpoint != null) {
                graphics.m_280137_(this.f_96547_, "\u00a7eEndpoint:", this.f_96543_ / 2, 55, 0xFFFFFF);
                String endpoint = status.publicEndpoint;
                int endpointWidth = this.f_96547_.m_92895_(endpoint);
                int boxX = this.f_96543_ / 2 - endpointWidth / 2 - 5;
                int boxY = 62;
                graphics.m_280509_(boxX, boxY, boxX + endpointWidth + 10, boxY + 12, Integer.MIN_VALUE);
                graphics.m_280137_(this.f_96547_, "\u00a7b" + endpoint, this.f_96543_ / 2, 65, 65535);
            }
            if (!this.availablePortForwards.isEmpty()) {
                int activeCount = 0;
                for (PortForwardingConfig portConfig : this.availablePortForwards) {
                    if (!portConfig.isEnabled()) continue;
                    ++activeCount;
                }
                if (activeCount > 0) {
                    int yOffset = 90;
                    graphics.m_280488_(this.f_96547_, "\u00a7eActive Services:", this.f_96543_ / 2 - 80, yOffset, 0xFFAA00);
                    yOffset += 15;
                    for (PortForwardingConfig portConfig : this.availablePortForwards) {
                        if (!portConfig.isEnabled()) continue;
                        graphics.m_280488_(this.f_96547_, "\u00a7a\u2713 " + portConfig.getDisplayString(), this.f_96543_ / 2 - 80, yOffset, 65280);
                        yOffset += 12;
                    }
                }
            }
        } else {
            int yGM;
            int yOM;
            int yDesc;
            int yV;
            int yMP;
            graphics.m_280137_(this.f_96547_, "\u00a77Configure Your Server", this.f_96543_ / 2, 40, 0xAAAAAA);
            try {
                graphics.m_280588_(this.scrollLeft, this.scrollTop, this.scrollRight, this.scrollBottom);
            }
            catch (Throwable activeCount) {
                // empty catch block
            }
            int labelX = this.f_96543_ / 2 - 100;
            int ySN = this.labelServerNameY - this.scrollOffset;
            if (ySN >= this.scrollTop - 12 && ySN <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "Server Name:", labelX, ySN, 0xFFFFFF);
            }
            if ((yMP = this.labelMaxPlayersY - this.scrollOffset) >= this.scrollTop - 12 && yMP <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "Max Players:", labelX, yMP, 0xFFFFFF);
            }
            if ((yV = this.labelVisibilityY - this.scrollOffset) >= this.scrollTop - 12 && yV <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "Visibility:", labelX, yV, 0xFFFFFF);
            }
            if ((yDesc = this.visibilityDescY - this.scrollOffset) >= this.scrollTop - 12 && yDesc <= this.scrollBottom) {
                String desc = this.getVisibilityDescription();
                graphics.m_280137_(this.f_96547_, "\u00a77" + desc, this.f_96543_ / 2, yDesc, 0xAAAAAA);
            }
            if ((yOM = this.labelOnlineModeY - this.scrollOffset) >= this.scrollTop - 12 && yOM <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "Authentication:", labelX, yOM, 0xFFFFFF);
                if (TunnelConfig.getInstance().isOfflineMode()) {
                    int buttonEndX = this.centerX + this.buttonWidth + 5;
                    int buttonCenterY = this.labelOnlineModeY + 12 - this.scrollOffset + 5;
                    this.warningIconX = buttonEndX;
                    this.warningIconY = buttonCenterY;
                } else {
                    this.warningIconX = 0;
                    this.warningIconY = 0;
                }
            }
            if ((yGM = this.labelGamemodeY - this.scrollOffset) >= this.scrollTop - 12 && yGM <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "Default Gamemode:", labelX, yGM, 0xFFFFFF);
            }
            if (!this.availablePortForwards.isEmpty()) {
                int yPortsHint;
                int yPortsDesc;
                int yPorts = this.portSectionLabelY - this.scrollOffset;
                if (yPorts >= this.scrollTop - 12 && yPorts <= this.scrollBottom) {
                    graphics.m_280488_(this.f_96547_, "\u00a7eAdditional Ports:", labelX, yPorts, 0xFFAA00);
                }
                if ((yPortsDesc = this.portSectionDescY - this.scrollOffset) >= this.scrollTop - 12 && yPortsDesc <= this.scrollBottom) {
                    graphics.m_280488_(this.f_96547_, "\u00a77Enable voice chat and other services", labelX, yPortsDesc, 0x888888);
                }
                if ((yPortsHint = this.portSectionDescY + 12 - this.scrollOffset) >= this.scrollTop - 12 && yPortsHint <= this.scrollBottom) {
                    graphics.m_280488_(this.f_96547_, "\u00a77\u26a0 = Port in use by another app", labelX, yPortsHint, 0x888888);
                }
            }
            try {
                graphics.m_280618_();
            }
            catch (Throwable yPorts) {
                // empty catch block
            }
            if (this.warningIconX > 0 && this.warningIconY > 0 && TunnelConfig.getInstance().isOfflineMode() && this.warningIconY >= this.scrollTop && this.warningIconY <= this.scrollBottom) {
                graphics.m_280488_(this.f_96547_, "\u00a7c(!)", this.warningIconX, this.warningIconY, 0xFF5555);
            }
            if (this.maxScroll > 0) {
                int trackX = this.getTrackX();
                int trackTop = this.scrollTop;
                int trackBottom = this.scrollBottom;
                int trackHeight = this.getTrackHeight();
                int thumbHeight = this.getThumbHeight(trackHeight);
                int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
                graphics.m_280509_(trackX, trackTop, trackX + 4, trackBottom, Integer.MIN_VALUE);
                graphics.m_280509_(trackX, thumbY, trackX + 4, thumbY + thumbHeight, -6250336);
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, this.f_96544_ - 50, this.statusColor);
        }
        if (this.showWarningTooltip && TunnelConfig.getInstance().isOfflineMode()) {
            String tooltipText = "We do not support piracy";
            int tooltipWidth = this.f_96547_.m_92895_(tooltipText) + 8;
            int tooltipHeight = 16;
            int tooltipX = this.warningIconX + 15;
            int tooltipY = this.warningIconY - 5;
            if (tooltipX + tooltipWidth > this.f_96543_) {
                tooltipX = this.f_96543_ - tooltipWidth - 5;
            }
            graphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -536870912);
            graphics.m_280509_(tooltipX - 1, tooltipY - 1, tooltipX + tooltipWidth + 1, tooltipY, -43691);
            graphics.m_280509_(tooltipX - 1, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -43691);
            graphics.m_280509_(tooltipX - 1, tooltipY, tooltipX, tooltipY + tooltipHeight, -43691);
            graphics.m_280509_(tooltipX + tooltipWidth, tooltipY, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, -43691);
            graphics.m_280488_(this.f_96547_, tooltipText, tooltipX + 4, tooltipY + 4, 0xFFFFFF);
        }
    }

    private void startTunnel() {
        if (this.f_96541_.m_91092_() == null) {
            this.statusMessage = "\u00a7cError: Not in a single-player world!";
            this.statusColor = 0xFF5555;
            return;
        }
        String serverName = this.serverNameBox != null ? this.serverNameBox.m_94155_().trim() : "Minecraft Server";
        ContentModerator.ValidationResult validation = ContentModerator.validateServerName(serverName);
        if (!validation.valid) {
            this.statusMessage = "\u00a7c" + validation.errorMessage;
            this.statusColor = 0xFF0000;
            return;
        }
        RelayValidator.RelaySecurityStatus securityStatus = RelayValidator.validateRelayConfig();
        if (!securityStatus.isTrusted()) {
            String relayUrl = TunnelConfig.getInstance().getRelayServerUrl();
            this.f_96541_.m_91152_((Screen)new WarningPopupScreen(this, this, "\u26a0\ufe0f Untrusted Relay Server", securityStatus.message + "\n\nRelay URL: " + relayUrl + "\n\nThe relay operator can see:\n\u2022 Your IP address and connection metadata\n\u2022 All game traffic (chat, coordinates, etc.)\n\nOnly continue if you trust the relay operator.\nOfficial relays: See documentation", 0xFF0000, this::startTunnelConfirmed));
            return;
        }
        this.startTunnelConfirmed();
    }

    private void startTunnelConfirmed() {
        String serverName = this.serverNameBox != null ? this.serverNameBox.m_94155_().trim() : "Minecraft Server";
        int maxPlayers = 8;
        if (this.maxPlayersBox != null && !this.maxPlayersBox.m_94155_().isEmpty()) {
            try {
                maxPlayers = Integer.parseInt(this.maxPlayersBox.m_94155_());
                if (maxPlayers < 1 || maxPlayers > 20) {
                    this.statusMessage = "\u00a7cMax players must be between 1 and 20";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.statusMessage = "\u00a7cInvalid max players value";
                this.statusColor = 0xFF0000;
                return;
            }
        }
        TunnelConfig.getInstance().setMaxPlayers(maxPlayers);
        this.statusMessage = "\u00a7eStarting tunnel...";
        this.statusColor = 0xFFFF00;
        String visibility = this.selectedVisibility;
        ArrayList<PortForwardingConfig> enabledPorts = new ArrayList<PortForwardingConfig>();
        for (PortForwardingConfig portConfig : this.availablePortForwards) {
            if (!portConfig.isEnabled()) continue;
            enabledPorts.add(portConfig);
        }
        new Thread(() -> {
            boolean success = this.manager.initializeTunnel((MinecraftServer)this.f_96541_.m_91092_(), visibility, serverName, enabledPorts);
            this.f_96541_.execute(() -> {
                if (success) {
                    int portCount = enabledPorts.size();
                    this.statusMessage = portCount > 0 ? "\u00a7aTunnel started with " + portCount + " additional port(s)!" : "\u00a7aTunnel started!";
                    this.statusColor = 65280;
                    this.f_96541_.m_91152_((Screen)new HostGameScreen(this.parent));
                } else {
                    this.statusMessage = "\u00a7cFailed to start. Check logs.";
                    this.statusColor = 0xFF0000;
                }
            });
        }, "Tunnely-Start").start();
    }

    private void stopTunnel() {
        this.statusMessage = "\u00a7eStopping...";
        this.statusColor = 0xFFFF00;
        this.manager.shutdownTunnel();
        this.statusMessage = "\u00a7aStopped";
        this.statusColor = 65280;
        this.f_96541_.m_91152_((Screen)new HostGameScreen(this.parent));
    }

    private void cycleActiveVisibility() {
        switch (this.currentServerVisibility) {
            case "invite_only": {
                this.currentServerVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.currentServerVisibility = "public";
                break;
            }
            case "public": {
                this.currentServerVisibility = "invite_only";
                break;
            }
            default: {
                this.currentServerVisibility = "invite_only";
            }
        }
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (status.sessionId != null) {
            this.statusMessage = "\u00a7eUpdating...";
            this.statusColor = 0xFFFF00;
            String newVisibility = this.currentServerVisibility;
            new Thread(() -> {
                boolean success = this.manager.updateServerVisibility(newVisibility);
                this.f_96541_.execute(() -> {
                    if (success) {
                        this.statusMessage = "\u00a7aUpdated!";
                        this.statusColor = 65280;
                    } else {
                        this.statusMessage = "\u00a7cFailed to update";
                        this.statusColor = 0xFF0000;
                    }
                });
            }, "Tunnely-Toggle").start();
        }
    }

    private Component getActiveVisibilityButtonText() {
        switch (this.currentServerVisibility) {
            case "public": {
                return Component.m_237113_((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return Component.m_237113_((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return Component.m_237113_((String)"\ud83d\udd12 Invite Only");
            }
        }
        return Component.m_237113_((String)"Unknown");
    }

    private void cycleVisibility() {
        switch (this.selectedVisibility) {
            case "invite_only": {
                this.selectedVisibility = "friends_only";
                break;
            }
            case "friends_only": {
                this.selectedVisibility = "public";
                break;
            }
            case "public": {
                this.selectedVisibility = "invite_only";
                break;
            }
            default: {
                this.selectedVisibility = "invite_only";
            }
        }
    }

    private Component getVisibilityButtonText() {
        switch (this.selectedVisibility) {
            case "public": {
                return Component.m_237113_((String)"\ud83c\udf10 Public");
            }
            case "friends_only": {
                return Component.m_237113_((String)"\ud83d\udc65 Friends Only");
            }
            case "invite_only": {
                return Component.m_237113_((String)"\ud83d\udd12 Invite Only");
            }
        }
        return Component.m_237113_((String)"Unknown");
    }

    private String getVisibilityDescription() {
        switch (this.selectedVisibility) {
            case "public": {
                return "Anyone can join";
            }
            case "friends_only": {
                return "Only friends can join";
            }
            case "invite_only": {
                return "Requires invitation (Most Private)";
            }
        }
        return "";
    }

    private void toggleOnlineMode() {
        TunnelConfig config;
        config.setOfflineMode(!(config = TunnelConfig.getInstance()).isOfflineMode());
        if (config.isOfflineMode()) {
            this.statusMessage = "\u00a7eOffline mode enabled - Authentication disabled";
            this.statusColor = 0xFFAA00;
        } else {
            this.statusMessage = "\u00a7aOnline mode enabled - Authentication required";
            this.statusColor = 65280;
        }
    }

    private Component getOnlineModeButtonText() {
        boolean isOffline = TunnelConfig.getInstance().isOfflineMode();
        if (isOffline) {
            return Component.m_237113_((String)"\ud83d\udd13 Offline Mode");
        }
        return Component.m_237113_((String)"\ud83d\udd12 Online Mode");
    }

    private void cycleGamemode() {
        String current;
        TunnelConfig config = TunnelConfig.getInstance();
        String next = switch (current = config.getDefaultGamemode()) {
            case "survival" -> "creative";
            case "creative" -> "adventure";
            case "adventure" -> "spectator";
            case "spectator" -> "survival";
            default -> "survival";
        };
        config.setDefaultGamemode(next);
        this.statusMessage = "\u00a7aGamemode: " + this.capitalize(next);
        this.statusColor = 65280;
    }

    private Component getGamemodeButtonText() {
        String gamemode;
        return Component.m_237113_((String)((switch (gamemode = TunnelConfig.getInstance().getDefaultGamemode()) {
            case "creative" -> "\ud83c\udfa8";
            case "adventure" -> "\ud83d\uddfa\ufe0f";
            case "spectator" -> "\ud83d\udc7b";
            default -> "\u2694\ufe0f";
        }) + " " + this.capitalize(gamemode)));
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void copyToClipboard(String text) {
        this.f_96541_.f_91068_.m_90911_(text);
        this.statusMessage = "\u00a7aCopied!";
        this.statusColor = 65280;
    }

    private int getTrackX() {
        return this.scrollRight + 6;
    }

    private int getTrackHeight() {
        return this.scrollBottom - this.scrollTop;
    }

    private int getThumbHeight(int trackHeight) {
        return Math.max(20, (int)((float)trackHeight * (float)trackHeight / (float)(this.contentHeight + 1)));
    }

    private int getThumbY(int trackTop, int trackHeight, int thumbHeight) {
        int range = Math.max(1, trackHeight - thumbHeight);
        return trackTop + (this.maxScroll == 0 ? 0 : (int)((float)this.scrollOffset / (float)this.maxScroll * (float)range));
    }

    private void registerScrollableWidget(AbstractWidget widget, int baseY) {
        this.scrollWidgets.add(widget);
        this.widgetBaseY.put(widget, baseY);
    }

    private void layoutScrollWidgets() {
        for (AbstractWidget widget : this.scrollWidgets) {
            boolean within;
            Integer baseY = this.widgetBaseY.get(widget);
            if (baseY == null) continue;
            int newY = baseY - this.scrollOffset;
            widget.m_253211_(newY);
            widget.f_93624_ = within = newY + widget.m_93694_() >= this.scrollTop && newY <= this.scrollBottom;
            widget.f_93623_ = within;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && mouseY >= (double)this.scrollTop && mouseY <= (double)this.scrollBottom && this.maxScroll > 0) {
            this.scrollOffset -= (int)(delta * 20.0);
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        TunnelManager.TunnelStatus status = this.manager.getStatus();
        if (!status.connected && this.maxScroll > 0) {
            int trackX = this.getTrackX();
            int trackTop = this.scrollTop;
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int thumbY = this.getThumbY(trackTop, trackHeight, thumbHeight);
            if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 4) && mouseY >= (double)trackTop && mouseY <= (double)this.scrollBottom) {
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.dragStartMouseY = (int)mouseY;
                    this.dragStartScrollOffset = this.scrollOffset;
                } else {
                    int page = this.scrollBottom - this.scrollTop - 20;
                    this.scrollOffset = mouseY < (double)thumbY ? Math.max(0, this.scrollOffset - page) : Math.min(this.maxScroll, this.scrollOffset + page);
                    this.layoutScrollWidgets();
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingScrollbar && this.maxScroll > 0) {
            int trackHeight = this.getTrackHeight();
            int thumbHeight = this.getThumbHeight(trackHeight);
            int range = Math.max(1, trackHeight - thumbHeight);
            int deltaY = (int)mouseY - this.dragStartMouseY;
            int deltaScroll = (int)((double)deltaY * (double)this.maxScroll / (double)range);
            this.scrollOffset = this.dragStartScrollOffset + deltaScroll;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.layoutScrollWidgets();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        int prevOffset = this.scrollOffset;
        super.m_6574_(minecraft, width, height);
        this.scrollOffset = Math.min(Math.max(prevOffset, 0), this.maxScroll);
        this.layoutScrollWidgets();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private static /* synthetic */ void lambda$init$0(Button button) {
    }
}

